/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSign;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryTrafficSignLayer
extends AbstractModifiableLayer {
    private static final String TRAFFICO_PATH = "/data/fonts/traffico/traffico.ttf";
    private static MapillaryTrafficSignLayer instance;
    private final Font traffico;

    private MapillaryTrafficSignLayer() throws IOException {
        super("Mapillary traffic signs");
        try {
            this.traffico = Font.createFont(0, MapillaryTrafficSignLayer.class.getResourceAsStream(TRAFFICO_PATH)).deriveFont(50.0f);
        }
        catch (FontFormatException e) {
            throw new IOException(I18n.tr((String)"Traffic sign font at ''{0}'' has wrong format", (Object[])new Object[]{TRAFFICO_PATH}), e);
        }
        catch (IOException e) {
            throw new IOException(I18n.tr((String)"Could not read font-file from ''{0}''", (Object[])new Object[]{TRAFFICO_PATH}), e);
        }
    }

    public static synchronized MapillaryTrafficSignLayer getInstance() throws IOException {
        if (instance == null) {
            instance = new MapillaryTrafficSignLayer();
        }
        return instance;
    }

    public boolean isModified() {
        return false;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.traffico);
        Point[] points = new Point[]{mv.getPoint(new LatLon(49.01058, 8.40743)), mv.getPoint(new LatLon(49.01116, 8.40679)), mv.getPoint(new LatLon(49.01038, 8.40636))};
        TrafficoSign[] signs = new TrafficoSign[]{TrafficoSign.getSign("de", "bicycles-only"), TrafficoSign.getSign("de", "bus-stop"), TrafficoSign.getSign("de", "pedestrian-crossing")};
        for (int i = 0; i < signs.length && i < points.length; ++i) {
            for (int j = 0; signs[i] != null && j < signs[i].getNumElements(); ++j) {
                g.setColor(signs[i].getElement(j).getColor());
                g.drawString(Character.toString(signs[i].getElement(j).getGlyph()), points[i].x - 25, points[i].y + 25);
            }
        }
        g.setColor(Color.MAGENTA);
        for (MapillaryAbstractImage img : MapillaryLayer.getInstance().getData().getImages()) {
            if (!(img instanceof MapillaryImage)) continue;
            g.fillOval(mv.getPoint((LatLon)img.getMovingLatLon()).x - 3, mv.getPoint((LatLon)img.getMovingLatLon()).y - 3, 6, 6);
            if (((MapillaryImage)img).getSigns().isEmpty()) continue;
            Point point = mv.getPoint(img.getMovingLatLon());
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Component getInfoComponent() {
        return new JLabel("Mapillary traffic sign layer");
    }

    public Action[] getMenuEntries() {
        return new Action[0];
    }
}

