/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pbf.io;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import crosby.binary.file.FileBlockPosition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class PbfReader
extends AbstractReader {
    private PbfParser parser = new PbfParser();

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        PbfReader reader = new PbfReader();
        try {
            progressMonitor.beginTask(I18n.tr((String)"Prepare OSM data...", (Object[])new Object[]{2}));
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Reading OSM data...", (Object[])new Object[0]));
            reader.parse(source);
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Preparing data set...", (Object[])new Object[0]));
            reader.prepareDataSet();
            progressMonitor.worked(1);
            DataSet dataSet = reader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalDataException((Throwable)e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void parse(InputStream source) throws IOException, IllegalDataException {
        new BlockInputStream(source, this.parser).process();
        if (this.parser.exception != null) {
            throw this.parser.exception;
        }
    }

    protected class PbfParser
    extends BinaryParser {
        public IllegalDataException exception = null;

        protected PbfParser() {
        }

        private double parseRawDegrees(long raw) {
            return (double)raw * 1.0E-9;
        }

        @Override
        protected void parse(Osmformat.HeaderBlock header) {
            Iterator iterator = header.getRequiredFeaturesList().iterator();
            block8: while (iterator.hasNext()) {
                String requiredFeature;
                switch (requiredFeature = (String)iterator.next()) {
                    case "OsmSchema-V0.6": {
                        PbfReader.this.ds.setVersion("0.6");
                        continue block8;
                    }
                    case "DenseNodes": {
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException("Unsupported feature: " + requiredFeature);
            }
            Osmformat.HeaderBBox bbox = header.getBbox();
            if (bbox != null) {
                double maxlon;
                double maxlat;
                double minlon;
                double minlat = this.parseRawDegrees(bbox.getBottom());
                Bounds b = new Bounds(minlat, minlon = this.parseRawDegrees(bbox.getLeft()), maxlat = this.parseRawDegrees(bbox.getTop()), maxlon = this.parseRawDegrees(bbox.getRight()));
                if (!b.isCollapsed() && LatLon.isValidLat((double)minlat) && LatLon.isValidLat((double)maxlat) && LatLon.isValidLon((double)minlon) && LatLon.isValidLon((double)maxlon)) {
                    ((PbfReader)PbfReader.this).ds.dataSources.add(new DataSource(b, header.getSource()));
                } else {
                    Main.error((String)("Invalid Bounds: " + b));
                }
            }
        }

        @Override
        public boolean skipBlock(FileBlockPosition block) {
            return this.exception != null;
        }

        protected void checkCoordinates(LatLon coor) throws IllegalDataException {
            if (!coor.isValid()) {
                throw new IllegalDataException(I18n.tr((String)"Invalid coordinates: {0}", (Object[])new Object[]{coor}));
            }
        }

        protected void checkChangesetId(long id) throws IllegalDataException {
            if (id > Integer.MAX_VALUE) {
                throw new IllegalDataException(I18n.tr((String)"Invalid changeset id: {0}", (Object[])new Object[]{id}));
            }
        }

        protected void checkTimestamp(long timestamp) throws IllegalDataException {
            if (timestamp < 0L) {
                throw new IllegalDataException(I18n.tr((String)"Invalid timestamp: {0}", (Object[])new Object[]{timestamp}));
            }
        }

        @Override
        protected void parseDense(Osmformat.DenseNodes nodes) {
            if (this.exception == null) {
                try {
                    int keyIndex = 0;
                    long nodeId = 0L;
                    long nodeLat = 0L;
                    long nodeLon = 0L;
                    long changesetId = 0L;
                    int uid = 0;
                    int suid = 0;
                    long timestamp = 0L;
                    for (int i = 0; i < nodes.getIdCount(); ++i) {
                        int key_id;
                        Node node = new Node(nodeId += nodes.getId(i), nodes.getDenseinfo().getVersion(i));
                        node.setCoor(new LatLon(this.parseLat(nodeLat += nodes.getLat(i)), this.parseLon(nodeLon += nodes.getLon(i))).getRoundedToOsmPrecision());
                        this.checkCoordinates(node.getCoor());
                        this.checkChangesetId(changesetId += nodes.getDenseinfo().getChangeset(i));
                        node.setChangesetId((int)changesetId);
                        node.setUser(User.createOsmUser((long)(uid += nodes.getDenseinfo().getUid(i)), (String)this.getStringById(suid += nodes.getDenseinfo().getUserSid(i))));
                        this.checkTimestamp(timestamp += nodes.getDenseinfo().getTimestamp(i));
                        node.setTimestamp(new Date((long)this.date_granularity * timestamp));
                        HashMap<String, String> keys = new HashMap<String, String>();
                        while (keyIndex < nodes.getKeysValsCount() && (key_id = nodes.getKeysVals(keyIndex++)) != 0) {
                            if (keyIndex < nodes.getKeysValsCount()) {
                                int value_id = nodes.getKeysVals(keyIndex++);
                                keys.put(this.getStringById(key_id), this.getStringById(value_id));
                                continue;
                            }
                            throw new IllegalDataException(I18n.tr((String)"Invalid DenseNodes key/values table", (Object[])new Object[0]));
                        }
                        node.setKeys(keys);
                        PbfReader.this.externalIdMap.put(node.getPrimitiveId(), node);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseNodes(List<Osmformat.Node> osmNodes) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Node n : osmNodes) {
                        Osmformat.Info info = n.getInfo();
                        Node node = new Node(n.getId(), info.getVersion());
                        node.setCoor(new LatLon(this.parseLat(n.getLat()), this.parseLon(n.getLon())).getRoundedToOsmPrecision());
                        this.checkCoordinates(node.getCoor());
                        this.checkChangesetId(info.getChangeset());
                        node.setChangesetId((int)info.getChangeset());
                        node.setUser(User.createOsmUser((long)info.getUid(), (String)this.getStringById(info.getUserSid())));
                        this.checkTimestamp(info.getTimestamp());
                        node.setTimestamp(this.getDate(info));
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < n.getKeysCount(); ++i) {
                            keys.put(this.getStringById(n.getKeys(i)), this.getStringById(n.getVals(i)));
                        }
                        node.setKeys(keys);
                        PbfReader.this.externalIdMap.put(node.getPrimitiveId(), node);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseWays(List<Osmformat.Way> osmWays) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Way w : osmWays) {
                        Osmformat.Info info = w.getInfo();
                        Way way = new Way(w.getId(), info.getVersion());
                        this.checkChangesetId(info.getChangeset());
                        way.setChangesetId((int)info.getChangeset());
                        way.setUser(User.createOsmUser((long)info.getUid(), (String)this.getStringById(info.getUserSid())));
                        this.checkTimestamp(info.getTimestamp());
                        way.setTimestamp(this.getDate(info));
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < w.getKeysCount(); ++i) {
                            keys.put(this.getStringById(w.getKeys(i)), this.getStringById(w.getVals(i)));
                        }
                        way.setKeys(keys);
                        long previousId = 0L;
                        ArrayList<Long> nodeIds = new ArrayList<Long>();
                        for (Long id : w.getRefsList()) {
                            nodeIds.add(previousId += id.longValue());
                        }
                        PbfReader.this.ways.put(way.getUniqueId(), nodeIds);
                        PbfReader.this.externalIdMap.put(way.getPrimitiveId(), way);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseRelations(List<Osmformat.Relation> osmRels) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Relation r : osmRels) {
                        Osmformat.Info info = r.getInfo();
                        Relation rel = new Relation(r.getId(), info.getVersion());
                        this.checkChangesetId(info.getChangeset());
                        rel.setChangesetId((int)info.getChangeset());
                        rel.setUser(User.createOsmUser((long)info.getUid(), (String)this.getStringById(info.getUserSid())));
                        this.checkTimestamp(info.getTimestamp());
                        rel.setTimestamp(this.getDate(info));
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < r.getKeysCount(); ++i) {
                            keys.put(this.getStringById(r.getKeys(i)), this.getStringById(r.getVals(i)));
                        }
                        rel.setKeys(keys);
                        long previousId = 0L;
                        ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>();
                        for (int i = 0; i < r.getMemidsCount(); ++i) {
                            long id = previousId += r.getMemids(i);
                            String role = this.getStringById(r.getRolesSid(i));
                            OsmPrimitiveType type = null;
                            switch (r.getTypes(i)) {
                                case NODE: {
                                    type = OsmPrimitiveType.NODE;
                                    break;
                                }
                                case WAY: {
                                    type = OsmPrimitiveType.WAY;
                                    break;
                                }
                                case RELATION: {
                                    type = OsmPrimitiveType.RELATION;
                                }
                            }
                            members.add(new RelationMemberData(role, type, id));
                        }
                        PbfReader.this.relations.put(rel.getUniqueId(), members);
                        PbfReader.this.externalIdMap.put(rel.getPrimitiveId(), rel);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        public void complete() {
        }
    }
}

