/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.multitagger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.utilsplugin2.multitagger.MultiTaggerTableModel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MultiTagDialog
extends ExtendedDialog
implements SelectionChangedListener {
    private final MultiTaggerTableModel tableModel = new MultiTaggerTableModel();
    private final JTable tbl;
    private final HighlightHelper highlightHelper = new HighlightHelper();
    private final HistoryComboBox cbTagSet = new HistoryComboBox();
    private List<OsmPrimitive> currentSelection;
    private static final String HISTORY_KEY = "utilsplugin2.multitaghistory";
    String[] defaultHistory = new String[]{"addr:street, addr:housenumber, building, ${area}", "highway, name, ${id}, ${length}", "name name:en name:ru name:de"};
    private final MouseAdapter tableMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && Main.isDisplayingMapView()) {
                AutoScaleAction.zoomTo((Collection)MultiTagDialog.this.currentSelection);
            }
        }
    };
    private final ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MultiTagDialog.this.currentSelection = MultiTagDialog.this.getSelectedPrimitives();
            if (MultiTagDialog.this.currentSelection != null && Main.isDisplayingMapView() && MultiTagDialog.this.highlightHelper.highlightOnly((Collection)MultiTagDialog.this.currentSelection)) {
                Main.map.mapView.repaint();
            }
        }
    };
    private final TagSetChanger tagSetChanger = new TagSetChanger();

    public MultiTagDialog() {
        super(Main.parent, I18n.tr((String)"Edit tags", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
        JPanel pnl = new JPanel(new GridBagLayout());
        this.tbl = this.createTable();
        this.cbTagSet.addItemListener((ItemListener)this.tagSetChanger);
        this.cbTagSet.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, true), "applyTagSet");
        this.cbTagSet.getActionMap().put("applyTagSet", this.tagSetChanger);
        this.tbl.addMouseListener((MouseListener)new PopupMenuLauncher(this.createPopupMenu()));
        pnl.add((Component)this.cbTagSet, GBC.std().fill(2));
        pnl.add((Component)new JButton(new DeleteFromHistoryAction()), GBC.std());
        pnl.add((Component)new JButton(new FindMatchingAction()), GBC.std());
        final JToggleButton jt = new JToggleButton("", ImageProvider.get((String)"restart"), true);
        jt.setToolTipText(I18n.tr((String)"Sync with JOSM selection", (Object[])new Object[0]));
        jt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTagDialog.this.tableModel.setWatchSelection(jt.isSelected());
            }
        });
        pnl.add((Component)jt, GBC.eol());
        pnl.add((Component)this.createTypeFilterPanel(), GBC.eol().fill(2));
        pnl.add((Component)this.tbl.getTableHeader(), GBC.eop().fill(2));
        pnl.add((Component)new JScrollPane(this.tbl), GBC.eol().fill(1));
        this.setContent(pnl);
        this.setDefaultButton(-1);
        this.loadHistory();
        WindowGeometry defaultGeometry = WindowGeometry.centerInWindow((Component)Main.parent, (Dimension)new Dimension(500, 500));
        this.setRememberWindowGeometry(((Object)((Object)this)).getClass().getName() + ".geometry", defaultGeometry);
    }

    private JTable createTable() {
        JTable t = new JTable(this.tableModel);
        this.tableModel.setTable(t);
        t.setFillsViewportHeight(true);
        t.setSelectionMode(2);
        t.addMouseListener(this.tableMouseAdapter);
        t.setRowSelectionAllowed(true);
        t.setColumnSelectionAllowed(true);
        t.setDefaultRenderer(OsmPrimitiveType.class, new PrimitiveTypeIconRenderer());
        t.setDefaultRenderer(String.class, new ColoredRenderer());
        t.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        t.getSelectionModel().addListSelectionListener(this.selectionListener);
        return t;
    }

    private JPanel createTypeFilterPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        for (final OsmPrimitiveType type : OsmPrimitiveType.values()) {
            final JToggleButton jt = new JToggleButton("", ImageProvider.get((OsmPrimitiveType)type), true);
            jt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (jt.isSelected()) {
                        ((MultiTagDialog)MultiTagDialog.this).tableModel.shownTypes.add(type);
                    } else {
                        ((MultiTagDialog)MultiTagDialog.this).tableModel.shownTypes.remove(type);
                    }
                    MultiTagDialog.this.tableModel.updateData(Main.getLayerManager().getEditDataSet().getSelected());
                }
            });
            ImageProvider.get((OsmPrimitiveType)type);
            p.add(jt);
        }
        return p;
    }

    private void loadHistory() {
        LinkedList cmtHistory = new LinkedList(Main.pref.getCollection(HISTORY_KEY, Arrays.asList(this.defaultHistory)));
        Collections.reverse(cmtHistory);
        this.cbTagSet.setPossibleItems(cmtHistory);
        String s = (String)cmtHistory.get(cmtHistory.size() - 1);
        this.cbTagSet.setText(s);
        this.specifyTagSet(s);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.highlightHelper.clear();
        this.tbl.getSelectionModel().removeListSelectionListener(this.selectionListener);
        super.buttonAction(buttonIndex, evt);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.tableModel.selectionChanged(newSelection);
    }

    public List<OsmPrimitive> getSelectedPrimitives() {
        ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>(100);
        for (int idx : this.tbl.getSelectedRows()) {
            sel.add(this.tableModel.getPrimitiveAt(this.tbl.convertRowIndexToModel(idx)));
        }
        return sel;
    }

    private void initAutocompletion() {
        OsmDataLayer l = Main.getLayerManager().getEditLayer();
        AutoCompletionManager autocomplete = l.data.getAutoCompletionManager();
        for (int i = 0; i < this.tableModel.mainTags.length; ++i) {
            if (this.tableModel.isSpecialTag[i]) continue;
            AutoCompletingTextField tf = new AutoCompletingTextField(0, false);
            AutoCompletionList acList = new AutoCompletionList();
            autocomplete.populateWithTagValues(acList, this.tableModel.mainTags[i]);
            tf.setAutoCompletionList(acList);
            this.tbl.getColumnModel().getColumn(i + 1).setCellEditor((TableCellEditor)tf);
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction(I18n.tr((String)"Zoom to objects", (Object[])new Object[0]), ImageProvider.get((String)"dialogs/autoscale", (String)"selection")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.isDisplayingMapView()) {
                    AutoScaleAction.zoomTo((Collection)MultiTagDialog.this.currentSelection);
                }
            }
        });
        menu.add(new AbstractAction(I18n.tr((String)"Select", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"select")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.getLayerManager().getEditDataSet().setSelected(MultiTagDialog.this.getSelectedPrimitives());
            }
        });
        menu.add(new AbstractAction(I18n.tr((String)"Remove tag", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTagDialog.this.tableModel.setAutoCommit(false);
                for (int c : MultiTagDialog.this.tbl.getSelectedColumns()) {
                    for (int r : MultiTagDialog.this.tbl.getSelectedRows()) {
                        MultiTagDialog.this.tableModel.setValueAt("", MultiTagDialog.this.tbl.convertRowIndexToModel(r), MultiTagDialog.this.tbl.convertColumnIndexToModel(c));
                    }
                }
                MultiTagDialog.this.tableModel.commit(I18n.tr((String)"Delete tags from multiple objects", (Object[])new Object[0]));
                MultiTagDialog.this.tableModel.setAutoCommit(true);
            }
        });
        menu.add(new AbstractAction(I18n.tr((String)"Duplicate tags from the first", (Object[])new Object[0]), ImageProvider.get((String)"copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTagDialog.this.tableModel.setAutoCommit(false);
                for (int c : MultiTagDialog.this.tbl.getSelectedColumns()) {
                    if (c == 0 || ((MultiTagDialog)MultiTagDialog.this).tableModel.isSpecialTag[c - 1]) continue;
                    boolean first = true;
                    String value = "";
                    for (int r : MultiTagDialog.this.tbl.getSelectedRows()) {
                        if (first) {
                            value = (String)MultiTagDialog.this.tableModel.getValueAt(MultiTagDialog.this.tbl.convertRowIndexToModel(r), MultiTagDialog.this.tbl.convertColumnIndexToModel(c));
                        }
                        first = false;
                        MultiTagDialog.this.tableModel.setValueAt(value, MultiTagDialog.this.tbl.convertRowIndexToModel(r), MultiTagDialog.this.tbl.convertColumnIndexToModel(c));
                    }
                }
                MultiTagDialog.this.tableModel.commit(I18n.tr((String)"Set tags for multiple objects", (Object[])new Object[0]));
                MultiTagDialog.this.tableModel.setAutoCommit(true);
            }
        });
        return menu;
    }

    private void specifyTagSet(String s) {
        Main.info((String)("Multitagger tags=" + s));
        this.tableModel.setupColumnsFromText(s);
        this.tbl.createDefaultColumnsFromModel();
        this.tbl.setAutoCreateRowSorter(true);
        this.tbl.getColumnModel().getColumn(0).setMaxWidth(20);
        for (int i = 1; i < this.tableModel.getColumnCount(); ++i) {
            TableHelper.adjustColumnWidth((JTable)this.tbl, (int)i, (int)100);
        }
        this.initAutocompletion();
        this.tableModel.fireTableDataChanged();
    }

    class ColoredRenderer
    extends DefaultTableCellRenderer {
        private final Color highlightColor = Main.pref.getColor(I18n.marktr((String)"Multitag Background: highlight"), new Color(255, 255, 200));

        ColoredRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int row1 = MultiTagDialog.this.tbl.convertRowIndexToModel(row);
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (MultiTagDialog.this.tbl.isRowSelected(row1) && !MultiTagDialog.this.tbl.isColumnSelected(column)) {
                label.setBackground(this.highlightColor);
            } else if (isSelected) {
                label.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                label.setBackground(UIManager.getColor("Table.background"));
            }
            return label;
        }
    }

    private class TagSetChanger
    extends AbstractAction
    implements ItemListener {
        String oldTags;

        private TagSetChanger() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (MultiTagDialog.this.cbTagSet.getSelectedIndex() < 0) {
                return;
            }
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = MultiTagDialog.this.cbTagSet.getText();
            if (s == null || s.isEmpty() || s.equals(this.oldTags)) {
                return;
            }
            this.oldTags = s;
            MultiTagDialog.this.cbTagSet.addCurrentItemToHistory();
            Main.pref.putCollection(MultiTagDialog.HISTORY_KEY, (Collection)MultiTagDialog.this.cbTagSet.getHistory());
            MultiTagDialog.this.specifyTagSet(s);
        }
    }

    private class FindMatchingAction
    extends AbstractAction {
        FindMatchingAction() {
            super("", ImageProvider.get((String)"dialogs", (String)"search"));
            this.putValue("ShortDescription", I18n.tr((String)"Find primitives with these tags", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchAction.search((String)MultiTagDialog.this.tableModel.getSearchExpression(), (SearchAction.SearchMode)SearchAction.SearchMode.replace);
        }
    }

    private class DeleteFromHistoryAction
    extends AbstractAction {
        DeleteFromHistoryAction() {
            super("", ImageProvider.get((String)"dialogs", (String)"delete"));
            this.putValue("ShortDescription", I18n.tr((String)"Delete from history", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String txt = MultiTagDialog.this.cbTagSet.getText();
            System.out.println(txt);
            List<String> history = MultiTagDialog.this.cbTagSet.getHistory();
            history.remove(txt);
            if (history.isEmpty()) {
                history = Arrays.asList(MultiTagDialog.this.defaultHistory);
            }
            Main.pref.putCollection(MultiTagDialog.HISTORY_KEY, (Collection)history);
            MultiTagDialog.this.loadHistory();
        }
    }

    private static class PrimitiveTypeIconRenderer
    extends DefaultTableCellRenderer {
        private PrimitiveTypeIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                ((JLabel)c).setIcon(ImageProvider.get((OsmPrimitiveType)((OsmPrimitiveType)value)));
                ((JLabel)c).setText("");
            }
            return c;
        }
    }
}

