/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSImporterAction;
import public_transport.GTFSStopTableModel;

public class GTFSAddCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<String> typesForUndo = null;
    private GTFSStopTableModel gtfsStopTM = null;
    private String type = null;

    public GTFSAddCommand(GTFSImporterAction controller) {
        int i;
        this.gtfsStopTM = controller.getGTFSStopTableModel();
        this.type = controller.getDialog().getStoptype();
        this.workingLines = new Vector();
        this.typesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getGTFSStopTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.gtfsStopTM.getRowCount(); ++i) {
                consideredLines.add(new Integer(i));
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.gtfsStopTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) != null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        this.typesForUndo.clear();
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            this.typesForUndo.add((String)this.gtfsStopTM.getValueAt(j, 2));
            Node node = GTFSImporterAction.createNode(this.gtfsStopTM.coors.elementAt(j), (String)this.gtfsStopTM.getValueAt(j, 0), (String)this.gtfsStopTM.getValueAt(j, 1));
            this.gtfsStopTM.nodes.set(j, node);
            this.gtfsStopTM.setValueAt(I18n.tr((String)"added", (Object[])new Object[0]), j, 2);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.gtfsStopTM.nodes.elementAt(j);
            this.gtfsStopTM.nodes.set(j, null);
            this.gtfsStopTM.setValueAt(this.typesForUndo.elementAt(i), j, 2);
            if (node == null) continue;
            Main.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Enable GTFSStops", (Object[])new Object[0]);
    }
}

