/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.proposal;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;

public class ExtractAddressIntoNodeProposal
extends Proposal {
    public static boolean isApplicable(OsmPrimitive primitive) {
        if (!(primitive instanceof Way)) {
            return false;
        }
        for (String key : primitive.keySet()) {
            if (!key.startsWith("addr:")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(OsmPrimitive primitive) {
        if (!ExtractAddressIntoNodeProposal.isApplicable(primitive)) {
            return;
        }
        Way way = (Way)primitive;
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        way.accept((Visitor)visitor);
        Node addrNode = new Node(visitor.getBounds().getCenter());
        for (String key : way.keySet()) {
            if (!key.startsWith("addr")) continue;
            addrNode.put(key, way.get(key));
        }
        for (String key : addrNode.keySet()) {
            way.remove(key);
        }
        Main.getLayerManager().getEditDataSet().addPrimitive((OsmPrimitive)addrNode);
    }

    @Override
    public String toString() {
        return "Vytvo\u0159it z budovy samostatn\u00fd adresn\u00ed uzel.";
    }
}

