/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry;

import edu.princeton.cs.algs4.AssignmentProblem;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;

public final class ReplaceGeometryUtils {
    private ReplaceGeometryUtils() {
    }

    public static ReplaceGeometryCommand buildReplaceWithNewCommand(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        if (firstObject instanceof Node && secondObject instanceof Node) {
            return ReplaceGeometryUtils.buildReplaceNodeWithNewCommand((Node)firstObject, (Node)secondObject);
        }
        if (firstObject instanceof Way && secondObject instanceof Way) {
            return ReplaceGeometryUtils.buildReplaceWayWithNewCommand(Arrays.asList((Way)firstObject, (Way)secondObject));
        }
        if (firstObject instanceof Node) {
            return ReplaceGeometryUtils.buildUpgradeNodeCommand((Node)firstObject, secondObject);
        }
        if (secondObject instanceof Node) {
            return ReplaceGeometryUtils.buildUpgradeNodeCommand((Node)secondObject, firstObject);
        }
        throw new IllegalArgumentException(I18n.tr((String)"This tool can only replace a node, upgrade a node to a way or a multipolygon, or replace a way with a way.", (Object[])new Object[0]));
    }

    public static ReplaceGeometryCommand buildReplaceCommand(OsmPrimitive subjectObject, OsmPrimitive referenceSubject) {
        if (subjectObject instanceof Node && referenceSubject instanceof Node) {
            return ReplaceGeometryUtils.buildReplaceNodeCommand((Node)subjectObject, (Node)referenceSubject);
        }
        if (subjectObject instanceof Way && referenceSubject instanceof Way) {
            return ReplaceGeometryUtils.buildReplaceWayCommand((Way)subjectObject, (Way)referenceSubject);
        }
        if (subjectObject instanceof Node) {
            return ReplaceGeometryUtils.buildUpgradeNodeCommand((Node)subjectObject, referenceSubject);
        }
        if (referenceSubject instanceof Node) {
            return ReplaceGeometryUtils.buildUpgradeNodeCommand((Node)referenceSubject, subjectObject);
        }
        throw new IllegalArgumentException(I18n.tr((String)"This tool can only replace a node, upgrade a node to a way or a multipolygon, or replace a way with a way.", (Object[])new Object[0]));
    }

    public static ReplaceGeometryCommand buildReplaceNodeWithNewCommand(Node firstNode, Node secondNode) {
        if (firstNode.isNew() && !secondNode.isNew()) {
            return ReplaceGeometryUtils.buildReplaceNodeCommand(secondNode, firstNode);
        }
        if (!firstNode.isNew() && secondNode.isNew()) {
            return ReplaceGeometryUtils.buildReplaceNodeCommand(firstNode, secondNode);
        }
        return ReplaceGeometryUtils.buildReplaceNodeCommand(firstNode, secondNode);
    }

    public static ReplaceGeometryCommand buildReplaceNodeCommand(Node subjectNode, Node referenceNode) {
        if (!OsmPrimitive.getFilteredList((Collection)subjectNode.getReferrers(), Way.class).isEmpty()) {
            throw new ReplaceGeometryException(I18n.tr((String)"Node belongs to way(s), cannot replace.", (Object[])new Object[0]));
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        Command c = MergeNodesAction.mergeNodes((OsmDataLayer)Main.getLayerManager().getEditLayer(), Arrays.asList(subjectNode, referenceNode), (Node)referenceNode);
        if (c == null) {
            return null;
        }
        commands.add(c);
        return new ReplaceGeometryCommand(I18n.tr((String)"Replace geometry for node {0}", (Object[])new Object[]{subjectNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands);
    }

    public static ReplaceGeometryCommand buildUpgradeNodeCommand(Node subjectNode, OsmPrimitive referenceObject) {
        if (!OsmPrimitive.getFilteredList((Collection)subjectNode.getReferrers(), Way.class).isEmpty()) {
            throw new ReplaceGeometryException(I18n.tr((String)"Node belongs to way(s), cannot replace.", (Object[])new Object[0]));
        }
        if (referenceObject instanceof Relation && !((Relation)referenceObject).isMultipolygon()) {
            throw new ReplaceGeometryException(I18n.tr((String)"Relation is not a multipolygon, cannot be used as a replacement.", (Object[])new Object[0]));
        }
        Node nodeToReplace = null;
        if (!subjectNode.isNew()) {
            HashSet<Node> nodePool = new HashSet<Node>();
            if (referenceObject instanceof Way) {
                nodePool.addAll(ReplaceGeometryUtils.getUnimportantNodes((Way)referenceObject));
            } else if (referenceObject instanceof Relation) {
                for (RelationMember member : ((Relation)referenceObject).getMembers()) {
                    if (!member.getRole().equals("outer") && !member.getRole().equals("inner") || !member.isWay()) continue;
                    nodePool.addAll(ReplaceGeometryUtils.getUnimportantNodes(member.getWay()));
                }
            } else assert (false);
            nodeToReplace = ReplaceGeometryUtils.findNearestNode(subjectNode, nodePool);
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        TagMap nodeTags = subjectNode.getKeys();
        try {
            commands.addAll(ReplaceGeometryUtils.getTagConflictResolutionCommands((OsmPrimitive)subjectNode, referenceObject));
        }
        catch (UserCancelException e) {
            return null;
        }
        if (nodeToReplace != null) {
            Way parentWay = (Way)nodeToReplace.getReferrers().get(0);
            List wayNodes = parentWay.getNodes();
            int idx = wayNodes.indexOf(nodeToReplace);
            wayNodes.set(idx, subjectNode);
            if (idx == 0 && parentWay.isClosed()) {
                wayNodes.set(wayNodes.size() - 1, subjectNode);
            }
            commands.add((Command)new ChangeNodesCommand(parentWay, wayNodes));
            commands.add((Command)new MoveCommand(subjectNode, nodeToReplace.getCoor()));
            commands.add((Command)new DeleteCommand((OsmPrimitive)nodeToReplace));
            if (!nodeTags.isEmpty()) {
                for (String key : nodeTags.keySet()) {
                    commands.add((Command)new ChangePropertyCommand((OsmPrimitive)subjectNode, key, null));
                }
            }
        } else {
            commands.add((Command)new DeleteCommand((OsmPrimitive)subjectNode));
        }
        Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{referenceObject});
        return new ReplaceGeometryCommand(I18n.tr((String)"Replace geometry for node {0}", (Object[])new Object[]{subjectNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands);
    }

    public static ReplaceGeometryCommand buildReplaceWayWithNewCommand(List<Way> selection) {
        int idxNew;
        boolean overrideNewCheck = false;
        int n = idxNew = selection.get(0).isNew() ? 0 : 1;
        if (selection.get(1 - idxNew).isNew()) {
            boolean areNewNodes = false;
            for (Node n2 : selection.get(0).getNodes()) {
                if (!n2.isNew()) continue;
                areNewNodes = true;
            }
            idxNew = areNewNodes ? 0 : 1;
            overrideNewCheck = true;
            for (Node n2 : selection.get(1 - idxNew).getNodes()) {
                if (!n2.isNew()) continue;
                overrideNewCheck = false;
            }
        }
        Way referenceWay = selection.get(idxNew);
        Way subjectWay = selection.get(1 - idxNew);
        if (!(overrideNewCheck || !subjectWay.isNew() && referenceWay.isNew())) {
            throw new ReplaceGeometryException(I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry.", (Object[])new Object[0]));
        }
        return ReplaceGeometryUtils.buildReplaceWayCommand(subjectWay, referenceWay);
    }

    public static ReplaceGeometryCommand buildReplaceWayCommand(Way subjectWay, Way referenceWay) {
        Area a = Main.getLayerManager().getEditDataSet().getDataSourceArea();
        if (!ReplaceGeometryUtils.isInArea(subjectWay, a) || !ReplaceGeometryUtils.isInArea(referenceWay, a)) {
            throw new ReplaceGeometryException(I18n.tr((String)"The ways must be entirely within the downloaded area.", (Object[])new Object[0]));
        }
        if (ReplaceGeometryUtils.hasImportantNode(referenceWay, subjectWay)) {
            throw new ReplaceGeometryException(I18n.tr((String)"The way to be replaced cannot have any nodes with properties or relation memberships unless they belong to both ways.", (Object[])new Object[0]));
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        try {
            commands.addAll(ReplaceGeometryUtils.getTagConflictResolutionCommands((OsmPrimitive)referenceWay, (OsmPrimitive)subjectWay));
        }
        catch (UserCancelException e) {
            Main.trace((Throwable)e);
            return null;
        }
        List<Node> nodePool = ReplaceGeometryUtils.getUnimportantNodes(subjectWay);
        LinkedList<Node> geometryPool = new LinkedList<Node>();
        for (Node node : referenceWay.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)referenceWay) || subjectWay.containsNode(node) || ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)node) || geometryPool.contains(node)) continue;
            geometryPool.add(node);
        }
        boolean useRobust = Main.pref.getBoolean("utilsplugin2.replace-geometry.robustAssignment", true);
        HashMap<Node, Node> nodeAssoc = new HashMap<Node, Node>();
        if (geometryPool.size() > 0 && nodePool.size() > 0) {
            if (useRobust) {
                int gLen = geometryPool.size();
                int nLen = nodePool.size();
                int N = Math.max(gLen, nLen);
                double[][] cost = new double[N][N];
                for (int i = 0; i < N; ++i) {
                    for (int j = 0; j < N; ++j) {
                        cost[i][j] = Double.MAX_VALUE;
                    }
                }
                double maxDistance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
                for (int i = 0; i < nLen; ++i) {
                    for (int j = 0; j < gLen; ++j) {
                        double d = nodePool.get(i).getCoor().distance(((Node)geometryPool.get(j)).getCoor());
                        cost[i][j] = d > maxDistance ? Double.MAX_VALUE : d;
                    }
                }
                try {
                    AssignmentProblem assignment = new AssignmentProblem(cost);
                    for (int i = 0; i < N; ++i) {
                        int nIdx = i;
                        int gIdx = assignment.sol(i);
                        if (cost[nIdx][gIdx] == Double.MAX_VALUE) continue;
                        nodeAssoc.put((Node)geometryPool.get(gIdx), nodePool.get(nIdx));
                    }
                    for (Node n : nodeAssoc.values()) {
                        nodePool.remove(n);
                    }
                }
                catch (Exception e) {
                    useRobust = false;
                    new Notification(I18n.tr((String)"Exceeded iteration limit for robust method, using simpler method.", (Object[])new Object[0])).setIcon(2).show();
                    nodeAssoc = new HashMap();
                }
            }
            if (!useRobust) {
                for (Node n : geometryPool) {
                    Node nearest = ReplaceGeometryUtils.findNearestNode(n, nodePool);
                    if (nearest == null) continue;
                    nodeAssoc.put(n, nearest);
                    nodePool.remove(nearest);
                }
            }
        }
        for (Node n : geometryPool) {
            if (!nodeAssoc.containsKey(n)) continue;
            nodePool.add(n);
        }
        List geometryNodes = referenceWay.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, (Node)nodeAssoc.get(geometryNodes.get(i)));
        }
        commands.add((Command)new ChangeNodesCommand(subjectWay, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add((Command)new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        Main.getLayerManager().getEditDataSet().clearSelection(new PrimitiveId[]{referenceWay});
        commands.add((Command)new DeleteCommand((OsmPrimitive)referenceWay));
        if (!nodePool.isEmpty()) {
            commands.add((Command)new DeleteCommand(nodePool));
        }
        return new ReplaceGeometryCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{subjectWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands);
    }

    protected static List<Node> getUnimportantNodes(Way way) {
        LinkedList<Node> nodePool = new LinkedList<Node>();
        for (Node n : way.getNodes()) {
            List referrers = n.getReferrers();
            if (n.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)n) || nodePool.contains(n)) continue;
            nodePool.add(n);
        }
        return nodePool;
    }

    protected static boolean hasImportantNode(Way geometry, Way way) {
        for (Node n : way.getNodes()) {
            if (geometry.containsNode(n)) continue;
            for (OsmPrimitive o : n.getReferrers()) {
                if (!(o instanceof Relation)) continue;
                return true;
            }
            if (!ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)n)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasInterestingKey(OsmPrimitive object) {
        for (String key : object.getKeys().keySet()) {
            if (OsmPrimitive.isUninterestingKey((String)key)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInArea(Node node, Area area) {
        LatLon ll = node.getCoor();
        return node.isNewOrUndeleted() || area == null || ll == null || area.contains(ll.getX(), ll.getY());
    }

    protected static boolean isInArea(Way way, Area area) {
        if (area == null) {
            return true;
        }
        for (Node n : way.getNodes()) {
            if (ReplaceGeometryUtils.isInArea(n, area)) continue;
            return false;
        }
        return true;
    }

    protected static List<Command> getTagConflictResolutionCommands(OsmPrimitive source, OsmPrimitive target) throws UserCancelException {
        List<OsmPrimitive> primitives = Arrays.asList(source, target);
        return CombinePrimitiveResolverDialog.launchIfNecessary((TagCollection)TagCollection.unionOfAllPrimitives(primitives), primitives, Collections.singleton(target));
    }

    protected static Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance(coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }
}

