/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtractPointAction
extends JosmAction {
    public ExtractPointAction() {
        super(I18n.tr((String)"Extract node", (Object[])new Object[0]), "extnode", I18n.tr((String)"Extracts node from a way", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:extnode", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Extract node"}), (int)74, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/ExtractNode"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        List selectedNodes = OsmPrimitive.getFilteredList((Collection)selection, Node.class);
        if (selectedNodes.size() != 1) {
            new Notification(I18n.tr((String)"This tool extracts node from its ways and requires single node to be selected.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        Node nd = (Node)selectedNodes.get(0);
        Node ndCopy = new Node(nd.getCoor());
        LinkedList<Object> cmds = new LinkedList<Object>();
        Point p = Main.map.mapView.getMousePosition();
        if (p != null) {
            cmds.add(new MoveCommand(nd, Main.map.mapView.getLatLon(p.x, p.y)));
        }
        List refs = nd.getReferrers();
        cmds.add(new AddCommand((OsmPrimitive)ndCopy));
        for (OsmPrimitive pr : refs) {
            if (!(pr instanceof Way)) continue;
            Way w = (Way)pr;
            List nodes = w.getNodes();
            int idx = nodes.indexOf(nd);
            nodes.set(idx, ndCopy);
            cmds.add(new ChangeNodesCommand(w, nodes));
        }
        if (cmds.size() > 1) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Extract node from line", (Object[])new Object[0]), cmds));
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selection.size() == 1);
    }
}

