/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.imaging.common.RationalNumber;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryUtils {
    private static final double MIN_ZOOM_SQUARE_SIDE = 0.002;

    private MapillaryUtils() {
    }

    public static void browse(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
            }
            catch (URISyntaxException e1) {
                throw new IOException(e1);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("xdg-open " + url);
        }
    }

    public static String currentDate() {
        return new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", Locale.UK).format(Calendar.getInstance().getTime());
    }

    public static long currentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static long getEpoch(String date, String format) throws ParseException {
        return new SimpleDateFormat(format, Locale.UK).parse(date).getTime();
    }

    public static double degMinSecToDouble(RationalNumber[] degMinSec, String ref) {
        if (degMinSec == null || degMinSec.length != 3) {
            throw new IllegalArgumentException("Array's length must be 3.");
        }
        for (int i = 0; i < 3; ++i) {
            if (degMinSec[i] != null) continue;
            throw new IllegalArgumentException("Null value in array.");
        }
        switch (ref) {
            case "N": 
            case "S": 
            case "E": 
            case "W": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ref.");
            }
        }
        double result = degMinSec[0].doubleValue();
        result += degMinSec[1].doubleValue() / 60.0;
        result += degMinSec[2].doubleValue() / 3600.0;
        if ("S".equals(ref) || "W".equals(ref)) {
            result *= -1.0;
        }
        result = 360.0 * ((result + 180.0) / 360.0 - Math.floor((result + 180.0) / 360.0)) - 180.0;
        return result;
    }

    public static synchronized void join(MapillaryAbstractImage imgA, MapillaryAbstractImage imgB) {
        if (imgA == null || imgB == null) {
            throw new IllegalArgumentException("Both images must be non-null for joining.");
        }
        if (imgA.getSequence() == imgB.getSequence()) {
            throw new IllegalArgumentException("You can only join images of different sequences.");
        }
        if (!(imgA.next() == null && imgB.previous() == null || imgB.next() == null && imgA.previous() == null)) {
            throw new IllegalArgumentException("You can only join an image at the end of a sequence with one at the beginning of another sequence.");
        }
        if (imgA.next() != null || imgB.previous() != null) {
            MapillaryUtils.join(imgB, imgA);
        } else {
            for (MapillaryAbstractImage img : imgB.getSequence().getImages()) {
                imgA.getSequence().add(img);
                img.setSequence(imgA.getSequence());
            }
            if (Main.main != null) {
                MapillaryData.dataUpdated();
            }
        }
    }

    public static void showAllPictures() {
        MapillaryUtils.showPictures(MapillaryLayer.getInstance().getData().getImages(), false);
    }

    public static void showPictures(Set<MapillaryAbstractImage> images, boolean select) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> MapillaryUtils.showPictures(images, select));
        } else {
            Bounds zoomBounds;
            if (images.isEmpty()) {
                zoomBounds = new Bounds(new LatLon(0.0, 0.0));
            } else {
                zoomBounds = new Bounds(images.iterator().next().getMovingLatLon());
                for (MapillaryAbstractImage img : images) {
                    zoomBounds.extend(img.getMovingLatLon());
                }
            }
            double latExtent = Math.max(zoomBounds.getMaxLat() - zoomBounds.getMinLat(), 0.002);
            double lonExtent = Math.max(zoomBounds.getMaxLon() - zoomBounds.getMinLon(), 0.002);
            zoomBounds = new Bounds(zoomBounds.getCenter(), latExtent, lonExtent);
            Main.map.mapView.zoomTo(zoomBounds);
            MapillaryLayer.getInstance().getData().setSelectedImage(null);
            if (select) {
                MapillaryLayer.getInstance().getData().addMultiSelectedImage(images);
            }
            if (Main.main != null) {
                MapillaryData.dataUpdated();
            }
        }
    }

    public static synchronized void unjoin(MapillaryAbstractImage imgA, MapillaryAbstractImage imgB) {
        if (imgA == null || imgB == null) {
            throw new IllegalArgumentException("Both images must be non-null for unjoining.");
        }
        if (imgA.getSequence() != imgB.getSequence()) {
            throw new IllegalArgumentException("You can only unjoin with two images from the same sequence.");
        }
        if (imgB.equals(imgA.next()) && imgA.equals(imgB.next())) {
            throw new IllegalArgumentException("When unjoining with two images these must be consecutive in one sequence.");
        }
        if (imgA.equals(imgB.next())) {
            MapillaryUtils.unjoin(imgB, imgA);
        } else {
            MapillarySequence seqA = new MapillarySequence();
            MapillarySequence seqB = new MapillarySequence();
            boolean insideFirstHalf = true;
            for (MapillaryAbstractImage img : imgA.getSequence().getImages()) {
                if (insideFirstHalf) {
                    img.setSequence(seqA);
                    seqA.add(img);
                } else {
                    img.setSequence(seqB);
                    seqB.add(img);
                }
                if (!img.equals(imgA)) continue;
                insideFirstHalf = false;
            }
            if (Main.main != null) {
                MapillaryData.dataUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateHelpText() {
        StringBuilder ret = new StringBuilder();
        if (PluginState.isDownloading()) {
            ret.append(I18n.tr((String)"Downloading Mapillary images", (Object[])new Object[0]));
        } else if (MapillaryLayer.getInstance().getData().size() > 0) {
            ret.append(I18n.tr((String)"Total Mapillary images: {0}", (Object[])new Object[]{MapillaryLayer.getInstance().getData().size()}));
        } else if (PluginState.isSubmittingChangeset()) {
            ret.append(I18n.tr((String)"Submitting Mapillary Changeset", (Object[])new Object[0]));
        } else {
            ret.append(I18n.tr((String)"No images found", (Object[])new Object[0]));
        }
        if (MapillaryLayer.getInstance().mode != null) {
            ret.append(" \u2014 ").append(I18n.tr((String)MapillaryLayer.getInstance().mode.toString(), (Object[])new Object[0]));
        }
        if (PluginState.isUploading()) {
            ret.append(" \u2014 ").append(PluginState.getUploadString());
        }
        Class<MapillaryUtils> clazz = MapillaryUtils.class;
        synchronized (MapillaryUtils.class) {
            Main.map.statusLine.setHelpText(ret.toString());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

