/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public final class MapViewGeometryUtil {
    private MapViewGeometryUtil() {
    }

    public static Area getNonDownloadedArea(MapView mv, Iterable<Bounds> downloadBounds) {
        Rectangle b = mv.getBounds();
        b.grow(100, 100);
        Area a = new Area(b);
        for (Bounds bounds : downloadBounds) {
            Point p1 = mv.getPoint(bounds.getMin());
            Point p2 = mv.getPoint(bounds.getMax());
            Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
            a.subtract(new Area(r));
        }
        return a;
    }

    public static Path2D getSequencePath(MapView mv, MapillarySequence seq) {
        Path2D.Double path = new Path2D.Double();
        for (MapillaryAbstractImage img : seq.getImages()) {
            if (!img.isVisible()) continue;
            Point p = mv.getPoint(img.getMovingLatLon());
            if (path.getCurrentPoint() == null) {
                path.moveTo(p.getX(), p.getY());
                continue;
            }
            path.lineTo(p.getX(), p.getY());
        }
        return path;
    }
}

