/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public final class ImageUtil {
    public static final FileFilter IMAGE_FILE_FILTER = new ImageFileFilter();

    private ImageUtil() {
    }

    public static List<MapillaryImportedImage> readImagesFrom(File f, LatLon defaultLL) throws IOException {
        ArrayList<MapillaryImportedImage> images = new ArrayList<MapillaryImportedImage>();
        if (!f.exists() || !f.canRead()) {
            throw new IOException(f.getAbsolutePath() + " not found or not readable!");
        }
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                try {
                    images.addAll(ImageUtil.readImagesFrom(child, defaultLL));
                }
                catch (IOException e) {
                    Main.error((String)(f.getAbsolutePath() + " not found or not readable!"));
                }
            }
        } else if (IMAGE_FILE_FILTER.accept(f)) {
            try (FileInputStream fis = new FileInputStream(f);){
                images.add(ImageUtil.readImageFrom(fis, f, defaultLL));
            }
        }
        return images;
    }

    private static MapillaryImportedImage readImageFrom(InputStream is, File f, LatLon defaultLL) throws IOException {
        Object latRef = null;
        Object lonRef = null;
        Object lat = null;
        Object lon = null;
        Object gpsDir = null;
        Object dateTime = null;
        try {
            ImageMetadata meta = Imaging.getMetadata((InputStream)is, null);
            if (meta instanceof JpegImageMetadata) {
                JpegImageMetadata jpegMeta = (JpegImageMetadata)meta;
                latRef = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
                lonRef = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
                lat = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
                lon = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
                gpsDir = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
                dateTime = ImageUtil.getTiffFieldValue(jpegMeta, (TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            }
        }
        catch (ImageReadException jpegMeta) {
            // empty catch block
        }
        LatLon latLon = lat instanceof RationalNumber[] && latRef != null && lon instanceof RationalNumber[] && lonRef != null ? new LatLon(MapillaryUtils.degMinSecToDouble((RationalNumber[])lat, latRef.toString()), MapillaryUtils.degMinSecToDouble((RationalNumber[])lon, lonRef.toString())) : defaultLL;
        double ca = gpsDir instanceof RationalNumber ? ((RationalNumber)gpsDir).doubleValue() : 0.0;
        if (dateTime == null) {
            return new MapillaryImportedImage(latLon, ca, f);
        }
        return new MapillaryImportedImage(latLon, ca, f, dateTime.toString());
    }

    private static Object getTiffFieldValue(JpegImageMetadata meta, TagInfo tag) {
        TiffField field = meta.findEXIFValueWithExactMatch(tag);
        if (field != null) {
            try {
                return field.getValue();
            }
            catch (ImageReadException imageReadException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class ImageFileFilter
    extends FileFilter {
        private static final byte[] JFIF_MAGIC = new byte[]{-1, -40};
        private static final byte[] PNG_MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        private final byte[] magic = new byte[Math.max(JFIF_MAGIC.length, PNG_MAGIC.length)];

        private ImageFileFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean accept(File f) {
            if (!f.canRead()) return false;
            if (!f.exists()) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            try (FileInputStream fis = new FileInputStream(f);){
                int numBytes = fis.read(this.magic);
                boolean bl = numBytes >= 0 && (Arrays.equals(JFIF_MAGIC, Arrays.copyOf(this.magic, Math.min(numBytes, JFIF_MAGIC.length))) || Arrays.equals(PNG_MAGIC, Arrays.copyOf(this.magic, Math.min(numBytes, PNG_MAGIC.length))));
                return bl;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                Main.warn((String)("IO-exception while reading file " + f.getAbsolutePath()));
                return false;
            }
        }

        @Override
        public String getDescription() {
            return I18n.tr((String)"Supported image formats (JPG and PNG)", (Object[])new Object[0]);
        }
    }
}

