/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.traffico;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSignElement;

public final class TrafficoGlyph {
    private static Map<String, Character> glyphs;

    private TrafficoGlyph() {
    }

    private static Map<String, Character> readGlyphsFromResources() {
        JsonReader reader = Json.createReader((InputStream)TrafficoSignElement.class.getResourceAsStream("/data/fonts/traffico/glyphs.json"));
        JsonObject glyphObject = reader.readObject().getJsonObject("glyphs");
        Set glyphNames = glyphObject.keySet();
        glyphs = new HashMap<String, Character>();
        for (String name : glyphNames) {
            glyphs.put(name, Character.valueOf(glyphObject.getString(name).charAt(0)));
        }
        reader.close();
        return glyphs;
    }

    public static synchronized Character getGlyph(String key) {
        if (glyphs == null) {
            glyphs = TrafficoGlyph.readGlyphsFromResources();
        }
        return glyphs.get(key);
    }
}

