/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

public class RestrictionImpl
extends OntClassImpl
implements Restriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new RestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to Restriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, Restriction.class);
        }
    };

    public RestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setOnProperty(Property prop) {
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public OntProperty getOnProperty() {
        return this.objectAs(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", OntProperty.class);
    }

    @Override
    public boolean onProperty(Property prop) {
        return this.hasPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public void removeOnProperty(Property prop) {
        this.removePropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public AllValuesFromRestriction asAllValuesFromRestriction() {
        return this.as(AllValuesFromRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction asSomeValuesFromRestriction() {
        return this.as(SomeValuesFromRestriction.class);
    }

    @Override
    public HasValueRestriction asHasValueRestriction() {
        return this.as(HasValueRestriction.class);
    }

    @Override
    public CardinalityRestriction asCardinalityRestriction() {
        return this.as(CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction asMinCardinalityRestriction() {
        return this.as(MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction asMaxCardinalityRestriction() {
        return this.as(MaxCardinalityRestriction.class);
    }

    @Override
    public boolean isAllValuesFromRestriction() {
        this.checkProfile(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        return this.hasProperty(this.getProfile().ALL_VALUES_FROM());
    }

    @Override
    public boolean isSomeValuesFromRestriction() {
        this.checkProfile(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        return this.hasProperty(this.getProfile().SOME_VALUES_FROM());
    }

    @Override
    public boolean isHasValueRestriction() {
        this.checkProfile(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        return this.hasProperty(this.getProfile().HAS_VALUE());
    }

    @Override
    public boolean isCardinalityRestriction() {
        this.checkProfile(this.getProfile().CARDINALITY(), "CARDINALITY");
        return this.hasProperty(this.getProfile().CARDINALITY());
    }

    @Override
    public boolean isMinCardinalityRestriction() {
        this.checkProfile(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        return this.hasProperty(this.getProfile().MIN_CARDINALITY());
    }

    @Override
    public boolean isMaxCardinalityRestriction() {
        this.checkProfile(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        return this.hasProperty(this.getProfile().MAX_CARDINALITY());
    }

    @Override
    public AllValuesFromRestriction convertToAllValuesFromRestriction(Resource cls) {
        this.setPropertyValue(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM", cls);
        return this.as(AllValuesFromRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction convertToSomeValuesFromRestriction(Resource cls) {
        this.setPropertyValue(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM", cls);
        return this.as(SomeValuesFromRestriction.class);
    }

    @Override
    public HasValueRestriction convertToHasValueRestriction(RDFNode value) {
        this.setPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
        return this.as(HasValueRestriction.class);
    }

    @Override
    public CardinalityRestriction convertToCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction convertToMinCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction convertToMaxCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(MaxCardinalityRestriction.class);
    }
}

