/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BRoad;
import org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes.TurnSelectionBidirectional;
import org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes.TurnSelectionUnidirectional;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.ImageRenderer;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsData;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsTable;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsTableModel;
import org.openstreetmap.josm.plugins.turnlanestagging.util.Util;

public class BuildTurnLanes
extends JPanel {
    private JScrollPane scrollPane = null;
    private PresetsTable presetsTable = null;
    private PresetsTableModel presetsTableModel = null;
    private JScrollPane lastEditsScrollPane = null;
    private PresetsTable lastEditsTable = null;
    private PresetsTableModel lastEditsTableModel = null;
    private static JCheckBox jcNone = null;
    private JPanel pnlBuildTurnLanes = null;
    private JPanel pnlDirectionalOptions = null;
    private ButtonGroup btdirectional = null;
    private JPanel pnlUnidirectionalOptions = null;
    private JPanel pnlBidirectionalOptions = null;
    private JRadioButton jrbUnidirectional = null;
    private JRadioButton jrbBidirectional = null;
    private JPanel pnlContentDirectional = null;
    public static JTextField jtfChangeRoad = new JTextField();
    static List<BRoad> listPresetRoads = null;
    PresetsData presetsData = new PresetsData();
    private static List<BRoad> listLastEditsRoads = new ArrayList<BRoad>();
    public static BRoad bRoad = new BRoad();
    public TurnSelectionBidirectional turnSelectionBidirectional = null;
    public TurnSelectionUnidirectional turnSelectionUnidirectional = null;
    public static final String ROADCHANGED = "RoadChanged";
    GridBagConstraints gbc = new GridBagConstraints();
    ActionListener actionListenerUnidirectional = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuildTurnLanes.this.startDefaultUnidirectional();
        }
    };
    ActionListener actionListenerBidirectional = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuildTurnLanes.this.startDefaultBidirectional();
        }
    };
    ActionListener jcNoneActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            PresetsTableModel presetsTableModel = new PresetsTableModel(listPresetRoads, selected);
            BuildTurnLanes.this.presetsTable.setModel(presetsTableModel);
            BuildTurnLanes.this.presetsTable.getColumnModel().getColumn(2).setCellRenderer(new ImageRenderer());
            BuildTurnLanes.this.presetsTable.adjustColumnWidth(((BuildTurnLanes)BuildTurnLanes.this).scrollPane.getViewport().getExtentSize().width);
            PresetsTableModel lasteditsTM = new PresetsTableModel(listLastEditsRoads, selected);
            BuildTurnLanes.this.lastEditsTable.setModel(lasteditsTM);
            BuildTurnLanes.this.lastEditsTable.getColumnModel().getColumn(2).setCellRenderer(new ImageRenderer());
            BuildTurnLanes.this.lastEditsTable.adjustColumnWidth(((BuildTurnLanes)BuildTurnLanes.this).scrollPane.getViewport().getExtentSize().width);
            bRoad.setNone(selected);
            if (bRoad.getName().equals("Unidirectional")) {
                jtfChangeRoad.setText(bRoad.getLanesUnid().getTagturns());
            } else {
                jtfChangeRoad.setText(bRoad.getLanesA().getTagturns() + ";" + bRoad.getLanesB().getTagturns() + ";" + bRoad.getLanesC().getTagturns());
            }
        }
    };

    public BuildTurnLanes() {
        this.turnSelectionUnidirectional = new TurnSelectionUnidirectional();
        this.turnSelectionUnidirectional.addPropertyChangeListener(new LinesChangeUnidirectionalListener());
        this.turnSelectionBidirectional = new TurnSelectionBidirectional();
        this.turnSelectionBidirectional.addPropertyChangeListener(new LinesChangeBidirectionalListener());
        this.init();
    }

    protected JScrollPane buildPresetTable() {
        listPresetRoads = new ArrayList<BRoad>(this.presetsData.dataPreset());
        this.presetsTableModel = new PresetsTableModel(listPresetRoads, false);
        this.presetsTable = new PresetsTable(this.presetsTableModel);
        this.presetsTable.getColumnModel().getColumn(2).setCellRenderer(new ImageRenderer());
        this.presetsTable.setSelectionBackground(new Color(145, 195, 242));
        this.scrollPane = new JScrollPane(this.presetsTable);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Dimension d = BuildTurnLanes.this.scrollPane.getViewport().getExtentSize();
                BuildTurnLanes.this.presetsTable.adjustColumnWidth(d.width);
            }
        });
        this.presetsTable.addMouseListener(new ClickAdapter());
        return this.scrollPane;
    }

    protected JScrollPane buildLastEditsTable() {
        ArrayList<BRoad> lastEditsRoads = new ArrayList<BRoad>();
        this.lastEditsTableModel = new PresetsTableModel(lastEditsRoads, false);
        this.lastEditsTable = new PresetsTable(this.lastEditsTableModel);
        this.lastEditsTable.getColumnModel().getColumn(2).setCellRenderer(new ImageRenderer());
        this.lastEditsTable.setSelectionBackground(new Color(252, 215, 121));
        this.lastEditsScrollPane = new JScrollPane(this.lastEditsTable);
        this.lastEditsScrollPane.setHorizontalScrollBarPolicy(30);
        this.lastEditsScrollPane.setVerticalScrollBarPolicy(20);
        this.lastEditsScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Dimension d = BuildTurnLanes.this.lastEditsScrollPane.getViewport().getExtentSize();
                BuildTurnLanes.this.lastEditsTable.adjustColumnWidth(d.width);
            }
        });
        this.lastEditsTable.addMouseListener(new ClickAdapterLastEditsTable());
        return this.lastEditsScrollPane;
    }

    public PresetsTableModel getModel() {
        return (PresetsTableModel)this.presetsTable.getModel();
    }

    protected JPanel buildDirectionalOptions() {
        this.pnlDirectionalOptions = new JPanel(new GridBagLayout());
        this.pnlUnidirectionalOptions = new JPanel(new BorderLayout());
        this.pnlBidirectionalOptions = new JPanel(new BorderLayout());
        this.pnlUnidirectionalOptions.setBorder(new SoftBevelBorder(0));
        this.pnlBidirectionalOptions.setBorder(new SoftBevelBorder(0));
        this.btdirectional = new ButtonGroup();
        this.jrbUnidirectional = new JRadioButton(ExpressionFactory.Functions.tr((String[])new String[]{"Unidirectional road"}));
        this.jrbUnidirectional.setToolTipText(ExpressionFactory.Functions.tr((String[])new String[]{"Build unidirectional road"}));
        this.jrbBidirectional = new JRadioButton(ExpressionFactory.Functions.tr((String[])new String[]{"Bidirectional road"}));
        this.jrbBidirectional.setToolTipText(ExpressionFactory.Functions.tr((String[])new String[]{"Build bidirectional road"}));
        this.btdirectional.add(this.jrbUnidirectional);
        this.btdirectional.add(this.jrbBidirectional);
        this.pnlUnidirectionalOptions.add((Component)this.jrbUnidirectional, "Center");
        this.pnlBidirectionalOptions.add((Component)this.jrbBidirectional, "Center");
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 4.0;
        this.gbc.fill = 2;
        this.pnlDirectionalOptions.add((Component)this.pnlUnidirectionalOptions, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.weightx = 4.0;
        this.gbc.fill = 2;
        this.pnlDirectionalOptions.add((Component)this.pnlBidirectionalOptions, this.gbc);
        JPanel jpNoneOpt = new JPanel(new BorderLayout());
        jpNoneOpt.setBorder(new SoftBevelBorder(0));
        jcNone = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Use \"none\""}));
        jcNone.setToolTipText(ExpressionFactory.Functions.tr((String[])new String[]{"use \"none\" instead of empty values"}));
        jcNone.addActionListener(this.jcNoneActionListener);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        jpNoneOpt.add(jcNone);
        this.pnlDirectionalOptions.add((Component)jpNoneOpt, this.gbc);
        this.jrbUnidirectional.addActionListener(this.actionListenerUnidirectional);
        this.jrbBidirectional.addActionListener(this.actionListenerBidirectional);
        return this.pnlDirectionalOptions;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(ExpressionFactory.Functions.tr((String[])new String[]{"Preset turn lanes"}), this.buildPresetTable());
        jTabbedPane.addTab(ExpressionFactory.Functions.tr((String[])new String[]{"Recently turn lanes edits"}), this.buildLastEditsTable());
        this.add((Component)jTabbedPane, "Center");
        this.pnlBuildTurnLanes = new JPanel(new BorderLayout());
        this.pnlBuildTurnLanes.add((Component)this.buildDirectionalOptions(), "North");
        this.pnlContentDirectional = new JPanel();
        this.pnlBuildTurnLanes.add((Component)this.pnlContentDirectional, "Center");
        this.add((Component)this.pnlBuildTurnLanes, "South");
        jtfChangeRoad.getDocument().addDocumentListener(new SetRoadChangeRoadListener());
        this.jrbUnidirectional.setSelected(true);
        this.startDefaultUnidirectional();
    }

    public void startDefaultUnidirectional() {
        this.jrbUnidirectional.setSelected(true);
        this.pnlContentDirectional.removeAll();
        this.pnlContentDirectional.setLayout(new GridLayout(1, 1));
        this.turnSelectionUnidirectional.setDefault(this.presetsData.defaultRoadUnidirectional(4));
        this.pnlContentDirectional.add(this.turnSelectionUnidirectional);
        this.pnlContentDirectional.revalidate();
        this.pnlContentDirectional.repaint();
    }

    public void setLanesByRoadUnidirectional(BRoad road) {
        this.jrbUnidirectional.setSelected(true);
        this.pnlContentDirectional.removeAll();
        this.pnlContentDirectional.setLayout(new GridLayout(1, 1));
        this.turnSelectionUnidirectional.setDefault(road);
        this.pnlContentDirectional.add(this.turnSelectionUnidirectional);
        this.pnlContentDirectional.revalidate();
        this.pnlContentDirectional.repaint();
    }

    public void startDefaultBidirectional() {
        this.jrbBidirectional.setSelected(true);
        this.pnlContentDirectional.removeAll();
        this.pnlContentDirectional.setLayout(new GridLayout(1, 1));
        this.turnSelectionBidirectional.setDefault(this.presetsData.defaultRoadBidirectional("forward", 3, "backward", 2));
        this.pnlContentDirectional.add(this.turnSelectionBidirectional);
        this.pnlContentDirectional.revalidate();
        this.pnlContentDirectional.repaint();
    }

    public void setLanesByRoadBidirectional(BRoad bRoad) {
        this.jrbBidirectional.setSelected(true);
        this.pnlContentDirectional.removeAll();
        this.pnlContentDirectional.setLayout(new GridLayout(1, 1));
        this.turnSelectionBidirectional.setDefault(bRoad);
        this.pnlContentDirectional.add(this.turnSelectionBidirectional);
        this.pnlContentDirectional.revalidate();
        this.pnlContentDirectional.repaint();
    }

    public void addLastEditInTable() {
        if (listLastEditsRoads.isEmpty()) {
            listLastEditsRoads.add(0, (BRoad)Util.clone(bRoad));
        } else {
            for (int i = 0; i < listLastEditsRoads.size(); ++i) {
                if (bRoad.getName().equals("Bidirectional")) {
                    if (!listLastEditsRoads.get(i).turns().equals(bRoad.turns())) continue;
                    listLastEditsRoads.remove(i);
                    continue;
                }
                if (!listLastEditsRoads.get(i).getLanesUnid().getTagturns().equals(bRoad.getLanesUnid().getTagturns())) continue;
                listLastEditsRoads.remove(i);
            }
            listLastEditsRoads.add(0, (BRoad)Util.clone(bRoad));
        }
        PresetsTableModel lasteditsTM = new PresetsTableModel(listLastEditsRoads, jcNone.isSelected());
        this.lastEditsTable.setModel(lasteditsTM);
        this.lastEditsTable.getColumnModel().getColumn(2).setCellRenderer(new ImageRenderer());
        Dimension d = this.scrollPane.getViewport().getExtentSize();
        this.lastEditsTable.adjustColumnWidth(d.width);
    }

    public void setLastEdit() {
        if (listLastEditsRoads.size() > 0) {
            if (listLastEditsRoads.get(0).getName().equals("Unidirectional")) {
                this.setLanesByRoadUnidirectional((BRoad)Util.clone(listLastEditsRoads.get(0)));
            } else {
                this.setLanesByRoadBidirectional((BRoad)Util.clone(listLastEditsRoads.get(0)));
            }
        } else {
            this.startDefaultUnidirectional();
        }
    }

    public void clearSelection() {
        this.presetsTable.clearSelection();
        this.presetsTable.getSelectionModel().clearSelection();
        this.lastEditsTable.clearSelection();
        this.lastEditsTable.getSelectionModel().clearSelection();
    }

    public List<BRoad> getListLastEditsRoads() {
        return listLastEditsRoads;
    }

    private class SetRoadChangeRoadListener
    implements DocumentListener {
        private SetRoadChangeRoadListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            bRoad.setNone(jcNone.isSelected());
            BuildTurnLanes.this.firePropertyChange(BuildTurnLanes.ROADCHANGED, null, bRoad);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    public static class LinesChangeBidirectionalListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("BidirectionalLinesChanged")) {
                bRoad = (BRoad)evt.getNewValue();
                bRoad.setName("Bidirectional");
                jtfChangeRoad.setText(bRoad.getLanesA().getTagturns() + ";" + bRoad.getLanesB().getTagturns() + ";" + bRoad.getLanesC().getTagturns());
            }
        }
    }

    public static class LinesChangeUnidirectionalListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("LinesChanged")) {
                bRoad = (BRoad)evt.getNewValue();
                jtfChangeRoad.setText(bRoad.getLanesUnid().getTagturns());
            }
        }
    }

    private class ClickAdapterLastEditsTable
    extends MouseAdapter {
        private ClickAdapterLastEditsTable() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                int rowNum = BuildTurnLanes.this.lastEditsTable.rowAtPoint(e.getPoint());
                if (((BRoad)listLastEditsRoads.get(rowNum)).getName().equals("Unidirectional")) {
                    BuildTurnLanes.this.setLanesByRoadUnidirectional((BRoad)Util.clone(listLastEditsRoads.get(rowNum)));
                } else {
                    BuildTurnLanes.this.setLanesByRoadBidirectional((BRoad)Util.clone(listLastEditsRoads.get(rowNum)));
                }
            }
        }
    }

    private class ClickAdapter
    extends MouseAdapter {
        private ClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BRoad br = new BRoad();
            if (e.getClickCount() == 1) {
                int rowNum = BuildTurnLanes.this.presetsTable.rowAtPoint(e.getPoint());
                if (listPresetRoads.get(rowNum).getName().equals("Unidirectional")) {
                    BuildTurnLanes.this.setLanesByRoadUnidirectional((BRoad)Util.clone(listPresetRoads.get(rowNum)));
                } else {
                    br = (BRoad)Util.clone(listPresetRoads.get(rowNum));
                    if (Util.isRightHandTraffic()) {
                        br.setLanesA(br.getLanesC());
                        br.setLanesC(((BRoad)Util.clone(listPresetRoads.get(rowNum))).getLanesA());
                    }
                    BuildTurnLanes.this.setLanesByRoadBidirectional(br);
                }
            }
        }
    }
}

