/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTRouteDataManager {
    Relation relation;
    private List<PTStop> ptstops = new ArrayList<PTStop>();
    private List<PTWay> ptways = new ArrayList<PTWay>();
    private List<RelationMember> failedMembers = new ArrayList<RelationMember>();

    public PTRouteDataManager(Relation relation) throws IllegalArgumentException {
        this.relation = relation;
        PTStop prev = null;
        for (RelationMember member : this.relation.getMembers()) {
            if (RouteUtils.isPTStop(member)) {
                boolean stopExists = false;
                if (prev != null) {
                    if (prev.getName() == null || prev.getName().equals("") || member.getMember().get("name") == null || member.getMember().get("name").equals("")) {
                        if (this.calculateDistanceSq(member, prev) < 4.0E-6) {
                            stopExists = true;
                        }
                    } else if (prev.getName().equalsIgnoreCase(member.getMember().get("name"))) {
                        stopExists = true;
                    }
                }
                if (stopExists) {
                    prev.addStopElement(member);
                    continue;
                }
                PTStop ptstop = new PTStop(member);
                this.ptstops.add(ptstop);
                prev = ptstop;
                continue;
            }
            if (RouteUtils.isPTWay(member)) {
                PTWay ptway = new PTWay(member);
                this.ptways.add(ptway);
                continue;
            }
            this.failedMembers.add(member);
        }
    }

    private double calculateDistanceSq(RelationMember member1, RelationMember member2) {
        LatLon coord1 = member1.getMember().getBBox().getCenter();
        LatLon coord2 = member2.getMember().getBBox().getCenter();
        return coord1.distanceSq(coord2);
    }

    public PTWay getPTWay(Way inputWay) {
        for (PTWay curr : this.ptways) {
            if (curr.isWay() && curr.getWays().get(0) == inputWay) {
                return curr;
            }
            if (!curr.isRelation()) continue;
            for (RelationMember rm : curr.getRelation().getMembers()) {
                Way wayInNestedRelation = rm.getWay();
                if (wayInNestedRelation != inputWay) continue;
                return curr;
            }
        }
        return null;
    }

    public List<PTStop> getPTStops() {
        return this.ptstops;
    }

    public List<PTWay> getPTWays() {
        return this.ptways;
    }

    public int getPTStopCount() {
        return this.ptstops.size();
    }

    public int getPTWayCount() {
        return this.ptways.size();
    }

    public PTStop getFirstStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(0);
    }

    public PTStop getLastStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(this.ptstops.size() - 1);
    }

    public List<RelationMember> getFailedMembers() {
        return this.failedMembers;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public PTStop getPTStop(long id) {
        for (PTStop stop : this.ptstops) {
            if (stop.getStopPosition() != null && stop.getStopPosition().getId() == id) {
                return stop;
            }
            if (stop.getPlatform() == null || stop.getPlatform().getId() != id) continue;
            return stop;
        }
        return null;
    }

    public PTWay getPTWay(long id) {
        for (PTWay ptway : this.ptways) {
            for (Way way : ptway.getWays()) {
                if (way.getId() != id) continue;
                return ptway;
            }
        }
        return null;
    }

    public List<PTWay> findPTWaysThatContain(Way way) {
        ArrayList<PTWay> ptwaysThatContain = new ArrayList<PTWay>();
        for (PTWay ptway : this.ptways) {
            if (!ptway.getWays().contains(way)) continue;
            ptwaysThatContain.add(ptway);
        }
        return ptwaysThatContain;
    }

    public List<PTWay> findPTWaysThatContainAsEndNode(Node node) {
        ArrayList<PTWay> ptwaysThatContain = new ArrayList<PTWay>();
        for (PTWay ptway : this.ptways) {
            List<Way> ways = ptway.getWays();
            if (ways.get(0).firstNode() != node && ways.get(0).lastNode() != node && ways.get(ways.size() - 1).firstNode() != node && ways.get(ways.size() - 1).lastNode() != node) continue;
            ptwaysThatContain.add(ptway);
        }
        return ptwaysThatContain;
    }

    public boolean isDeadendNode(Node node) {
        List<PTWay> referringPtways = this.findPTWaysThatContainAsEndNode(node);
        return referringPtways.size() <= 1;
    }

    public PTWay getNextPTWay(PTWay ptway) {
        for (int i = 0; i < this.ptways.size() - 1; ++i) {
            if (this.ptways.get(i) != ptway) continue;
            return this.ptways.get(i + 1);
        }
        return null;
    }

    public PTWay getPreviousPTWay(PTWay ptway) {
        for (int i = 1; i < this.ptways.size(); ++i) {
            if (this.ptways.get(i) != ptway) continue;
            return this.ptways.get(i - 1);
        }
        return null;
    }

    public List<PTWay> getPTWaysBetween(Way start, Way end) {
        ArrayList<Integer> potentialStartIndices = new ArrayList<Integer>();
        ArrayList<Integer> potentialEndIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.ptways.size(); ++i) {
            if (this.ptways.get(i).getWays().contains(start)) {
                potentialStartIndices.add(i);
            }
            if (!this.ptways.get(i).getWays().contains(end)) continue;
            potentialEndIndices.add(i);
        }
        ArrayList<int[]> pairList = new ArrayList<int[]>();
        for (Integer potentialStartIndex : potentialStartIndices) {
            for (Integer potentialEndIndex : potentialEndIndices) {
                if (potentialStartIndex > potentialEndIndex) continue;
                int[] pair = new int[]{potentialStartIndex, potentialEndIndex};
                pairList.add(pair);
            }
        }
        int minDifference = Integer.MAX_VALUE;
        int[] mostSuitablePair = new int[]{0, 0};
        for (int[] pair : pairList) {
            int diff = pair[1] - pair[0];
            if (diff >= minDifference) continue;
            minDifference = diff;
            mostSuitablePair = pair;
        }
        ArrayList<PTWay> result = new ArrayList<PTWay>();
        for (int i = mostSuitablePair[0]; i <= mostSuitablePair[1]; ++i) {
            result.add(this.ptways.get(i));
        }
        return result;
    }

    public Node getCommonNode(PTWay way1, PTWay way2) {
        List<Way> wayList1 = way1.getWays();
        List<Way> wayList2 = way2.getWays();
        HashSet nodeSet1 = new HashSet();
        for (Way w : wayList1) {
            nodeSet1.addAll(w.getNodes());
        }
        HashSet nodeSet2 = new HashSet();
        for (Way w : wayList2) {
            nodeSet2.addAll(w.getNodes());
        }
        for (Node n : nodeSet1) {
            if (!nodeSet2.contains(n)) continue;
            return n;
        }
        return null;
    }
}

