/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class NodeChecker
extends Checker {
    protected NodeChecker(Node node, Test test) {
        super(node, test);
    }

    protected void performSolitaryStopPositionTest() {
        List referrers = this.node.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            Way referrerWay;
            if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY) || !RouteUtils.isWaySuitableForPublicTransport(referrerWay = (Way)referrer)) continue;
            return;
        }
        ArrayList<Node> primitives = new ArrayList<Node>(1);
        primitives.add(this.node);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop_position is not part of a way", (Object[])new Object[0]), 3751, primitives);
        this.errors.add(e);
    }

    protected void performPlatformPartOfWayTest() {
        List referrers = this.node.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            Way referringWay;
            ArrayList<Node> primitives = new ArrayList<Node>(1);
            primitives.add(this.node);
            if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY) || !RouteUtils.isWaySuitableForPublicTransport(referringWay = (Way)referrer)) continue;
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Platform should not be part of a way", (Object[])new Object[0]), 3752, primitives);
            this.errors.add(e);
            return;
        }
    }

    protected void performNodePartOfStopAreaTest() {
        if (!StopUtils.verifyIfMemberOfStopArea((OsmPrimitive)this.node)) {
            ArrayList<Node> primitives = new ArrayList<Node>(1);
            primitives.add(this.node);
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop position or platform is not part of a stop area relation", (Object[])new Object[0]), 3761, primitives);
            this.errors.add(e);
        }
    }

    protected void performStopPositionComparePlatformRelations() {
        HashMap<Long, Long> stopPositionRelationIds = new HashMap<Long, Long>();
        HashMap<Long, Long> platformRelationIds = new HashMap<Long, Long>();
        for (Relation referrer : OsmPrimitive.getFilteredList((Collection)this.node.getReferrers(), Relation.class)) {
            if (referrer.get("type") == "route") {
                stopPositionRelationIds.put(referrer.getId(), referrer.getId());
                continue;
            }
            if (referrer.get("public_transport") != "stop_area") continue;
            for (RelationMember stopAreaMember : referrer.getMembers()) {
                Node stopAreaMemberFoo = stopAreaMember.getNode();
                if (stopAreaMemberFoo.get("public_transport") != "platform") continue;
                for (Relation stopAreaMemberReferrer : OsmPrimitive.getFilteredList((Collection)stopAreaMemberFoo.getReferrers(), Relation.class)) {
                    if (stopAreaMemberReferrer.get("type") != "route") continue;
                    platformRelationIds.put(stopAreaMemberReferrer.getId(), stopAreaMemberReferrer.getId());
                }
            }
        }
        if (stopPositionRelationIds.equals(platformRelationIds)) {
            return;
        }
        ArrayList<Node> primitives = new ArrayList<Node>(1);
        primitives.add(this.node);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop position and it's related platform(s) have different route relations", (Object[])new Object[0]), 3755, primitives);
        this.errors.add(e);
    }

    protected static Command fixError(TestError testError) {
        if (testError.getCode() != 3751 && testError.getCode() != 3752) {
            return null;
        }
        Node problematicNode = (Node)testError.getPrimitives().iterator().next();
        ArrayList<Node> primitivesToSelect = new ArrayList<Node>(1);
        primitivesToSelect.add(problematicNode);
        SelectCommand selectCommand = new SelectCommand(primitivesToSelect);
        selectCommand.executeCommand();
        final int[] userSelection = new int[]{0};
        final TestError errorParameter = testError;
        if (SwingUtilities.isEventDispatchThread()) {
            userSelection[0] = NodeChecker.showFixNodeTagDialog(errorParameter);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        userSelection[0] = NodeChecker.showFixNodeTagDialog(errorParameter);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (userSelection[0] == 0) {
            Node modifiedNode = new Node(problematicNode);
            if (testError.getCode() == 3751) {
                modifiedNode.put("public_transport", "platform");
                ChangeCommand command = new ChangeCommand((OsmPrimitive)problematicNode, (OsmPrimitive)modifiedNode);
                return command;
            }
            modifiedNode.put("public_transport", "stop_position");
            ChangeCommand command = new ChangeCommand((OsmPrimitive)problematicNode, (OsmPrimitive)modifiedNode);
            return command;
        }
        return null;
    }

    private static int showFixNodeTagDialog(TestError e) {
        Node problematicNode = (Node)e.getPrimitives().iterator().next();
        Main.map.mapView.zoomTo(problematicNode.getCoor());
        Object[] options = new String[]{I18n.tr((String)"Yes", (Object[])new Object[0]), I18n.tr((String)"No", (Object[])new Object[0])};
        String message = e.getCode() == 3751 ? "Do you want to change the tag public_transport=stop_position to public_transport=platform?" : "Do you want to change the tag public_transport=platform to public_transport=stop_position?";
        return JOptionPane.showOptionDialog(null, message, I18n.tr((String)"PT_Assistant Message", (Object[])new Object[0]), 0, 3, null, options, 0);
    }
}

