/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.primitives.Ints;
import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJavadocCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_KEY_PARSE_ERROR = "javadoc.parse.error";
    public static final String MSG_KEY_UNRECOGNIZED_ANTLR_ERROR = "javadoc.unrecognized.antlr.error";
    private static final ThreadLocal<Map<String, JavadocDetailNodeParser.ParseStatus>> TREE_CACHE = new ThreadLocal<Map<String, JavadocDetailNodeParser.ParseStatus>>(){

        @Override
        protected Map<String, JavadocDetailNodeParser.ParseStatus> initialValue() {
            return new HashMap<String, JavadocDetailNodeParser.ParseStatus>();
        }
    };
    private final JavadocDetailNodeParser parser = new JavadocDetailNodeParser();
    private DetailAST blockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public abstract void visitJavadocToken(DetailNode var1);

    public void beginJavadocTree(DetailNode rootAst) {
    }

    public void finishJavadocTree(DetailNode rootAst) {
    }

    public void leaveJavadocToken(DetailNode ast) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{145};
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void finishTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void visitToken(DetailAST blockCommentNode) {
        if (JavadocUtils.isJavadocComment(blockCommentNode) && AbstractJavadocCheck.isCorrectJavadocPosition(blockCommentNode)) {
            JavadocDetailNodeParser.ParseStatus result;
            this.blockCommentAst = blockCommentNode;
            String treeCacheKey = blockCommentNode.getLineNo() + ":" + blockCommentNode.getColumnNo();
            if (TREE_CACHE.get().containsKey(treeCacheKey)) {
                result = TREE_CACHE.get().get(treeCacheKey);
            } else {
                result = this.parser.parseJavadocAsDetailNode(blockCommentNode);
                TREE_CACHE.get().put(treeCacheKey, result);
            }
            if (result.getParseErrorMessage() == null) {
                this.processTree(result.getTree());
            } else {
                JavadocDetailNodeParser.ParseErrorMessage parseErrorMessage = result.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.blockCommentAst;
    }

    private static boolean isCorrectJavadocPosition(DetailAST blockComment) {
        return BlockCommentPosition.isOnClass(blockComment) || BlockCommentPosition.isOnInterface(blockComment) || BlockCommentPosition.isOnEnum(blockComment) || BlockCommentPosition.isOnMethod(blockComment) || BlockCommentPosition.isOnField(blockComment) || BlockCommentPosition.isOnConstructor(blockComment) || BlockCommentPosition.isOnEnumConstant(blockComment) || BlockCommentPosition.isOnAnnotationDef(blockComment);
    }

    private void processTree(DetailNode root) {
        this.beginJavadocTree(root);
        this.walk(root);
        this.finishJavadocTree(root);
    }

    private void walk(DetailNode root) {
        int[] defaultTokenTypes = this.getDefaultJavadocTokens();
        DetailNode curNode = root;
        while (curNode != null) {
            boolean waitsFor = Ints.contains(defaultTokenTypes, curNode.getType());
            if (waitsFor) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsFor) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }
}

