/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayDeque;
import java.util.Locale;

public class CommentsIndentationCheck
extends AbstractCheck {
    public static final String MSG_KEY_SINGLE = "comments.indentation.single";
    public static final String MSG_KEY_BLOCK = "comments.indentation.block";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST commentAst) {
        switch (commentAst.getType()) {
            case 144: 
            case 145: {
                this.visitComment(commentAst);
                break;
            }
            default: {
                String exceptionMsg = "Unexpected token type: " + commentAst.getText();
                throw new IllegalArgumentException(exceptionMsg);
            }
        }
    }

    private void visitComment(DetailAST comment) {
        DetailAST prevStmt = this.getPreviousStatement(comment);
        DetailAST nextStmt = CommentsIndentationCheck.getNextStmt(comment);
        if (!this.isTrailingComment(comment)) {
            if (CommentsIndentationCheck.isInEmptyCaseBlock(prevStmt, nextStmt)) {
                this.handleCommentInEmptyCaseBlock(prevStmt, comment, nextStmt);
            } else if (CommentsIndentationCheck.isFallThroughComment(prevStmt, nextStmt)) {
                this.handleFallThroughtComment(prevStmt, comment, nextStmt);
            } else if (CommentsIndentationCheck.isInEmptyCodeBlock(prevStmt, nextStmt)) {
                this.handleCommentInEmptyCodeBlock(comment, nextStmt);
            } else if (CommentsIndentationCheck.isCommentAtTheEndOfTheCodeBlock(nextStmt)) {
                this.handleCommentAtTheEndOfTheCodeBlock(prevStmt, comment, nextStmt);
            } else if (nextStmt != null && !this.areSameLevelIndented(comment, nextStmt, nextStmt)) {
                this.log(comment.getLineNo(), this.getMessageKey(comment), nextStmt.getLineNo(), comment.getColumnNo(), nextStmt.getColumnNo());
            }
        }
    }

    private static DetailAST getNextStmt(DetailAST comment) {
        DetailAST nextStmt;
        for (nextStmt = comment.getNextSibling(); nextStmt != null && CommentsIndentationCheck.isComment(nextStmt) && comment.getColumnNo() != nextStmt.getColumnNo(); nextStmt = nextStmt.getNextSibling()) {
        }
        return nextStmt;
    }

    private DetailAST getPreviousStatement(DetailAST comment) {
        DetailAST prevStatement = this.isDistributedPreviousStatement(comment) ? CommentsIndentationCheck.getDistributedPreviousStatement(comment) : this.getOneLinePreviousStatement(comment);
        return prevStatement;
    }

    private boolean isDistributedPreviousStatement(DetailAST comment) {
        DetailAST previousSibling = comment.getPreviousSibling();
        return this.isDistributedExpression(comment) || CommentsIndentationCheck.isDistributedReturnStatement(previousSibling) || CommentsIndentationCheck.isDistributedThrowStatement(previousSibling);
    }

    private boolean isDistributedExpression(DetailAST comment) {
        DetailAST previousSibling;
        for (previousSibling = comment.getPreviousSibling(); previousSibling != null && CommentsIndentationCheck.isComment(previousSibling); previousSibling = previousSibling.getPreviousSibling()) {
        }
        boolean isDistributed = false;
        if (previousSibling != null) {
            if (previousSibling.getType() == 45 && this.isOnPreviousLineIgnoringComments(comment, previousSibling)) {
                DetailAST currentToken = previousSibling.getPreviousSibling();
                while (currentToken.getFirstChild() != null) {
                    currentToken = currentToken.getFirstChild();
                }
                if (currentToken.getType() == 183) {
                    currentToken = currentToken.getParent();
                    while (CommentsIndentationCheck.isComment(currentToken)) {
                        currentToken = currentToken.getNextSibling();
                    }
                }
                if (previousSibling.getLineNo() != currentToken.getLineNo()) {
                    isDistributed = true;
                }
            } else {
                isDistributed = this.isStatementWithPossibleCurlies(previousSibling);
            }
        }
        return isDistributed;
    }

    private boolean isStatementWithPossibleCurlies(DetailAST previousSibling) {
        return previousSibling.getType() == 83 || previousSibling.getType() == 95 || previousSibling.getType() == 91 || previousSibling.getType() == 85 || previousSibling.getType() == 84 || previousSibling.getType() == 89 || this.isDefinition(previousSibling);
    }

    private boolean isDefinition(DetailAST previousSibling) {
        return previousSibling.getType() == 9 || previousSibling.getType() == 14 || previousSibling.getType() == 15 || previousSibling.getType() == 154 || previousSibling.getType() == 157;
    }

    private static boolean isDistributedReturnStatement(DetailAST commentPreviousSibling) {
        DetailAST firstChild;
        DetailAST nextSibling;
        boolean isDistributed = false;
        if (commentPreviousSibling != null && commentPreviousSibling.getType() == 88 && (nextSibling = (firstChild = commentPreviousSibling.getFirstChild()).getNextSibling()) != null) {
            isDistributed = true;
        }
        return isDistributed;
    }

    private static boolean isDistributedThrowStatement(DetailAST commentPreviousSibling) {
        DetailAST firstChild;
        DetailAST nextSibling;
        boolean isDistributed = false;
        if (commentPreviousSibling != null && commentPreviousSibling.getType() == 90 && (nextSibling = (firstChild = commentPreviousSibling.getFirstChild()).getNextSibling()).getLineNo() != commentPreviousSibling.getLineNo()) {
            isDistributed = true;
        }
        return isDistributed;
    }

    private static DetailAST getDistributedPreviousStatement(DetailAST comment) {
        DetailAST previousStatement;
        DetailAST currentToken = comment.getPreviousSibling();
        while (CommentsIndentationCheck.isComment(currentToken)) {
            currentToken = currentToken.getPreviousSibling();
        }
        if (currentToken.getType() == 45) {
            currentToken = currentToken.getPreviousSibling();
            while (currentToken.getFirstChild() != null) {
                currentToken = currentToken.getFirstChild();
            }
            previousStatement = currentToken;
        } else {
            previousStatement = currentToken;
        }
        return previousStatement;
    }

    private static boolean isInEmptyCaseBlock(DetailAST prevStmt, DetailAST nextStmt) {
        return !(prevStmt == null || nextStmt == null || prevStmt.getType() != 93 && prevStmt.getType() != 33 || nextStmt.getType() != 93 && nextStmt.getType() != 94);
    }

    private static boolean isFallThroughComment(DetailAST prevStmt, DetailAST nextStmt) {
        return prevStmt != null && nextStmt != null && prevStmt.getType() != 93 && (nextStmt.getType() == 93 || nextStmt.getType() == 94);
    }

    private static boolean isCommentAtTheEndOfTheCodeBlock(DetailAST nextStmt) {
        return nextStmt != null && nextStmt.getType() == 73;
    }

    private static boolean isInEmptyCodeBlock(DetailAST prevStmt, DetailAST nextStmt) {
        return prevStmt != null && nextStmt != null && (prevStmt.getType() == 7 || prevStmt.getType() == 72 || prevStmt.getType() == 29 || prevStmt.getType() == 6) && nextStmt.getType() == 73;
    }

    private void handleCommentInEmptyCaseBlock(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (comment.getColumnNo() < prevStmt.getColumnNo() || comment.getColumnNo() < nextStmt.getColumnNo()) {
            this.logMultilineIndentation(prevStmt, comment, nextStmt);
        }
    }

    private void handleFallThroughtComment(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (!this.areSameLevelIndented(comment, prevStmt, nextStmt)) {
            this.logMultilineIndentation(prevStmt, comment, nextStmt);
        }
    }

    private void handleCommentAtTheEndOfTheCodeBlock(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (prevStmt != null) {
            if (prevStmt.getType() == 93 || prevStmt.getType() == 33 || prevStmt.getType() == 94) {
                if (comment.getColumnNo() < nextStmt.getColumnNo()) {
                    this.log(comment.getLineNo(), this.getMessageKey(comment), nextStmt.getLineNo(), comment.getColumnNo(), nextStmt.getColumnNo());
                }
            } else if (CommentsIndentationCheck.isCommentForMultiblock(nextStmt)) {
                if (!this.areSameLevelIndented(comment, prevStmt, nextStmt)) {
                    this.logMultilineIndentation(prevStmt, comment, nextStmt);
                }
            } else if (!this.areSameLevelIndented(comment, prevStmt, prevStmt)) {
                int prevStmtLineNo = prevStmt.getLineNo();
                this.log(comment.getLineNo(), this.getMessageKey(comment), prevStmtLineNo, comment.getColumnNo(), this.getLineStart(prevStmtLineNo));
            }
        }
    }

    private static boolean isCommentForMultiblock(DetailAST endBlockStmt) {
        DetailAST nextBlock = endBlockStmt.getParent().getNextSibling();
        int endBlockLineNo = endBlockStmt.getLineNo();
        DetailAST catchAst = endBlockStmt.getParent().getParent();
        DetailAST finallyAst = catchAst.getNextSibling();
        return nextBlock != null && nextBlock.getLineNo() == endBlockLineNo || finallyAst != null && catchAst.getType() == 96 && finallyAst.getLineNo() == endBlockLineNo;
    }

    private void handleCommentInEmptyCodeBlock(DetailAST comment, DetailAST nextStmt) {
        if (comment.getColumnNo() < nextStmt.getColumnNo()) {
            this.log(comment.getLineNo(), this.getMessageKey(comment), nextStmt.getLineNo(), comment.getColumnNo(), nextStmt.getColumnNo());
        }
    }

    private DetailAST getOneLinePreviousStatement(DetailAST comment) {
        DetailAST root;
        for (root = comment.getParent(); root != null && !CommentsIndentationCheck.isBlockStart(root); root = root.getParent()) {
        }
        ArrayDeque<DetailAST> stack = new ArrayDeque<DetailAST>();
        DetailAST previousStatement = null;
        block1: while (root != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                root = (DetailAST)stack.pop();
            }
            while (root != null) {
                previousStatement = this.findPreviousStatement(comment, root);
                if (previousStatement != null) {
                    root = null;
                    stack.clear();
                    continue block1;
                }
                if (root.getNextSibling() != null) {
                    stack.push(root.getNextSibling());
                }
                root = root.getFirstChild();
            }
        }
        return previousStatement;
    }

    private static boolean isComment(DetailAST ast) {
        int astType = ast.getType();
        return astType == 144 || astType == 145 || astType == 183 || astType == 182;
    }

    private static boolean isBlockStart(DetailAST root) {
        return root.getType() == 7 || root.getType() == 6 || root.getType() == 29 || root.getType() == 33;
    }

    private DetailAST findPreviousStatement(DetailAST comment, DetailAST root) {
        DetailAST previousStatement = null;
        if (root.getLineNo() >= comment.getLineNo()) {
            previousStatement = CommentsIndentationCheck.getPrevStatementFromSwitchBlock(comment);
        }
        DetailAST tokenWhichBeginsTheLine = root.getType() == 28 && root.getFirstChild().getFirstChild() != null ? (root.getFirstChild().getType() == 136 ? root.getFirstChild() : CommentsIndentationCheck.findTokenWhichBeginsTheLine(root)) : (root.getType() == 125 ? root.getFirstChild() : root);
        if (tokenWhichBeginsTheLine != null && !CommentsIndentationCheck.isComment(tokenWhichBeginsTheLine) && this.isOnPreviousLineIgnoringComments(comment, tokenWhichBeginsTheLine)) {
            previousStatement = tokenWhichBeginsTheLine;
        }
        return previousStatement;
    }

    private static DetailAST findTokenWhichBeginsTheLine(DetailAST root) {
        DetailAST tokenWhichBeginsTheLine = CommentsIndentationCheck.isUsingOfObjectReferenceToInvokeMethod(root) ? CommentsIndentationCheck.findStartTokenOfMethodCallChain(root) : root.getFirstChild().findFirstToken(58);
        return tokenWhichBeginsTheLine;
    }

    private static boolean isUsingOfObjectReferenceToInvokeMethod(DetailAST root) {
        return root.getFirstChild().getFirstChild().getFirstChild() != null && root.getFirstChild().getFirstChild().getFirstChild().getNextSibling() != null;
    }

    private static DetailAST findStartTokenOfMethodCallChain(DetailAST root) {
        DetailAST startOfMethodCallChain = root;
        while (startOfMethodCallChain.getFirstChild() != null && startOfMethodCallChain.getFirstChild().getLineNo() == root.getLineNo()) {
            startOfMethodCallChain = startOfMethodCallChain.getFirstChild();
        }
        if (startOfMethodCallChain.getFirstChild() != null) {
            startOfMethodCallChain = startOfMethodCallChain.getFirstChild().getNextSibling();
        }
        return startOfMethodCallChain;
    }

    private boolean isOnPreviousLineIgnoringComments(DetailAST currentStatement, DetailAST checkedStatement) {
        DetailAST nextToken = this.getNextToken(checkedStatement);
        int distanceAim = 1;
        if (nextToken != null && CommentsIndentationCheck.isComment(nextToken)) {
            distanceAim += this.countEmptyLines(checkedStatement, currentStatement);
        }
        while (nextToken != null && nextToken != currentStatement && CommentsIndentationCheck.isComment(nextToken)) {
            if (nextToken.getType() == 145) {
                distanceAim += nextToken.getLastChild().getLineNo() - nextToken.getLineNo();
            }
            ++distanceAim;
            nextToken = nextToken.getNextSibling();
        }
        return currentStatement.getLineNo() - checkedStatement.getLineNo() == distanceAim;
    }

    private DetailAST getNextToken(DetailAST checkedStatement) {
        DetailAST nextToken = checkedStatement.getType() == 7 || checkedStatement.getType() == 29 || checkedStatement.getType() == 33 ? checkedStatement.getFirstChild() : checkedStatement.getNextSibling();
        if (nextToken != null && CommentsIndentationCheck.isComment(nextToken) && this.isTrailingComment(nextToken)) {
            nextToken = nextToken.getNextSibling();
        }
        return nextToken;
    }

    private int countEmptyLines(DetailAST startStatement, DetailAST endStatement) {
        int emptyLinesNumber = 0;
        String[] lines = this.getLines();
        int endLineNo = endStatement.getLineNo();
        for (int lineNo = startStatement.getLineNo(); lineNo < endLineNo; ++lineNo) {
            if (!CommonUtils.isBlank(lines[lineNo])) continue;
            ++emptyLinesNumber;
        }
        return emptyLinesNumber;
    }

    private void logMultilineIndentation(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        String multilineNoTemplate = "%d, %d";
        this.log(comment.getLineNo(), this.getMessageKey(comment), String.format(Locale.getDefault(), "%d, %d", prevStmt.getLineNo(), nextStmt.getLineNo()), comment.getColumnNo(), String.format(Locale.getDefault(), "%d, %d", this.getLineStart(prevStmt.getLineNo()), this.getLineStart(nextStmt.getLineNo())));
    }

    private String getMessageKey(DetailAST comment) {
        String msgKey = comment.getType() == 144 ? MSG_KEY_SINGLE : MSG_KEY_BLOCK;
        return msgKey;
    }

    private static DetailAST getPrevStatementFromSwitchBlock(DetailAST comment) {
        DetailAST parentStatement = comment.getParent();
        DetailAST prevStmt = parentStatement.getType() == 33 ? CommentsIndentationCheck.getPrevStatementWhenCommentIsUnderCase(parentStatement) : CommentsIndentationCheck.getPrevCaseToken(parentStatement);
        return prevStmt;
    }

    private static DetailAST getPrevStatementWhenCommentIsUnderCase(DetailAST parentStatement) {
        DetailAST prevStmt = null;
        DetailAST prevBlock = parentStatement.getPreviousSibling();
        if (prevBlock.getLastChild() != null) {
            DetailAST blockBody = prevBlock.getLastChild().getLastChild();
            if (blockBody.getType() == 45) {
                blockBody = blockBody.getPreviousSibling();
            }
            prevStmt = blockBody.getType() == 28 ? (CommentsIndentationCheck.isUsingOfObjectReferenceToInvokeMethod(blockBody) ? CommentsIndentationCheck.findStartTokenOfMethodCallChain(blockBody) : blockBody.getFirstChild().getFirstChild()) : (blockBody.getType() == 7 ? blockBody.getParent().getParent() : blockBody);
            if (CommentsIndentationCheck.isComment(prevStmt)) {
                prevStmt = prevStmt.getNextSibling();
            }
        }
        return prevStmt;
    }

    private static DetailAST getPrevCaseToken(DetailAST parentStatement) {
        DetailAST parentBlock = parentStatement.getParent();
        DetailAST prevCaseToken = parentBlock.getParent() != null && parentBlock.getParent().getPreviousSibling() != null && parentBlock.getParent().getPreviousSibling().getType() == 93 ? parentBlock.getParent().getPreviousSibling() : null;
        return prevCaseToken;
    }

    private boolean areSameLevelIndented(DetailAST comment, DetailAST prevStmt, DetailAST nextStmt) {
        return comment.getColumnNo() == this.getLineStart(nextStmt.getLineNo()) || comment.getColumnNo() == this.getLineStart(prevStmt.getLineNo());
    }

    private int getLineStart(int lineNo) {
        char[] line = this.getLines()[lineNo - 1].toCharArray();
        int lineStart = 0;
        while (Character.isWhitespace(line[lineStart])) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isTrailingComment(DetailAST comment) {
        boolean isTrailingComment = comment.getType() == 144 ? this.isTrailingSingleLineComment(comment) : this.isTrailingBlockComment(comment);
        return isTrailingComment;
    }

    private boolean isTrailingSingleLineComment(DetailAST singleLineComment) {
        String targetSourceLine = this.getLine(singleLineComment.getLineNo() - 1);
        int commentColumnNo = singleLineComment.getColumnNo();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, targetSourceLine);
    }

    private boolean isTrailingBlockComment(DetailAST blockComment) {
        String commentLine = this.getLine(blockComment.getLineNo() - 1);
        int commentColumnNo = blockComment.getColumnNo();
        DetailAST nextSibling = blockComment.getNextSibling();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, commentLine) || nextSibling != null && nextSibling.getLineNo() == blockComment.getLineNo();
    }
}

