/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private static final int BUFFER_SIZE = 1024;
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;

    PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        block4: {
            String currentConfigHash;
            block3: {
                FileInputStream inStream;
                block2: {
                    currentConfigHash = PropertyCacheFile.getHashCodeBasedOnObjectContent(this.config);
                    if (!new File(this.fileName).exists()) break block3;
                    inStream = null;
                    try {
                        inStream = new FileInputStream(this.fileName);
                        this.details.load(inStream);
                        String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                        if (currentConfigHash.equals(cachedConfigHash)) break block2;
                        this.details.clear();
                        this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(inStream);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly(inStream);
                break block4;
            }
            this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
        }
    }

    public void persist() throws IOException {
        Path directory = Paths.get(this.fileName, new String[0]).getParent();
        if (directory != null) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileName);
            this.details.store(out, null);
        }
        catch (Throwable throwable) {
            PropertyCacheFile.flushAndCloseOutStream(out);
            throw throwable;
        }
        PropertyCacheFile.flushAndCloseOutStream(out);
    }

    public void clear() {
        this.details.clear();
    }

    private static void flushAndCloseOutStream(OutputStream stream) throws IOException {
        if (stream != null) {
            Flushables.flush(stream, false);
        }
        Closeables.close(stream, false);
    }

    public boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(timestamp));
    }

    public void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    private static String getHashCodeBasedOnObjectContent(Serializable object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(outputStream);
                oos.writeObject(object);
            }
            catch (Throwable throwable) {
                PropertyCacheFile.flushAndCloseOutStream(oos);
                throw throwable;
            }
            PropertyCacheFile.flushAndCloseOutStream(oos);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(outputStream.toByteArray());
            return DatatypeConverter.printHexBinary((byte[])digest.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to calculate hashcode.", ex);
        }
    }

    public void putExternalResources(Set<String> locations) {
        Set<ExternalResource> resources = this.loadExternalResources(locations);
        if (this.areExternalResourcesChanged(resources)) {
            this.details.clear();
        }
        this.fillCacheWithExternalResources(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ExternalResource> loadExternalResources(Set<String> resourceLocations) {
        HashSet<ExternalResource> resources = Sets.newHashSet();
        for (String location : resourceLocations) {
            String contentHashSum = null;
            try {
                byte[] content = this.loadExternalResource(location);
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent((Serializable)content);
            }
            catch (CheckstyleException ex) {
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent(ex);
            }
            finally {
                resources.add(new ExternalResource(location, contentHashSum));
            }
        }
        return resources;
    }

    private byte[] loadExternalResource(String location) throws CheckstyleException {
        byte[] content = null;
        URI uri = CommonUtils.getUriByFilename(location);
        BufferedInputStream resourceReader = null;
        try {
            resourceReader = new BufferedInputStream(uri.toURL().openStream());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            int bytesRead = ((InputStream)resourceReader).read(data, 0, data.length);
            while (bytesRead != -1) {
                outputStream.write(data, 0, bytesRead);
                bytesRead = ((InputStream)resourceReader).read(data, 0, data.length);
            }
            outputStream.flush();
            content = outputStream.toByteArray();
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException("Unable to load external resource file " + location, ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(resourceReader);
                throw throwable;
            }
        }
        Closeables.closeQuietly(resourceReader);
        return content;
    }

    private boolean areExternalResourcesChanged(Set<ExternalResource> resources) {
        return Iterables.tryFind(resources, new Predicate<ExternalResource>(){

            @Override
            public boolean apply(ExternalResource resource) {
                boolean changed = false;
                if (PropertyCacheFile.this.isResourceLocationInCache(resource.location)) {
                    String contentHashSum = resource.contentHashSum;
                    String cachedHashSum = PropertyCacheFile.this.details.getProperty(resource.location);
                    if (!cachedHashSum.equals(contentHashSum)) {
                        changed = true;
                    }
                } else {
                    changed = true;
                }
                return changed;
            }
        }).isPresent();
    }

    private void fillCacheWithExternalResources(Set<ExternalResource> externalResources) {
        for (ExternalResource resource : externalResources) {
            if (this.isResourceLocationInCache(resource.location)) continue;
            this.details.setProperty(resource.location, resource.contentHashSum);
        }
    }

    private boolean isResourceLocationInCache(String location) {
        String cachedHashSum = this.details.getProperty(location);
        return cachedHashSum != null;
    }

    private static class ExternalResource {
        private final String location;
        private final String contentHashSum;

        ExternalResource(String location, String contentHashSum) {
            this.location = location;
            this.contentHashSum = contentHashSum;
        }
    }
}

