/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.tools.I18n;

public class SegmentChecker
extends Checker {
    private static List<PTRouteSegment> correctSegments = new ArrayList<PTRouteSegment>();
    private static HashMap<TestError, PTRouteSegment> wrongSegments = new HashMap();
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;
    private List<PTWay> unusedWays = new ArrayList<PTWay>();
    private HashMap<TestError, PTWay> erroneousPTWays = new HashMap();
    private HashMap<TestError, Node> firstNodeOfErroneousPTWay = new HashMap();

    public SegmentChecker(Relation relation, Test test) {
        super(relation, test);
        this.manager = new PTRouteDataManager(relation);
        for (RelationMember rm : this.manager.getFailedMembers()) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(relation);
            ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>(1);
            highlighted.add(rm.getMember());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Relation member roles do not match tags", (Object[])new Object[0]), 3743, primitives, highlighted);
            this.errors.add(e);
        }
        this.assigner = new StopToWayAssigner(this.manager.getPTWays());
        this.unusedWays.addAll(this.manager.getPTWays());
    }

    public static int getCorrectSegmentCount() {
        return correctSegments.size();
    }

    public static void addCorrectSegment(PTRouteSegment segment) {
        for (PTRouteSegment correctSegment : correctSegments) {
            if (!correctSegment.equalsRouteSegment(segment)) continue;
            return;
        }
        correctSegments.add(segment);
    }

    public void performFirstStopTest() {
        this.performEndStopTest(this.manager.getFirstStop());
    }

    public void performLastStopTest() {
        this.performEndStopTest(this.manager.getLastStop());
    }

    private void performEndStopTest(PTStop endStop) {
        if (endStop == null) {
            return;
        }
        if (endStop.getStopPosition() == null) {
            ArrayList<Object> highlighted;
            ArrayList<Relation> primitives;
            List<Node> potentialStopPositionList = endStop.findPotentialStopPositions();
            ArrayList<Node> stopPositionsOfThisRoute = new ArrayList<Node>();
            boolean containsAtLeastOneStopPositionAsFirstOrLastNode = false;
            for (Node potentialStopPosition : potentialStopPositionList) {
                int belongsToWay = this.belongsToAWayOfThisRoute(potentialStopPosition);
                if (belongsToWay == 0) {
                    stopPositionsOfThisRoute.add(potentialStopPosition);
                    containsAtLeastOneStopPositionAsFirstOrLastNode = true;
                }
                if (belongsToWay != 1) continue;
                stopPositionsOfThisRoute.add(potentialStopPosition);
            }
            if (stopPositionsOfThisRoute.isEmpty()) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Object>(1);
                highlighted.add(endStop.getPlatform());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route should start and end with a stop_position", (Object[])new Object[0]), 3741, primitives, highlighted);
                this.errors.add(e);
                return;
            }
            if (stopPositionsOfThisRoute.size() == 1) {
                endStop.setStopPosition((Node)stopPositionsOfThisRoute.get(0));
            }
            if (!containsAtLeastOneStopPositionAsFirstOrLastNode) {
                primitives = new ArrayList(1);
                primitives.add(this.relation);
                highlighted = new ArrayList();
                highlighted.addAll(stopPositionsOfThisRoute);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        } else {
            int belongsToWay = this.belongsToAWayOfThisRoute(endStop.getStopPosition());
            if (belongsToWay == 1) {
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Node> highlighted = new ArrayList<Node>();
                highlighted.add(endStop.getStopPosition());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        }
    }

    private int belongsToAWayOfThisRoute(Node node) {
        boolean contains = false;
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (!way.containsNode(node)) continue;
                if (way.firstNode().equals((Object)node) || way.lastNode().equals((Object)node)) {
                    return 0;
                }
                contains = true;
            }
        }
        if (contains) {
            return 1;
        }
        return -1;
    }

    public void performStopNotServedTest() {
        for (PTStop stop : this.manager.getPTStops()) {
            Way way = this.assigner.get(stop);
            if (way != null) continue;
            this.createStopError(stop);
        }
    }

    public void performStopByStopTest() {
        if (this.manager.getPTStopCount() < 2) {
            return;
        }
        for (int i = 1; i < this.manager.getPTStopCount(); ++i) {
            PTRouteSegment routeSegment;
            PTStop startStop = this.manager.getPTStops().get(i - 1);
            PTStop endStop = this.manager.getPTStops().get(i);
            Way startWay = this.assigner.get(startStop);
            Way endWay = this.assigner.get(endStop);
            if (startWay == null || endWay == null) continue;
            List<PTWay> segmentWays = this.manager.getPTWaysBetween(startWay, endWay);
            Node firstNode = this.findFirstNodeOfRouteSegmentInDirectionOfTravel(segmentWays.get(0));
            if (firstNode == null) {
                if (!this.errors.isEmpty() && ((TestError)this.errors.get(this.errors.size() - 1)).getHighlighted().size() == 1 && ((TestError)this.errors.get(this.errors.size() - 1)).getHighlighted().iterator().next() == startWay) continue;
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Way> highlighted = new ArrayList<Way>();
                highlighted.add(startWay);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                this.errors.add(e);
                PTRouteSegment routeSegment2 = new PTRouteSegment(startStop, endStop, segmentWays);
                wrongSegments.put(e, routeSegment2);
                this.erroneousPTWays.put(e, this.manager.getPTWay(startWay));
                this.firstNodeOfErroneousPTWay.put(e, null);
                continue;
            }
            boolean sortingCorrect = this.existingWaySortingIsCorrect(segmentWays.get(0), firstNode, segmentWays.get(segmentWays.size() - 1));
            if (sortingCorrect) {
                routeSegment = new PTRouteSegment(startStop, endStop, segmentWays);
                SegmentChecker.addCorrectSegment(routeSegment);
                this.unusedWays.removeAll(segmentWays);
                continue;
            }
            routeSegment = new PTRouteSegment(startStop, endStop, segmentWays);
            TestError error = (TestError)this.errors.get(this.errors.size() - 1);
            wrongSegments.put(error, routeSegment);
        }
    }

    private void createStopError(PTStop stop) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>();
        OsmPrimitive stopPrimitive = stop.getPlatform();
        if (stopPrimitive == null) {
            stopPrimitive = stop.getStopPosition();
        }
        highlighted.add(stopPrimitive);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop not served", (Object[])new Object[0]), 3753, primitives, highlighted);
        this.errors.add(e);
    }

    private Node findFirstNodeOfRouteSegmentInDirectionOfTravel(PTWay startWay) {
        Node[] startWayEndnodes = startWay.getEndNodes();
        if (this.isDeadendNode(startWayEndnodes[0])) {
            return startWayEndnodes[0];
        }
        if (this.isDeadendNode(startWayEndnodes[1])) {
            return startWayEndnodes[1];
        }
        PTWay nextWay = this.manager.getNextPTWay(startWay);
        if (nextWay == null) {
            return null;
        }
        PTWay wayAfterNext = this.manager.getNextPTWay(nextWay);
        Node[] nextWayEndnodes = nextWay.getEndNodes();
        if (startWayEndnodes[0] == nextWayEndnodes[0] && startWayEndnodes[1] == nextWayEndnodes[1] || startWayEndnodes[0] == nextWayEndnodes[1] && startWayEndnodes[1] == nextWayEndnodes[0]) {
            Node[] wayAfterNextEndnodes = wayAfterNext.getEndNodes();
            if (startWayEndnodes[0] == wayAfterNextEndnodes[0] || startWayEndnodes[0] == wayAfterNextEndnodes[1]) {
                return startWayEndnodes[0];
            }
            if (startWayEndnodes[1] == wayAfterNextEndnodes[0] || startWayEndnodes[1] == wayAfterNextEndnodes[1]) {
                return startWayEndnodes[1];
            }
        }
        if (startWayEndnodes[0] == nextWayEndnodes[0] || startWayEndnodes[0] == nextWayEndnodes[1]) {
            return startWayEndnodes[1];
        }
        if (startWayEndnodes[1] == nextWayEndnodes[0] || startWayEndnodes[1] == nextWayEndnodes[1]) {
            return startWayEndnodes[0];
        }
        return null;
    }

    private boolean isDeadendNode(Node node) {
        int count = 0;
        for (PTWay ptway : this.manager.getPTWays()) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (way.firstNode() != node && way.lastNode() != node) continue;
                ++count;
            }
        }
        return count == 1;
    }

    private Node findClosestDeadendNode(LatLon coord, List<Node> deadendNodes) {
        Node closestDeadendNode = null;
        double minSqDistance = Double.MAX_VALUE;
        for (Node deadendNode : deadendNodes) {
            double distanceSq = coord.distanceSq(deadendNode.getCoor());
            if (!(distanceSq < minSqDistance)) continue;
            minSqDistance = distanceSq;
            closestDeadendNode = deadendNode;
        }
        return closestDeadendNode;
    }

    private boolean existingWaySortingIsCorrect(PTWay start, Node startWayPreviousNodeInDirectionOfTravel, PTWay end) {
        if (start == end) {
            return true;
        }
        PTWay current = start;
        Node currentNode = startWayPreviousNodeInDirectionOfTravel;
        while (!current.equals((Object)end)) {
            PTWay nextPTWayAccortingToExistingSorting = this.manager.getNextPTWay(current);
            if (current.containsUnsplitRoundabout()) {
                currentNode = this.manager.getCommonNode(current, nextPTWayAccortingToExistingSorting);
                if (currentNode == null) {
                    ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                    primitives.add(this.relation);
                    ArrayList<Way> highlighted = new ArrayList<Way>();
                    highlighted.addAll(current.getWays());
                    TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                    this.errors.add(e);
                    this.erroneousPTWays.put(e, current);
                    return false;
                }
            } else {
                List<PTWay> nextWaysInDirectionOfTravel = this.findNextPTWaysInDirectionOfTravel(current, currentNode = this.getOppositeEndNode(current, currentNode));
                if (!nextWaysInDirectionOfTravel.contains((Object)nextPTWayAccortingToExistingSorting)) {
                    ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                    primitives.add(this.relation);
                    ArrayList<Way> highlighted = new ArrayList<Way>();
                    highlighted.addAll(current.getWays());
                    TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                    this.errors.add(e);
                    return false;
                }
            }
            current = nextPTWayAccortingToExistingSorting;
        }
        return true;
    }

    private Node getOppositeEndNode(Way way, Node node) {
        if (node == way.firstNode()) {
            return way.lastNode();
        }
        if (node == way.lastNode()) {
            return way.firstNode();
        }
        return null;
    }

    private Node getOppositeEndNode(PTWay ptway, Node node) {
        if (ptway.isWay()) {
            return this.getOppositeEndNode(ptway.getWays().get(0), node);
        }
        Way firstWay = ptway.getWays().get(0);
        Way lastWay = ptway.getWays().get(ptway.getWays().size() - 1);
        Node oppositeNode = node;
        if (firstWay.firstNode() == node || firstWay.lastNode() == node) {
            for (int i = 0; i < ptway.getWays().size(); ++i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        if (lastWay.firstNode() == node || lastWay.lastNode() == node) {
            for (int i = ptway.getWays().size() - 1; i >= 0; --i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        return null;
    }

    private List<PTWay> findNextPTWaysInDirectionOfTravel(PTWay currentWay, Node nextNodeInDirectionOfTravel) {
        ArrayList<PTWay> nextPtways = new ArrayList<PTWay>();
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            if (ptway == currentWay) continue;
            for (Way way : ptway.getWays()) {
                if (!way.containsNode(nextNodeInDirectionOfTravel)) continue;
                nextPtways.add(ptway);
            }
        }
        return nextPtways;
    }

    protected static boolean isFixable(TestError testError) {
        return testError.getCode() == 3754;
    }

    private static boolean isFixableByUsingCorrectSegment(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        PTRouteSegment correctSegment = null;
        for (PTRouteSegment segment : correctSegments) {
            if (!wrongSegment.getFirstStop().equalsStop(segment.getFirstStop()) || !wrongSegment.getLastStop().equalsStop(segment.getLastStop())) continue;
            correctSegment = segment;
            break;
        }
        return correctSegment != null;
    }

    private static boolean isFixableBySortingAndRemoval(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        List<List<PTWay>> fixVariants = wrongSegment.getFixVariants();
        return !fixVariants.isEmpty();
    }

    protected void findFixes() {
        for (TestError error : wrongSegments.keySet()) {
            this.findFix(error);
        }
    }

    private void findFix(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        PTWay startPTWay = wrongSegment.getFirstPTWay();
        PTWay endPTWay = wrongSegment.getLastPTWay();
        Node previousNode = this.findFirstNodeOfRouteSegmentInDirectionOfTravel(startPTWay);
        if (previousNode == null) {
            return;
        }
        ArrayList<List<PTWay>> initialFixes = new ArrayList<List<PTWay>>();
        ArrayList<PTWay> initialFix = new ArrayList<PTWay>();
        initialFix.add(startPTWay);
        initialFixes.add(initialFix);
        List<List<PTWay>> allFixes = this.findWaysForFix(initialFixes, initialFix, previousNode, endPTWay);
        for (List<PTWay> fix : allFixes) {
            if (fix.isEmpty() || !fix.get(fix.size() - 1).equals((Object)endPTWay)) continue;
            wrongSegment.addFixVariant(fix);
        }
    }

    private List<List<PTWay>> findWaysForFix(List<List<PTWay>> allFixes, List<PTWay> currentFix, Node previousNode, PTWay endWay) {
        Node nextNode;
        PTWay currentWay = currentFix.get(currentFix.size() - 1);
        List<PTWay> nextWays = this.findNextPTWaysInDirectionOfTravel(currentWay, nextNode = this.getOppositeEndNode(currentWay, previousNode));
        if (nextWays.size() > 1) {
            for (int i = 1; i < nextWays.size(); ++i) {
                ArrayList<PTWay> newFix = new ArrayList<PTWay>();
                newFix.addAll(currentFix);
                newFix.add(nextWays.get(i));
                allFixes.add(newFix);
                if (nextWays.get(i).equals((Object)endWay) || currentFix.contains((Object)nextWays.get(i))) continue;
                allFixes = this.findWaysForFix(allFixes, newFix, nextNode, endWay);
            }
        }
        if (!nextWays.isEmpty()) {
            boolean contains = currentFix.contains((Object)nextWays.get(0));
            currentFix.add(nextWays.get(0));
            if (!nextWays.get(0).equals((Object)endWay) && !contains) {
                allFixes = this.findWaysForFix(allFixes, currentFix, nextNode, endWay);
            }
        }
        return allFixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static Command fixError(TestError testError) {
        Object waysOfOriginalRelation2;
        ArrayList<Object> modifiedRelationMembers;
        Relation originalRelation;
        Object modifiedRelation2;
        ArrayList<OsmPrimitive> waysToZoom;
        List<PTWay> fix;
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        ArrayList<PTRouteSegment> correctSegmentsForThisError = new ArrayList<PTRouteSegment>();
        for (PTRouteSegment segment : correctSegments) {
            if (!wrongSegment.getFirstStop().equalsStop(segment.getFirstStop()) || !wrongSegment.getLastStop().equalsStop(segment.getLastStop())) continue;
            correctSegmentsForThisError.add(segment);
        }
        if (correctSegmentsForThisError.isEmpty()) {
            if (wrongSegment.getFixVariants().isEmpty()) return SegmentChecker.fixErrorByZooming(testError);
            fix = null;
            if (wrongSegment.getFixVariants().size() > 1) {
                fix = SegmentChecker.displayFixVariants(wrongSegment.getFixVariants(), testError);
                if (fix == null) {
                    return null;
                }
            } else {
                fix = wrongSegment.getFixVariants().get(0);
                waysToZoom = new ArrayList();
                for (Object highlightedPrimitive : testError.getHighlighted()) {
                    waysToZoom.add((OsmPrimitive)highlightedPrimitive);
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    AutoScaleAction.zoomTo(waysToZoom);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoScaleAction.zoomTo((Collection)waysToZoom);
                        }
                    });
                }
                modifiedRelation2 = SegmentChecker.class;
                // MONITORENTER : org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker.class
                try {
                    SegmentChecker.class.wait(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            originalRelation = (Relation)testError.getPrimitives().iterator().next();
            modifiedRelation2 = new Relation(originalRelation);
            List originalRelationMembers = originalRelation.getMembers();
            modifiedRelationMembers = new ArrayList<Object>();
            waysOfOriginalRelation2 = originalRelationMembers.iterator();
        } else {
            fix = null;
            if (correctSegmentsForThisError.size() > 1) {
                fix = SegmentChecker.displayCorrectSegmentVariants(correctSegmentsForThisError, testError);
                if (fix == null) {
                    return null;
                }
            } else {
                fix = ((PTRouteSegment)correctSegmentsForThisError.get(0)).getPTWays();
                waysToZoom = new ArrayList<OsmPrimitive>();
                for (Object highlightedPrimitive : testError.getHighlighted()) {
                    waysToZoom.add((OsmPrimitive)highlightedPrimitive);
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    AutoScaleAction.zoomTo(waysToZoom);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoScaleAction.zoomTo((Collection)waysToZoom);
                        }
                    });
                }
                Class<SegmentChecker> clazz = SegmentChecker.class;
                // MONITORENTER : org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker.class
                try {
                    SegmentChecker.class.wait(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            originalRelation = (Relation)testError.getPrimitives().iterator().next();
            Relation modifiedRelation2 = new Relation(originalRelation);
            List originalRelationMembers = originalRelation.getMembers();
            ArrayList<Object> modifiedRelationMembers2 = new ArrayList<Object>();
            for (Object rm : originalRelationMembers) {
                if (!RouteUtils.isPTStop((RelationMember)rm)) continue;
                if (rm.getRole().equals("stop_position")) {
                    RelationMember newMember;
                    if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                        newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                        modifiedRelationMembers2.add(newMember);
                        continue;
                    }
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                    modifiedRelationMembers2.add(newMember);
                    continue;
                }
                modifiedRelationMembers2.add(rm);
            }
            ArrayList<RelationMember> waysOfOriginalRelation2 = new ArrayList<RelationMember>();
            for (Object rm : originalRelation.getMembers()) {
                if (!RouteUtils.isPTWay((RelationMember)rm)) continue;
                waysOfOriginalRelation2.add((RelationMember)rm);
            }
            int i = 0;
            while (true) {
                if (i >= waysOfOriginalRelation2.size()) {
                    modifiedRelation2.setMembers(modifiedRelationMembers2);
                    wrongSegments.remove(testError);
                    return new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation2);
                }
                if (((RelationMember)waysOfOriginalRelation2.get(i)).getWay() != wrongSegment.getPTWays().get(0).getWays().get(0)) {
                    if (((RelationMember)waysOfOriginalRelation2.get(i)).getRole().equals("forward") || ((RelationMember)waysOfOriginalRelation2.get(i)).getRole().equals("backward")) {
                        modifiedRelationMembers2.add(new RelationMember("", ((RelationMember)waysOfOriginalRelation2.get(i)).getMember()));
                    } else {
                        modifiedRelationMembers2.add((RelationMember)waysOfOriginalRelation2.get(i));
                    }
                } else {
                    for (PTWay ptway : fix) {
                        if (ptway.getRole().equals("forward") || ptway.getRole().equals("backward")) {
                            modifiedRelationMembers2.add(new RelationMember("", ptway.getMember()));
                            continue;
                        }
                        modifiedRelationMembers2.add((Object)ptway);
                    }
                    i = i + wrongSegment.getPTWays().size() - 1;
                }
                ++i;
            }
        }
        while (waysOfOriginalRelation2.hasNext()) {
            RelationMember rm = (RelationMember)waysOfOriginalRelation2.next();
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getRole().equals("stop_position")) {
                RelationMember newMember;
                if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                modifiedRelationMembers.add(newMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        waysOfOriginalRelation2 = new ArrayList();
        for (RelationMember rm : originalRelation.getMembers()) {
            if (!RouteUtils.isPTWay(rm)) continue;
            waysOfOriginalRelation2.add(rm);
        }
        int i = 0;
        while (true) {
            if (i >= waysOfOriginalRelation2.size()) {
                modifiedRelation2.setMembers(modifiedRelationMembers);
                wrongSegments.remove(testError);
                wrongSegment.setPTWays(wrongSegment.getFixVariants().get(0));
                SegmentChecker.addCorrectSegment(wrongSegment);
                return new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation2);
            }
            if (((RelationMember)waysOfOriginalRelation2.get(i)).getWay() != wrongSegment.getPTWays().get(0).getWays().get(0)) {
                if (((RelationMember)waysOfOriginalRelation2.get(i)).getRole().equals("forward") || ((RelationMember)waysOfOriginalRelation2.get(i)).getRole().equals("backward")) {
                    modifiedRelationMembers.add(new RelationMember("", ((RelationMember)waysOfOriginalRelation2.get(i)).getMember()));
                } else {
                    modifiedRelationMembers.add((RelationMember)waysOfOriginalRelation2.get(i));
                }
            } else {
                for (PTWay ptway : fix) {
                    if (ptway.getRole().equals("forward") || ptway.getRole().equals("backward")) {
                        modifiedRelationMembers.add(new RelationMember("", ptway.getMember()));
                        continue;
                    }
                    modifiedRelationMembers.add((Object)ptway);
                }
                i = i + wrongSegment.getPTWays().size() - 1;
            }
            ++i;
        }
    }

    private static List<PTWay> displayCorrectSegmentVariants(List<PTRouteSegment> segments, TestError testError) {
        ArrayList<List<PTWay>> fixVariantList = new ArrayList<List<PTWay>>();
        for (PTRouteSegment segment : segments) {
            fixVariantList.add(segment.getPTWays());
        }
        return SegmentChecker.displayFixVariants(fixVariantList, testError);
    }

    private static List<PTWay> displayFixVariants(List<List<PTWay>> fixVariants, TestError testError) {
        char alphabet = 'A';
        ArrayList<Character> allowedCharacters = new ArrayList<Character>();
        for (int i = 0; i < fixVariants.size(); ++i) {
            allowedCharacters.add(Character.valueOf(alphabet));
            alphabet = (char)(alphabet + '\u0001');
        }
        final ArrayList<OsmPrimitive> waysToZoom = new ArrayList<OsmPrimitive>();
        for (Object highlightedPrimitive : testError.getHighlighted()) {
            waysToZoom.add((OsmPrimitive)highlightedPrimitive);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            AutoScaleAction.zoomTo(waysToZoom);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoScaleAction.zoomTo((Collection)waysToZoom);
                }
            });
        }
        PTAssistantValidatorTest test = (PTAssistantValidatorTest)testError.getTester();
        test.addFixVariants(fixVariants);
        PTAssistantLayer.getLayer().repaint((Relation)testError.getPrimitives().iterator().next());
        Character userInput = SegmentChecker.getUserInput(allowedCharacters);
        if (userInput == null) {
            test.clearFixVariants();
            return null;
        }
        List<PTWay> selectedFix = test.getFixVariant(userInput);
        test.clearFixVariants();
        return selectedFix;
    }

    private static Character getUserInput(List<Character> allowedCharacters) {
        final String[] userInput = new String[]{""};
        while (userInput[0] == null || userInput[0].length() != 1 || userInput[0].equals("") || !allowedCharacters.contains(Character.valueOf(userInput[0].toUpperCase().toCharArray()[0]))) {
            if (SwingUtilities.isEventDispatchThread()) {
                userInput[0] = JOptionPane.showInputDialog("Enter a letter to select the fix variant: ");
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            userInput[0] = JOptionPane.showInputDialog("Enter a letter to select the fix variant: ");
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e1) {
                    break;
                }
            }
            if (userInput[0] != null) continue;
        }
        if (userInput[0] == null) {
            return null;
        }
        return Character.valueOf(userInput[0].toCharArray()[0]);
    }

    protected static Command fixErrorByZooming(TestError testError) {
        if (testError.getCode() != 3754) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        ArrayList<OsmPrimitive> primitivesToZoom = new ArrayList<OsmPrimitive>();
        for (Object primitiveToZoom : testError.getHighlighted()) {
            primitivesToZoom.add((OsmPrimitive)primitiveToZoom);
        }
        SelectCommand command = new SelectCommand(primitivesToZoom);
        List listOfLayers = Main.getLayerManager().getLayersOfType(OsmDataLayer.class);
        for (OsmDataLayer osmDataLayer : listOfLayers) {
            if (osmDataLayer.data != originalRelation.getDataSet()) continue;
            final OsmDataLayer layerParameter = osmDataLayer;
            final Relation relationParameter = originalRelation;
            final ArrayList<OsmPrimitive> zoomParameter = primitivesToZoom;
            if (SwingUtilities.isEventDispatchThread()) {
                SegmentChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SegmentChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
                    }
                });
            }
            return command;
        }
        return null;
    }

    private static void showRelationEditorAndZoom(OsmDataLayer layer, Relation r, Collection<OsmPrimitive> primitives) {
        AutoScaleAction.zoomTo(primitives);
        List<RelationMember> sortedRelationMembers = SegmentChecker.listStopMembers(r);
        sortedRelationMembers.addAll(SegmentChecker.listNotStopMembers(r));
        r.setMembers(sortedRelationMembers);
        GenericRelationEditor editor = (GenericRelationEditor)RelationEditor.getEditor((OsmDataLayer)layer, (Relation)r, (Collection)r.getMembersFor(primitives));
        editor.setVisible(true);
        PTAssistantLayer.getLayer().repaint(r);
    }
}

