/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class PTWay
extends RelationMember {
    private List<Way> ways = new ArrayList<Way>();

    public PTWay(RelationMember other) throws IllegalArgumentException {
        super(other);
        if (other.getType().equals((Object)OsmPrimitiveType.WAY)) {
            this.ways.add(other.getWay());
        } else if (other.getType().equals((Object)OsmPrimitiveType.RELATION)) {
            for (RelationMember rm : other.getRelation().getMembers()) {
                if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    this.ways.add(rm.getWay());
                    continue;
                }
                throw new IllegalArgumentException("A route relation member of OsmPrimitiveType.RELATION can only have ways as members");
            }
        } else {
            throw new IllegalArgumentException("A node cannot be used to model a public transport way");
        }
    }

    public List<Way> getWays() {
        return this.ways;
    }

    public boolean isWay() {
        return this.getType().equals((Object)OsmPrimitiveType.WAY);
    }

    public boolean isRelation() {
        return this.getType().equals((Object)OsmPrimitiveType.RELATION);
    }

    public Node[] getEndNodes() {
        Node[] endNodes = new Node[2];
        if (this.isWay()) {
            endNodes[0] = this.getWay().firstNode();
            endNodes[1] = this.getWay().lastNode();
        } else {
            Way firstWay = this.getWays().get(0);
            Way secondWay = this.getWays().get(1);
            Way prelastWay = this.getWays().get(this.getWays().size() - 2);
            Way lastWay = this.getWays().get(this.getWays().size() - 1);
            endNodes[0] = firstWay.firstNode() == secondWay.firstNode() || firstWay.firstNode() == secondWay.lastNode() ? firstWay.lastNode() : firstWay.firstNode();
            endNodes[1] = lastWay.firstNode() == prelastWay.firstNode() || lastWay.firstNode() == prelastWay.lastNode() ? lastWay.lastNode() : lastWay.firstNode();
        }
        return endNodes;
    }

    public boolean containsUnsplitRoundabout() {
        List<Way> ways = this.getWays();
        for (Way way : ways) {
            if (way.firstNode() != way.lastNode()) continue;
            return true;
        }
        return false;
    }

    public boolean startsWithUnsplitRoundabout() {
        return this.ways.get(0).firstNode() == this.ways.get(0).lastNode();
    }

    public boolean endsWithUnsplitRoundabout() {
        return this.ways.get(this.ways.size() - 1).firstNode() == this.ways.get(this.ways.size() - 1).lastNode();
    }
}

