/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class WayChecker
extends Checker {
    public WayChecker(Relation relation, Test test) {
        super(relation, test);
    }

    protected void performRoadTypeTest() {
        if (!(this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "trolleybus") || this.relation.hasTag("route", "share_taxi"))) {
            return;
        }
        for (RelationMember rm : this.relation.getMembers()) {
            TestError e;
            ArrayList<Way> highlighted;
            ArrayList<Relation> primitives;
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            Way way = rm.getWay();
            boolean isCorrectRoadType = true;
            boolean isUnderConstruction = false;
            if (way.hasKey("construction")) {
                isUnderConstruction = true;
            }
            if (this.relation.hasTag("route", "bus") || this.relation.hasTag("route", "share_taxi")) {
                if (!RouteUtils.isWaySuitableForBuses(way)) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "trolleybus")) {
                if (!RouteUtils.isWaySuitableForBuses(way) || !way.hasTag("trolley_wire", "yes")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("highway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "tram")) {
                if (!way.hasTag("railway", "tram")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "subway")) {
                if (!way.hasTag("railway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!way.hasTag("railway", "subway")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "light_rail")) {
                if (!way.hasTag("railway", "light_rail")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction")) {
                    isUnderConstruction = true;
                }
            } else if (this.relation.hasTag("route", "train")) {
                if (!way.hasTag("railway", "rail")) {
                    isCorrectRoadType = false;
                }
                if (way.hasTag("railway", "construction")) {
                    isUnderConstruction = true;
                }
            }
            if (!isCorrectRoadType && !isUnderConstruction) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Way>(1);
                highlighted.add(way);
                e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route type does not match the type of the road it passes on", (Object[])new Object[0]), 3721, primitives, highlighted);
                this.errors.add(e);
            }
            if (!isUnderConstruction) continue;
            primitives = new ArrayList(1);
            primitives.add(this.relation);
            highlighted = new ArrayList(1);
            highlighted.add(way);
            e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Road is under construction", (Object[])new Object[0]), 3722, primitives, highlighted);
            this.errors.add(e);
        }
    }

    protected void performDirectionTest() {
        ArrayList<Way> waysToCheck = new ArrayList<Way>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                waysToCheck.add(rm.getWay());
                continue;
            }
            Relation nestedRelation = rm.getRelation();
            for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
                waysToCheck.add(nestedRelationMember.getWay());
            }
        }
        if (waysToCheck.size() <= 1) {
            return;
        }
        ArrayList<Way> problematicWays = new ArrayList<Way>();
        for (int i = 0; i < waysToCheck.size(); ++i) {
            Way next;
            Way prev;
            Way curr = (Way)waysToCheck.get(i);
            if (i == 0) {
                Way next2 = (Way)waysToCheck.get(i + 1);
                if (this.touchCorrectly(null, curr, next2)) continue;
                problematicWays.add(curr);
                continue;
            }
            if (i == waysToCheck.size() - 1) {
                prev = (Way)waysToCheck.get(i - 1);
                if (this.touchCorrectly(prev, curr, null)) continue;
                problematicWays.add(curr);
                continue;
            }
            prev = (Way)waysToCheck.get(i - 1);
            if (this.touchCorrectly(prev, curr, next = (Way)waysToCheck.get(i + 1))) continue;
            problematicWays.add(curr);
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        ArrayList listOfSets = new ArrayList();
        for (Way problematicWay : problematicWays) {
            HashSet<Way> hashSet = new HashSet<Way>();
            hashSet.add(problematicWay);
            hashSet.addAll(this.checkAdjacentWays(problematicWay, new HashSet<Way>()));
            listOfSets.add(hashSet);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < listOfSets.size(); ++i) {
                for (int j = i; j < listOfSets.size(); ++j) {
                    if (i == j || !RouteUtils.waysTouch((Collection)listOfSets.get(i), (Collection)listOfSets.get(j))) continue;
                    ((Set)listOfSets.get(i)).addAll((Collection)listOfSets.get(j));
                    listOfSets.remove(j);
                    j = listOfSets.size();
                    changed = true;
                }
            }
        }
        for (Set set : listOfSets) {
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route passes a oneway road in the wrong direction", (Object[])new Object[0]), 3731, primitives, (Collection)set);
            this.errors.add(e);
        }
    }

    private boolean touchCorrectly(Way prev, Way curr, Way next) {
        Node nodeInQuestion;
        List<Way> nb;
        if (RouteUtils.isOnewayForPublicTransport(curr) == 0) {
            return true;
        }
        if (prev != null && RouteUtils.waysTouch(curr, prev) && (nb = this.findNeighborWays(curr, nodeInQuestion = RouteUtils.isOnewayForPublicTransport(curr) == 1 ? curr.firstNode() : curr.lastNode())).size() < 2 && nodeInQuestion != prev.firstNode() && nodeInQuestion != prev.lastNode()) {
            return false;
        }
        return next == null || !RouteUtils.waysTouch(curr, next) || (nb = this.findNeighborWays(curr, nodeInQuestion = RouteUtils.isOnewayForPublicTransport(curr) == 1 ? curr.lastNode() : curr.firstNode())).size() >= 2 || nodeInQuestion == next.firstNode() || nodeInQuestion == next.lastNode();
    }

    protected Set<Way> checkAdjacentWays(Way curr, Set<Way> flags) {
        Set<Way> newSet;
        Node lastNodeInRouteDirection;
        Node firstNodeInRouteDirection;
        HashSet<Way> resultSet = new HashSet<Way>();
        resultSet.addAll(flags);
        resultSet.add(curr);
        if (RouteUtils.isOnewayForPublicTransport(curr) == 0) {
            return null;
        }
        if (RouteUtils.isOnewayForPublicTransport(curr) == 1) {
            firstNodeInRouteDirection = curr.lastNode();
            lastNodeInRouteDirection = curr.firstNode();
        } else {
            firstNodeInRouteDirection = curr.firstNode();
            lastNodeInRouteDirection = curr.lastNode();
        }
        List<Way> firstNodeInRouteDirectionNeighbors = this.findNeighborWays(curr, firstNodeInRouteDirection);
        List<Way> lastNodeInRouteDirectionNeighbors = this.findNeighborWays(curr, lastNodeInRouteDirection);
        for (Way nb : firstNodeInRouteDirectionNeighbors) {
            if (resultSet.contains(nb)) continue;
            if (RouteUtils.isOnewayForPublicTransport(nb) == 1 && nb.firstNode() == firstNodeInRouteDirection) {
                newSet = this.checkAdjacentWays(nb, resultSet);
                resultSet.addAll(newSet);
                continue;
            }
            if (RouteUtils.isOnewayForPublicTransport(nb) != -1 || nb.lastNode() != firstNodeInRouteDirection) continue;
            newSet = this.checkAdjacentWays(nb, resultSet);
            resultSet.addAll(newSet);
        }
        for (Way nb : lastNodeInRouteDirectionNeighbors) {
            if (resultSet.contains(nb)) continue;
            if (RouteUtils.isOnewayForPublicTransport(nb) == 1 && nb.lastNode() == lastNodeInRouteDirection) {
                newSet = this.checkAdjacentWays(nb, resultSet);
                resultSet.addAll(newSet);
                continue;
            }
            if (RouteUtils.isOnewayForPublicTransport(nb) != -1 || nb.firstNode() != lastNodeInRouteDirection) continue;
            newSet = this.checkAdjacentWays(nb, resultSet);
            resultSet.addAll(newSet);
        }
        return resultSet;
    }

    private List<Way> findNeighborWays(Way way, Node node) {
        ArrayList<Way> resultList = new ArrayList<Way>();
        List nodeReferrers = node.getReferrers();
        for (OsmPrimitive referrer : nodeReferrers) {
            Way neighborWay;
            if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY) || (neighborWay = (Way)referrer) == way || !this.containsWay(neighborWay)) continue;
            resultList.add(neighborWay);
        }
        return resultList;
    }

    private boolean containsWay(Way way) {
        List members = this.relation.getMembers();
        for (RelationMember rm : members) {
            if (!rm.isWay() || rm.getWay() != way) continue;
            return true;
        }
        return false;
    }

    protected static Command fixErrorByRemovingWay(TestError testError) {
        if (testError.getCode() != 3721 && testError.getCode() != 3731) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        Collection highlighted = testError.getHighlighted();
        Way wayToRemove = (Way)highlighted.iterator().next();
        Relation modifiedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
        for (RelationMember rm : originalRelation.getMembers()) {
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getRole().equals("stop_position")) {
                RelationMember newMember;
                if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                modifiedRelationMembers.add(newMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        for (RelationMember rm : originalRelation.getMembers()) {
            Way wayToCheck;
            if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
            if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                modifiedRelationMembers.add(modifiedMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        modifiedRelation.setMembers(modifiedRelationMembers);
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
        return changeCommand;
    }

    protected static Command fixErrorByZooming(TestError testError) {
        if (testError.getCode() != 3731) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        ArrayList<OsmPrimitive> primitivesToZoom = new ArrayList<OsmPrimitive>();
        for (Object primitiveToZoom : testError.getHighlighted()) {
            primitivesToZoom.add((OsmPrimitive)primitiveToZoom);
        }
        SelectCommand command = new SelectCommand(primitivesToZoom);
        List listOfLayers = Main.getLayerManager().getLayersOfType(OsmDataLayer.class);
        for (OsmDataLayer osmDataLayer : listOfLayers) {
            if (osmDataLayer.data != originalRelation.getDataSet()) continue;
            final OsmDataLayer layerParameter = osmDataLayer;
            final Relation relationParameter = originalRelation;
            final ArrayList<OsmPrimitive> zoomParameter = primitivesToZoom;
            if (SwingUtilities.isEventDispatchThread()) {
                WayChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WayChecker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
                    }
                });
            }
            return command;
        }
        return null;
    }

    private static void showRelationEditorAndZoom(OsmDataLayer layer, Relation r, Collection<OsmPrimitive> primitives) {
        AutoScaleAction.zoomTo(primitives);
        List<RelationMember> sortedRelationMembers = WayChecker.listStopMembers(r);
        sortedRelationMembers.addAll(WayChecker.listNotStopMembers(r));
        r.setMembers(sortedRelationMembers);
        GenericRelationEditor editor = (GenericRelationEditor)RelationEditor.getEditor((OsmDataLayer)layer, (Relation)r, (Collection)r.getMembersFor(primitives));
        editor.setVisible(true);
        PTAssistantLayer.getLayer().repaint(r);
    }
}

