/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;

public class PTRouteSegment {
    private PTStop firstStop;
    private PTStop lastStop;
    private List<PTWay> ptways;
    private List<List<PTWay>> fixVariants;

    public PTRouteSegment(PTStop firstStop, PTStop lastStop, List<PTWay> ways) {
        this.firstStop = firstStop;
        this.lastStop = lastStop;
        this.ptways = new ArrayList<PTWay>(ways.size());
        this.ptways.addAll(ways);
        this.fixVariants = new ArrayList<List<PTWay>>();
    }

    public List<PTWay> getPTWays() {
        return this.ptways;
    }

    public void setPTWays(List<PTWay> ptwayList) {
        this.ptways = ptwayList;
        this.fixVariants.clear();
    }

    public PTStop getFirstStop() {
        return this.firstStop;
    }

    public PTStop getLastStop() {
        return this.lastStop;
    }

    public PTWay getFirstPTWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        return this.ptways.get(0);
    }

    public PTWay getLastPTWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        return this.ptways.get(this.ptways.size() - 1);
    }

    public void addFixVariant(List<PTWay> list) {
        this.fixVariants.add(list);
    }

    public List<List<PTWay>> getFixVariants() {
        return this.fixVariants;
    }
}

