/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.preferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FilterInfo;

public class FiltersDownloader
implements ActionListener {
    private static volatile String pluginDir;
    public static Set<JsonObject> filtersMeta;
    public static Set<String> filterTitles;
    public static Set<URL> binariesLocalUrls;
    public static ClassLoader loader;
    public static Map<String, String> urlsMap;
    private static Set<JsonObject> filtersMetaToLoad;
    static List<FilterInfo> filtersInfoList;

    public static List<FilterInfo> downloadFiltersInfoList() {
        JsonObject jsonRequest = Json.createObjectBuilder().add("id", new Random().nextInt()).add("method", "wiki.getPageHTML").add("params", (JsonValue)Json.createArrayBuilder().add("ImageFilters").build()).build();
        String jsonRequestString = jsonRequest.toString();
        try {
            URL wikiApi = new URL("https://josm.openstreetmap.de/jsonrpc");
            HttpURLConnection wikiConnection = (HttpURLConnection)wikiApi.openConnection();
            wikiConnection.setDoOutput(true);
            wikiConnection.setDoInput(true);
            wikiConnection.setRequestProperty("Content-Type", "application/json");
            wikiConnection.setRequestProperty("Method", "POST");
            wikiConnection.connect();
            OutputStream os = wikiConnection.getOutputStream();
            os.write(jsonRequestString.getBytes("UTF-8"));
            os.close();
            int HttpResult = wikiConnection.getResponseCode();
            if (HttpResult == 200) {
                JsonReader jsonStream = Json.createReader((Reader)new InputStreamReader(wikiConnection.getInputStream(), "utf-8"));
                JsonObject jsonResponse = jsonStream.readObject();
                jsonStream.close();
                Elements trTagElems = Jsoup.parse(jsonResponse.getString("result")).getElementsByTag("tr");
                for (Element element : trTagElems) {
                    Elements elems = element.getElementsByTag("td");
                    if (elems.isEmpty()) continue;
                    String name = ((Element)elems.get(0)).text();
                    String owner = ((Element)elems.get(1)).text();
                    String description = ((Element)elems.get(2)).text();
                    String link = ((Element)elems.get(0)).getElementsByTag("a").attr("href");
                    JsonObject meta = FiltersDownloader.loadMeta(link);
                    String paramName = "rasterfilters." + meta.getString("name");
                    boolean needToLoad = Main.pref.getBoolean(paramName);
                    if (needToLoad) {
                        JsonArray binaries = meta.getJsonArray("binaries");
                        filterTitles.add(meta.getString("title"));
                        for (int i = 0; i < binaries.size(); ++i) {
                            filtersMetaToLoad.add(meta);
                            FiltersDownloader.loadBinaryToFile(binaries.getString(i));
                        }
                    }
                    FilterInfo newFilterInfo = new FilterInfo(name, description, meta, needToLoad);
                    newFilterInfo.setOwner(owner);
                    if (filtersInfoList.contains(newFilterInfo)) continue;
                    filtersInfoList.add(newFilterInfo);
                }
            } else {
                Main.debug((String)"Error happenned while requesting for the list of filters");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FiltersDownloader.loadBinariesFromMeta(filtersMetaToLoad);
        return filtersInfoList;
    }

    public static JsonObject loadMeta(String link) {
        Pattern p = Pattern.compile("ImageFilters/\\w.*");
        Matcher m = p.matcher(link);
        if (m.find()) {
            link = link.substring(m.start());
        }
        JsonObject jsonRequest = Json.createObjectBuilder().add("id", new Random().nextInt()).add("method", "wiki.getPageHTML").add("params", (JsonValue)Json.createArrayBuilder().add(link).build()).build();
        String jsonStringRequest = jsonRequest.toString();
        JsonObject meta = null;
        try {
            URL wikiApi = new URL("https://josm.openstreetmap.de/jsonrpc");
            HttpURLConnection wikiConnection = (HttpURLConnection)wikiApi.openConnection();
            wikiConnection.setDoOutput(true);
            wikiConnection.setDoInput(true);
            wikiConnection.setRequestProperty("Content-Type", "application/json");
            wikiConnection.setRequestProperty("Method", "POST");
            wikiConnection.connect();
            OutputStream os = wikiConnection.getOutputStream();
            os.write(jsonStringRequest.getBytes("UTF-8"));
            os.close();
            int HttpResult = wikiConnection.getResponseCode();
            if (HttpResult == 200) {
                JsonReader jsonStream = Json.createReader((Reader)new InputStreamReader(wikiConnection.getInputStream(), "UTF-8"));
                JsonObject jsonResponse = jsonStream.readObject();
                jsonStream.close();
                String jsonPage = jsonResponse.getString("result");
                Document doc = Jsoup.parse(jsonPage, "UTF-8");
                String json = doc.getElementsByTag("pre").first().text();
                JsonReader reader = Json.createReader((Reader)new StringReader(json));
                meta = reader.readObject();
                reader.close();
            } else {
                Main.debug((String)wikiConnection.getResponseMessage());
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        filtersMeta.add(meta);
        return meta;
    }

    public static void initFilters() {
        block18: {
            File file = new File(pluginDir, "urls.map");
            Main.debug((String)("EXIST FILE? " + file.exists()));
            try {
                BufferedReader br = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String temp;
                        while ((temp = br.readLine()) != null) {
                            String[] mapEntry = temp.split("\\t");
                            File fileUrl = new File(mapEntry[1]);
                            if (!fileUrl.exists()) continue;
                            try {
                                URL url = new URL("jar", "", fileUrl.toURI().toURL() + "!/");
                                Main.debug((String)("binaryUrl: " + url.toString()));
                                binariesLocalUrls.add(url);
                                continue block13;
                            }
                            catch (MalformedURLException e) {
                                Main.debug((String)("Initializing filters with unknown protocol. \n" + e.getMessage()));
                            }
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Main.debug((String)("BinariesLocal : " + binariesLocalUrls.toString()));
        loader = new URLClassLoader(binariesLocalUrls.toArray(new URL[binariesLocalUrls.size()]), FiltersDownloader.class.getClassLoader());
    }

    public static void destroyFilters() {
        filterTitles.clear();
        binariesLocalUrls.clear();
        filtersMeta.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (FilterInfo temp : filtersInfoList) {
            if (temp.isNeedToDownload()) {
                if (!filtersMetaToLoad.contains(temp.getMeta())) {
                    filtersMetaToLoad.add(temp.getMeta());
                }
                filterTitles.add(temp.getMeta().getString("title"));
                continue;
            }
            filterTitles.remove(temp.getMeta().getString("title"));
        }
        FiltersDownloader.loadBinariesFromMeta(filtersMetaToLoad);
        filtersMetaToLoad.clear();
    }

    public static void loadBinariesFromMeta(Set<JsonObject> metaList) {
        File file = new File(pluginDir, "urls.map");
        Main.debug((String)("pluginDir and urls map" + file.getAbsoluteFile()));
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (JsonObject temp : metaList) {
                JsonArray binaries = temp.getJsonArray("binaries");
                for (int i = 0; i < binaries.size(); ++i) {
                    String localFile = FiltersDownloader.loadBinaryToFile(binaries.getString(i));
                    try {
                        writer.append(binaries.getString(i));
                        writer.append("\t");
                        writer.append(localFile);
                        writer.append("\n");
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setPluginDir(String dir) {
        pluginDir = dir;
    }

    public static String loadBinaryToFile(String fromUrl) {
        URL url = null;
        URLConnection con = null;
        Pattern p = Pattern.compile("\\w.*/");
        Matcher m = p.matcher(fromUrl);
        String localFile = null;
        File plugin = new File(pluginDir);
        Main.debug((String)("plugin dir" + plugin.getAbsolutePath()));
        if (m.find() && plugin.exists()) {
            localFile = fromUrl.substring(m.end());
            Main.debug((String)("localFile: " + localFile));
        }
        try {
            int i;
            url = new URL(fromUrl);
            con = url.openConnection();
            String plugDir = plugin.getAbsolutePath();
            File file = new File(plugDir, localFile);
            Main.debug((String)("Binary file: " + file.getAbsolutePath()));
            if (file.exists()) {
                Main.debug((String)("File " + localFile + " already exists"));
                return file.getAbsolutePath();
            }
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
            out.close();
            in.close();
            return localFile;
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        filtersMeta = new HashSet<JsonObject>();
        filterTitles = new TreeSet<String>();
        binariesLocalUrls = new HashSet<URL>();
        urlsMap = new HashMap<String, String>();
        filtersMetaToLoad = new HashSet<JsonObject>();
        filtersInfoList = new ArrayList<FilterInfo>();
    }
}

