/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.gui;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.server.UID;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FilterStateOwner;
import org.openstreetmap.josm.plugins.rasterfilters.model.FilterStateModel;
import org.openstreetmap.josm.plugins.rasterfilters.model.StateChangeListener;
import org.openstreetmap.josm.plugins.rasterfilters.values.BooleanValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.ColorValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.SelectValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.SliderValue;

public class FilterGuiListener
implements ChangeListener,
ItemListener,
ActionListener,
PropertyChangeListener,
FilterStateOwner {
    private StateChangeListener handler;
    private FilterStateModel filterState;
    private Set<ComboBoxModel<String>> models = new HashSet<ComboBoxModel<String>>();
    private UID filterId;

    public FilterGuiListener(StateChangeListener handler) {
        this.handler = handler;
    }

    public void setFilterState(FilterStateModel state) {
        this.filterState = state;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        if (!slider.getValueIsAdjusting()) {
            slider.setToolTipText(String.valueOf((double)slider.getValue() / 100.0));
        }
        String parameterName = slider.getName();
        if (this.filterState.getParams().containsKey(parameterName)) {
            SliderValue value = (SliderValue)this.filterState.getParams().get(parameterName);
            if (value.isDouble()) {
                value.setValue((double)slider.getValue() / 100.0);
            } else {
                value.setValue(slider.getValue());
            }
            this.filterState.getParams().put(parameterName, value);
        }
        this.handler.filterStateChanged(this.filterId, this.filterState);
    }

    @Override
    public FilterStateModel getState() {
        return this.filterState;
    }

    public ComboBoxModel<String> addModel(ComboBoxModel<String> model) {
        this.models.add(model);
        return model;
    }

    public void setFilterId(UID filterId) {
        this.filterId = filterId;
    }

    public UID getFilterId() {
        return this.filterId;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox box = (JCheckBox)e.getSource();
        String parameterName = box.getName();
        BooleanValue value = (BooleanValue)this.filterState.getParams().get(parameterName);
        value.setValue(box.isSelected());
        this.handler.filterStateChanged(this.filterId, this.filterState);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox box = (JComboBox)e.getSource();
        String parameterName = box.getName();
        SelectValue value = (SelectValue)this.filterState.getParams().get(parameterName);
        ComboBoxModel model = box.getModel();
        String selectedItem = (String)model.getSelectedItem();
        value.setValue(selectedItem);
        if (this.handler != null) {
            this.handler.filterStateChanged(this.filterId, this.filterState);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ColorPicker picker = (ColorPicker)evt.getSource();
        int r = picker.getColor().getRed();
        int g = picker.getColor().getGreen();
        int b = picker.getColor().getBlue();
        String parameterName = picker.getName();
        ColorValue value = (ColorValue)this.filterState.getParams().get(parameterName);
        value.setValue(new Color(r, g, b));
        this.handler.filterStateChanged(this.filterId, this.filterState);
    }
}

