/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.actions.FixTask;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.gui.IncompleteMembersDownloadDialog;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.ProceedDialog;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.NodeChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;
import org.openstreetmap.josm.tools.I18n;

public class PTAssistantValidatorTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_CONSTRUCTION = 3722;
    public static final int ERROR_CODE_DIRECTION = 3731;
    public static final int ERROR_CODE_END_STOP = 3741;
    public static final int ERROR_CODE_SPLIT_WAY = 3742;
    public static final int ERROR_CODE_RELAITON_MEMBER_ROLES = 3743;
    public static final int ERROR_CODE_SOLITARY_STOP_POSITION = 3751;
    public static final int ERROR_CODE_PLATFORM_PART_OF_HIGHWAY = 3752;
    public static final int ERROR_CODE_STOP_NOT_SERVED = 3753;
    public static final int ERROR_CODE_STOP_BY_STOP = 3754;
    private PTAssistantLayer layer = PTAssistantLayer.getLayer();

    public PTAssistantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
        DataSet.addSelectionListener((SelectionChangedListener)this.layer);
    }

    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        NodeChecker nodeChecker = new NodeChecker(n, (Test)this);
        if (n.hasTag("public_transport", "stop_position")) {
            nodeChecker.performSolitaryStopPositionTest();
        }
        if (n.hasTag("public_transport", "platform")) {
            nodeChecker.performPlatformPartOfWayTest();
        }
        this.errors.addAll(nodeChecker.getErrors());
    }

    public void visit(Relation r) {
        boolean downloadSuccessful;
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (r.hasIncompleteMembers() && !(downloadSuccessful = this.downloadIncompleteMembers())) {
            return;
        }
        if (r.hasIncompleteMembers()) {
            return;
        }
        WayChecker wayChecker = new WayChecker(r, (Test)this);
        if (!r.hasIncompleteMembers()) {
            wayChecker.performDirectionTest();
            wayChecker.performRoadTypeTest();
        }
        this.errors.addAll(wayChecker.getErrors());
        if (this.errors.isEmpty()) {
            this.proceedWithSorting(r);
        } else {
            this.proceedAfterWayCheckerErrors(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadIncompleteMembers() {
        final int[] userSelection = new int[]{0};
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                userSelection[0] = this.showIncompleteMembersDownloadDialog();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userSelection[0] = PTAssistantValidatorTest.this.showIncompleteMembersDownloadDialog();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            return false;
        }
        if (userSelection[0] == 0) {
            IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread();
            t.start();
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
            synchronized (incompleteMembersDownloadThread) {
                try {
                    t.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private int showIncompleteMembersDownloadDialog() throws InterruptedException {
        IncompleteMembersDownloadDialog incompleteMembersDownloadDialog = new IncompleteMembersDownloadDialog();
        return incompleteMembersDownloadDialog.getUserSelection();
    }

    private void proceedAfterWayCheckerErrors(Relation r) {
        int numberOfDirectionErrors = 0;
        int numberOfRoadTypeErrors = 0;
        for (TestError e : this.errors) {
            if (e.getCode() == 3731) {
                ++numberOfDirectionErrors;
            }
            if (e.getCode() != 3721) continue;
            ++numberOfRoadTypeErrors;
        }
        final int[] userInput = new int[]{0};
        final long idParameter = r.getId();
        int directionErrorParameter = numberOfDirectionErrors;
        final int roadTypeErrorParameter = numberOfRoadTypeErrors;
        if (SwingUtilities.isEventDispatchThread()) {
            userInput[0] = this.showProceedDialog(idParameter, directionErrorParameter, roadTypeErrorParameter);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        userInput[0] = PTAssistantValidatorTest.this.showProceedDialog(idParameter, roadTypeErrorParameter, roadTypeErrorParameter);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
        if (userInput[0] == 0) {
            this.fixErrorFromPlugin(this.errors);
            this.proceedWithSorting(r);
            return;
        }
        if (userInput[0] == 1) {
            JOptionPane.showMessageDialog(null, "This is not implemented yet!");
            return;
        }
        if (userInput[0] == 2) {
            this.proceedWithSorting(r);
        }
    }

    private int showProceedDialog(long id, int numberOfDirectionErrors, int numberOfRoadTypeErrors) {
        ProceedDialog proceedDialog = new ProceedDialog(id, numberOfDirectionErrors, numberOfRoadTypeErrors);
        return proceedDialog.getUserSelection();
    }

    private void proceedWithSorting(Relation r) {
        RouteChecker routeChecker = new RouteChecker(r, (Test)this);
        routeChecker.performSortingTest();
        List<TestError> routeCheckerErrors = routeChecker.getErrors();
        if (!routeCheckerErrors.isEmpty()) {
            this.errors.addAll(routeChecker.getErrors());
            return;
        }
        if (!routeChecker.getHasGap()) {
            // empty if block
        }
        this.proceedAfterSorting(r);
    }

    private void proceedAfterSorting(Relation r) {
        SegmentChecker segmentChecker = new SegmentChecker(r, (Test)this);
        if (!segmentChecker.getErrors().isEmpty()) {
            this.errors.addAll(segmentChecker.getErrors());
        }
        segmentChecker.performFirstStopTest();
        segmentChecker.performLastStopTest();
        segmentChecker.performStopByStopTest();
        this.errors.addAll(segmentChecker.getErrors());
    }

    private void storeCorrectRouteSegments(Relation r) {
        PTRouteDataManager manager = new PTRouteDataManager(r);
        StopToWayAssigner assigner = new StopToWayAssigner(manager.getPTWays());
        if (manager.getPTStops().size() > 1) {
            for (int i = 1; i < manager.getPTStops().size(); ++i) {
                PTStop segmentStartStop = manager.getPTStops().get(i - 1);
                PTStop segmentEndStop = manager.getPTStops().get(i);
                Way segmentStartWay = assigner.get(segmentStartStop);
                Way segmentEndWay = assigner.get(segmentEndStop);
                List<PTWay> waysBetweenStops = manager.getPTWaysBetween(segmentStartWay, segmentEndWay);
                PTRouteSegment routeSegment = new PTRouteSegment(segmentStartStop, segmentEndStop, waysBetweenStops);
                SegmentChecker.addCorrectSegment(routeSegment);
            }
        }
    }

    public boolean isFixable(TestError testError) {
        if (testError.getCode() == 3731 || testError.getCode() == 3721 || testError.getCode() == 3722 || testError.getCode() == 3711 || testError.getCode() == 3751 || testError.getCode() == 3752) {
            return true;
        }
        return testError.getCode() == 3754 && SegmentChecker.isFixable(testError);
    }

    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (testError.getCode() == 3721 || testError.getCode() == 3722) {
            commands.add(WayChecker.fixErrorByRemovingWay(testError));
        }
        if (testError.getCode() == 3731) {
            commands.add(WayChecker.fixErrorByZooming(testError));
        }
        if (testError.getCode() == 3711) {
            commands.add(RouteChecker.fixSortingError(testError));
        }
        if (testError.getCode() == 3751 || testError.getCode() == 3752) {
            commands.add(NodeChecker.fixError(testError));
        }
        if (testError.getCode() == 3754) {
            commands.add(SegmentChecker.fixError(testError));
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix error", (Object[])new Object[0]), commands);
    }

    private void fixErrorFromPlugin(List<TestError> testErrors) {
        FixTask fixTask = new FixTask(testErrors);
        Thread t = new Thread((Runnable)((Object)fixTask));
        t.start();
        try {
            t.join();
            this.errors.removeAll(testErrors);
        }
        catch (InterruptedException e) {
            JOptionPane.showMessageDialog(null, "Error occurred during fixing");
        }
    }

    private void performDummyTest(Relation r) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(r);
        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: dummy test warning", (Object[])new Object[0]), 3731, primitives));
    }
}

