/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class SegmentChecker
extends Checker {
    private static List<PTRouteSegment> correctSegments = new ArrayList<PTRouteSegment>();
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;
    private Node firstNodeOfRouteSegmentInDirectionOfTravel;

    public SegmentChecker(Relation relation, Test test) {
        super(relation, test);
        this.manager = new PTRouteDataManager(relation);
        for (RelationMember rm : this.manager.getFailedMembers()) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(relation);
            ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>(1);
            highlighted.add(rm.getMember());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Relation member roles do not match tags", (Object[])new Object[0]), 3743, primitives, highlighted);
            this.errors.add(e);
        }
        this.assigner = new StopToWayAssigner(this.manager.getPTWays());
    }

    public static int getCorrectSegmentCount() {
        return correctSegments.size();
    }

    public static void addCorrectSegment(PTRouteSegment segment) {
        correctSegments.add(segment);
    }

    public void performFirstStopTest() {
        this.performEndStopTest(this.manager.getFirstStop());
    }

    public void performLastStopTest() {
        this.performEndStopTest(this.manager.getLastStop());
    }

    private void performEndStopTest(PTStop endStop) {
        if (endStop == null) {
            return;
        }
        if (endStop.getStopPosition() == null) {
            ArrayList<Object> highlighted;
            ArrayList<Relation> primitives;
            List<Node> potentialStopPositionList = endStop.findPotentialStopPositions();
            ArrayList<Node> stopPositionsOfThisRoute = new ArrayList<Node>();
            boolean containsAtLeastOneStopPositionAsFirstOrLastNode = false;
            for (Node potentialStopPosition : potentialStopPositionList) {
                int belongsToWay = this.belongsToAWayOfThisRoute(potentialStopPosition);
                if (belongsToWay == 0) {
                    stopPositionsOfThisRoute.add(potentialStopPosition);
                    containsAtLeastOneStopPositionAsFirstOrLastNode = true;
                }
                if (belongsToWay != 1) continue;
                stopPositionsOfThisRoute.add(potentialStopPosition);
            }
            if (stopPositionsOfThisRoute.isEmpty()) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Object>(1);
                highlighted.add(endStop.getPlatform());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route should start and end with a stop_position", (Object[])new Object[0]), 3741, primitives, highlighted);
                this.errors.add(e);
                return;
            }
            if (stopPositionsOfThisRoute.size() == 1) {
                endStop.setStopPosition((Node)stopPositionsOfThisRoute.get(0));
            }
            if (!containsAtLeastOneStopPositionAsFirstOrLastNode) {
                primitives = new ArrayList(1);
                primitives.add(this.relation);
                highlighted = new ArrayList();
                highlighted.addAll(stopPositionsOfThisRoute);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        } else {
            int belongsToWay = this.belongsToAWayOfThisRoute(endStop.getStopPosition());
            if (belongsToWay == 1) {
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Node> highlighted = new ArrayList<Node>();
                highlighted.add(endStop.getStopPosition());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        }
    }

    private int belongsToAWayOfThisRoute(Node node) {
        boolean contains = false;
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (!way.containsNode(node)) continue;
                if (way.firstNode().equals((Object)node) || way.lastNode().equals((Object)node)) {
                    return 0;
                }
                contains = true;
            }
        }
        if (contains) {
            return 1;
        }
        return -1;
    }

    public void performStopByStopTest() {
        if (this.manager.getPTStopCount() < 2) {
            return;
        }
        for (int i = 1; i < this.manager.getPTStopCount(); ++i) {
            boolean sortingCorrect;
            PTStop startStop = this.manager.getPTStops().get(i - 1);
            PTStop endStop = this.manager.getPTStops().get(i);
            Way startWay = this.assigner.get(startStop);
            Way endWay = this.assigner.get(endStop);
            if (startWay == null) {
                this.firstNodeOfRouteSegmentInDirectionOfTravel = null;
                continue;
            }
            if (endWay == null) {
                this.firstNodeOfRouteSegmentInDirectionOfTravel = null;
                continue;
            }
            List<PTWay> segmentWays = this.manager.getPTWaysBetween(startWay, endWay);
            if (this.firstNodeOfRouteSegmentInDirectionOfTravel == null) {
                this.firstNodeOfRouteSegmentInDirectionOfTravel = this.findFirstNodeOfRouteSegmentInDirectionOfTravel(segmentWays.get(0));
                if (this.firstNodeOfRouteSegmentInDirectionOfTravel == null) continue;
            }
            if (!(sortingCorrect = this.existingWaySortingIsCorrect(segmentWays.get(0), this.firstNodeOfRouteSegmentInDirectionOfTravel, segmentWays.get(segmentWays.size() - 1)))) continue;
            PTRouteSegment routeSegment = new PTRouteSegment(startStop, endStop, segmentWays);
            correctSegments.add(routeSegment);
        }
    }

    private Node findFirstNodeOfRouteSegmentInDirectionOfTravel(PTWay startWay) {
        Node[] startWayEndnodes = startWay.getEndNodes();
        if (this.isDeadendNode(startWayEndnodes[0])) {
            return startWayEndnodes[0];
        }
        if (this.isDeadendNode(startWayEndnodes[1])) {
            return startWayEndnodes[1];
        }
        PTWay nextWay = this.manager.getNextPTWay(startWay);
        if (nextWay == null) {
            return null;
        }
        Node[] nextWayEndnodes = nextWay.getEndNodes();
        if (startWayEndnodes[0] == nextWayEndnodes[0] || startWayEndnodes[0] == nextWayEndnodes[1]) {
            return startWayEndnodes[1];
        }
        if (startWayEndnodes[1] == nextWayEndnodes[0] || startWayEndnodes[1] == nextWayEndnodes[1]) {
            return startWayEndnodes[0];
        }
        return null;
    }

    private boolean isDeadendNode(Node node) {
        int count = 0;
        for (PTWay ptway : this.manager.getPTWays()) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (way.firstNode() != node && way.lastNode() != node) continue;
                ++count;
            }
        }
        return count == 1;
    }

    private Node findClosestDeadendNode(LatLon coord, List<Node> deadendNodes) {
        Node closestDeadendNode = null;
        double minSqDistance = Double.MAX_VALUE;
        for (Node deadendNode : deadendNodes) {
            double distanceSq = coord.distanceSq(deadendNode.getCoor());
            if (!(distanceSq < minSqDistance)) continue;
            minSqDistance = distanceSq;
            closestDeadendNode = deadendNode;
        }
        return closestDeadendNode;
    }

    private boolean existingWaySortingIsCorrect(PTWay start, Node startWayPreviousNodeInDirectionOfTravel, PTWay end) {
        if (start == end) {
            return true;
        }
        PTWay current = start;
        while (!current.equals((Object)end)) {
            PTWay nextPTWayAccortingToExistingSorting;
            this.firstNodeOfRouteSegmentInDirectionOfTravel = this.getOppositeEndNode(current, this.firstNodeOfRouteSegmentInDirectionOfTravel);
            List<PTWay> nextWaysInDirectionOfTravel = this.findNextPTWaysInDirectionOfTravel(current, this.firstNodeOfRouteSegmentInDirectionOfTravel);
            if (!nextWaysInDirectionOfTravel.contains((Object)(nextPTWayAccortingToExistingSorting = this.manager.getNextPTWay(current)))) {
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Object> highlighted = new ArrayList<Object>();
                highlighted.addAll(current.getWays());
                highlighted.add(this.firstNodeOfRouteSegmentInDirectionOfTravel);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                this.errors.add(e);
                this.firstNodeOfRouteSegmentInDirectionOfTravel = null;
                return false;
            }
            current = nextPTWayAccortingToExistingSorting;
        }
        return true;
    }

    private Node getOppositeEndNode(Way way, Node node) {
        if (node == way.firstNode()) {
            return way.lastNode();
        }
        if (node == way.lastNode()) {
            return way.firstNode();
        }
        return null;
    }

    private Node getOppositeEndNode(PTWay ptway, Node node) {
        if (ptway.isWay()) {
            return this.getOppositeEndNode(ptway.getWays().get(0), node);
        }
        Way firstWay = ptway.getWays().get(0);
        Way lastWay = ptway.getWays().get(ptway.getWays().size() - 1);
        Node oppositeNode = node;
        if (firstWay.firstNode() == node || firstWay.lastNode() == node) {
            for (int i = 0; i < ptway.getWays().size(); ++i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        if (lastWay.firstNode() == node || lastWay.lastNode() == node) {
            for (int i = ptway.getWays().size() - 1; i >= 0; --i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        return null;
    }

    private List<PTWay> findNextPTWaysInDirectionOfTravel(PTWay currentWay, Node nextNodeInDirectionOfTravel) {
        ArrayList<PTWay> nextPtways = new ArrayList<PTWay>();
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            Node[] endNodes;
            if (ptway == currentWay || (endNodes = ptway.getEndNodes())[0] != nextNodeInDirectionOfTravel && endNodes[1] != nextNodeInDirectionOfTravel) continue;
            nextPtways.add(ptway);
        }
        return nextPtways;
    }

    protected static Command fixError(TestError testError) {
        return null;
    }
}

