/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdsParser
extends DefaultHandler {
    private DataSet dataSet;
    private OsmPrimitive currentPrimitive;
    private SeparateDataStorePlugin plugin;
    private boolean ensureMatch;

    public SdsParser(DataSet ds, SeparateDataStorePlugin p, boolean ensureMatch) {
        this.dataSet = ds;
        this.plugin = p;
        this.ensureMatch = ensureMatch;
    }

    public SdsParser(DataSet ds, SeparateDataStorePlugin p) {
        this(ds, p, true);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if ("osm_shadow".equals(qName) && this.currentPrimitive != null) {
            this.plugin.learn((IPrimitive)this.currentPrimitive.save());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("osm_shadow".equals(qName)) {
            String type = atts.getValue("osm_type");
            String id = atts.getValue("osm_id");
            this.currentPrimitive = this.dataSet.getPrimitiveById(Long.parseLong(id), OsmPrimitiveType.fromApiTypeName((String)type));
            if (this.currentPrimitive == null && this.ensureMatch) {
                throw new SAXException("unexpected object in response");
            }
        } else if ("tag".equals(qName)) {
            String v = atts.getValue("v");
            String k = atts.getValue("k");
            if (this.currentPrimitive != null) {
                this.currentPrimitive.put(k, v);
            }
        }
    }
}

