/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikiSearchTextResultListPanel;
import org.wikipedia.WikipediaApp;
import org.wikipedia.WikipediaToggleDialog;

public final class WikidataItemSearchDialog
extends ExtendedDialog {
    private final Selector selector = new Selector();
    private final AutoCompletingComboBox targetKey;
    private static final WikidataItemSearchDialog INSTANCE = new WikidataItemSearchDialog();

    private WikidataItemSearchDialog() {
        super(Main.parent, I18n.tr((String)"Search Wikidata items", (Object[])new Object[0]), new String[]{I18n.tr((String)"Add Tag", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.selector.setDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WikidataItemSearchDialog.this.buttonAction(0, null);
            }
        });
        this.targetKey = new AutoCompletingComboBox();
        this.targetKey.setEditable(true);
        this.targetKey.setSelectedItem((Object)new AutoCompletionListItem("wikidata"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.selector), GBC.eop().fill(1));
        panel.add(new JLabel(I18n.tr((String)"Target key: ", (Object[])new Object[0])));
        panel.add((Component)this.targetKey, GBC.eol().fill(2));
        this.setContent(panel, false);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public static synchronized WikidataItemSearchDialog getInstance() {
        return INSTANCE;
    }

    public ExtendedDialog showDialog() {
        this.initTargetKeys();
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        this.selector.requestFocus();
        return this;
    }

    private void initTargetKeys() {
        DataSet editDataSet = Main.getLayerManager().getEditDataSet();
        if (editDataSet == null) {
            return;
        }
        TreeSet<AutoCompletionListItem> keys = new TreeSet<AutoCompletionListItem>();
        keys.add(new AutoCompletionListItem("wikidata"));
        keys.add(new AutoCompletionListItem("operator:wikidata"));
        keys.add(new AutoCompletionListItem("brand:wikidata"));
        keys.add(new AutoCompletionListItem("architect:wikidata"));
        keys.add(new AutoCompletionListItem("artist:wikidata"));
        keys.add(new AutoCompletionListItem("subject:wikidata"));
        keys.add(new AutoCompletionListItem("name:etymology:wikidata"));
        keys.addAll(Utils.filter((Collection)editDataSet.getAutoCompletionManager().getKeys(), (Predicate)new Predicate<AutoCompletionListItem>(){

            public boolean evaluate(AutoCompletionListItem object) {
                return object.getValue().contains("wikidata");
            }
        }));
        this.targetKey.setPossibleACItems(keys);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex != 0) {
            return;
        }
        WikipediaApp.WikidataEntry selected = (WikipediaApp.WikidataEntry)this.selector.getSelectedItem();
        if (selected == null) {
            return;
        }
        String key = Tag.removeWhiteSpaces((String)this.targetKey.getEditor().getItem().toString());
        String value = selected.createWikipediaTag().getValue();
        WikipediaToggleDialog.AddWikipediaTagAction.addTag(new Tag(key, value));
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Search Wikidata items", (Object[])new Object[0]), "dialogs/wikidata", null, null, true, "dialogs/search-wikidata-items", false);
        }

        public void actionPerformed(ActionEvent e) {
            WikidataItemSearchDialog.getInstance().showDialog();
        }
    }

    private static class Selector
    extends WikiSearchTextResultListPanel<WikipediaApp.WikidataEntry> {
        Selector() {
            this.lsResult.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    WikipediaApp.WikidataEntry entry = (WikipediaApp.WikidataEntry)value;
                    String labelText = "<html>" + entry.getLabelText();
                    return super.getListCellRendererComponent(list, labelText, index, isSelected, cellHasFocus);
                }
            });
        }

        protected void filterItems() {
            final String query = this.edSearchText.getText();
            this.debouncer.debounce(Void.class, new Runnable(){

                @Override
                public void run() {
                    final List entries = query == null || query.isEmpty() ? Collections.emptyList() : WikipediaApp.getWikidataEntriesForQuery(WikipediaToggleDialog.wikipediaLang.get(), query, Locale.getDefault());
                    GuiHelper.runInEDT((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Selector.this.lsResultModel.setItems(entries);
                        }
                    });
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }
}

