/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.auto_tools.actions;

import edu.princeton.cs.algs4.AssignmentProblem;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryException;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class ReplaceBuilding
extends JosmAction {
    public ReplaceBuilding() {
        super(ExpressionFactory.Functions.tr((String[])new String[]{"ReplaceBuilding"}), null, ExpressionFactory.Functions.tr((String[])new String[]{"Replace imported buildings"}), Shortcut.registerShortcut((String)"AutoTools:ReplaceBuilding", (String)ExpressionFactory.Functions.tr((String[])new String[]{"AutoTools:ReplaceBuilding"}), (int)65, (int)5009), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceBuilding.getCurrentDataSet() == null) {
            return;
        }
        ArrayList<Way> selection = new ArrayList<Way>(ReplaceBuilding.getCurrentDataSet().getSelected());
        if (selection.isEmpty()) {
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Select at least one building."})).setIcon(2).show();
            return;
        }
        if (!OsmPrimitive.getFilteredSet(selection, Node.class).isEmpty()) {
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Select only buildings without nodes."})).setIcon(2).show();
            return;
        }
        Set selectedWays = OsmPrimitive.getFilteredSet(selection, Way.class);
        Set<Way> newWays = new HashSet<Way>();
        if (selectedWays.size() == 1) {
            newWays = ReplaceBuilding.addWaysIntersectingWaysRecursively(ReplaceBuilding.getCurrentDataSet().getWays(), selectedWays, newWays);
            if (newWays.size() > 2) {
                new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Select two buildings."})).setIcon(2).show();
                return;
            }
            if (newWays.size() < 2) {
                new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"There's no building to replace"})).setIcon(2).show();
                return;
            }
            selection.clear();
            selection.addAll(newWays);
        } else if (selectedWays.size() != 2) {
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Select maximum two buildings."})).setIcon(2).show();
            return;
        }
        OsmPrimitive firstObject = (OsmPrimitive)selection.get(0);
        OsmPrimitive secondObject = (OsmPrimitive)selection.get(1);
        if (firstObject.getKeys() == null || secondObject.getKeys() == null) {
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Cannot replace relations."})).setIcon(2).show();
            return;
        }
        try {
            ReplaceGeometryCommand replaceCommand = ReplaceBuilding.buildReplaceWithNewCommand(firstObject, secondObject);
            if (replaceCommand == null) {
                return;
            }
            Main.main.undoRedo.add((Command)replaceCommand);
        }
        catch (IllegalArgumentException | ReplaceGeometryException ex) {
            new Notification(ex.getMessage()).setIcon(2).show();
        }
        selection.clear();
    }

    public static ReplaceGeometryCommand buildReplaceWithNewCommand(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        if (firstObject instanceof Node && secondObject instanceof Node) {
            return ReplaceGeometryUtils.buildReplaceNodeWithNewCommand((Node)((Node)firstObject), (Node)((Node)secondObject));
        }
        if (firstObject instanceof Way && secondObject instanceof Way) {
            return ReplaceBuilding.buildReplaceWayWithNewCommand(Arrays.asList((Way)firstObject, (Way)secondObject));
        }
        if (firstObject instanceof Node) {
            return ReplaceBuilding.buildUpgradeNodeCommand((Node)firstObject, secondObject);
        }
        if (secondObject instanceof Node) {
            return ReplaceBuilding.buildUpgradeNodeCommand((Node)secondObject, firstObject);
        }
        throw new IllegalArgumentException(ExpressionFactory.Functions.tr((String[])new String[]{"This tool can only replace a node, upgrade a node to a way or a multipolygon, or replace a way with a way."}));
    }

    protected static List<Command> getTagConflictResolutionCommands(OsmPrimitive source, OsmPrimitive target) throws UserCancelException {
        Hashtable<String, String> atrributes = new Hashtable<String, String>();
        String valSource = source.getKeys().get((Object)"building");
        String valTarget = target.getKeys().get((Object)"building");
        if (valSource != null || valTarget != null) {
            if (valSource.equals("yes") || valSource.equals(valTarget)) {
                source.setKeys(ReplaceBuilding.getAttributes(source, valTarget));
                target.setKeys(ReplaceBuilding.getAttributes(target, valTarget));
            } else if (valTarget.equals("yes")) {
                source.setKeys(ReplaceBuilding.getAttributes(source, valSource));
                target.setKeys(ReplaceBuilding.getAttributes(target, valSource));
            }
            List<OsmPrimitive> primitives = Arrays.asList(source, target);
            for (OsmPrimitive osm : primitives) {
                Set keys1 = osm.getKeys().keySet();
                for (String key : keys1) {
                    if (atrributes.containsKey(key)) continue;
                    atrributes.put(key, osm.get(key));
                }
            }
            if (valSource.equals("yes") || valTarget.equals("yes") || valSource.equals(valTarget)) {
                target.setKeys(atrributes);
                source.setKeys(atrributes);
            }
            List lc = CombinePrimitiveResolverDialog.launchIfNecessary((TagCollection)TagCollection.unionOfAllPrimitives(primitives), primitives, Collections.singleton(target));
            return lc;
        }
        new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Cannot replace relations"})).setIcon(2).show();
        return null;
    }

    private static Map<String, String> getAttributes(OsmPrimitive osm, String value) {
        Hashtable<String, String> atrributes = new Hashtable<String, String>();
        Set keys = osm.getKeys().keySet();
        for (String key : keys) {
            if (atrributes.containsKey(key)) continue;
            if (key.equals("building")) {
                atrributes.put(key, value);
                continue;
            }
            atrributes.put(key, osm.get(key));
        }
        return atrributes;
    }

    public static ReplaceGeometryCommand buildUpgradeNodeCommand(Node subjectNode, OsmPrimitive referenceObject) {
        if (!OsmPrimitive.getFilteredList((Collection)subjectNode.getReferrers(), Way.class).isEmpty()) {
            throw new ReplaceGeometryException(ExpressionFactory.Functions.tr((String[])new String[]{"Node belongs to way(s), cannot replace."}));
        }
        if (referenceObject instanceof Relation && !((Relation)referenceObject).isMultipolygon()) {
            throw new ReplaceGeometryException(ExpressionFactory.Functions.tr((String[])new String[]{"Relation is not a multipolygon, cannot be used as a replacement."}));
        }
        Node nodeToReplace = null;
        if (!subjectNode.isNew()) {
            HashSet<Node> nodePool = new HashSet<Node>();
            if (referenceObject instanceof Way) {
                nodePool.addAll(ReplaceBuilding.getUnimportantNodes((Way)referenceObject));
            } else if (referenceObject instanceof Relation) {
                for (RelationMember member : ((Relation)referenceObject).getMembers()) {
                    if (!member.getRole().equals("outer") && !member.getRole().equals("inner") || !member.isWay()) continue;
                    nodePool.addAll(ReplaceBuilding.getUnimportantNodes(member.getWay()));
                }
            } else assert (false);
            nodeToReplace = ReplaceBuilding.findNearestNode(subjectNode, nodePool);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        TagMap nodeTags = subjectNode.getKeys();
        try {
            commands.addAll(ReplaceBuilding.getTagConflictResolutionCommands((OsmPrimitive)subjectNode, referenceObject));
        }
        catch (UserCancelException e) {
            return null;
        }
        if (nodeToReplace != null) {
            Way parentWay = (Way)nodeToReplace.getReferrers().get(0);
            List wayNodes = parentWay.getNodes();
            int idx = wayNodes.indexOf(nodeToReplace);
            wayNodes.set(idx, subjectNode);
            if (idx == 0 && parentWay.isClosed()) {
                wayNodes.set(wayNodes.size() - 1, subjectNode);
            }
            commands.add(new ChangeNodesCommand(parentWay, wayNodes));
            commands.add(new MoveCommand(subjectNode, nodeToReplace.getCoor()));
            commands.add(new DeleteCommand((OsmPrimitive)nodeToReplace));
            if (!nodeTags.isEmpty()) {
                for (String key : nodeTags.keySet()) {
                    commands.add(new ChangePropertyCommand((OsmPrimitive)subjectNode, key, null));
                }
            }
        } else {
            commands.add(new DeleteCommand((OsmPrimitive)subjectNode));
        }
        Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{referenceObject});
        return new ReplaceGeometryCommand(ExpressionFactory.Functions.tr((String[])new String[]{"Replace geometry for node {0}", subjectNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands);
    }

    public static ReplaceGeometryCommand buildReplaceWayWithNewCommand(List<Way> selection) {
        int idxNew;
        boolean overrideNewCheck = false;
        int n = idxNew = selection.get(0).isNew() ? 0 : 1;
        if (selection.get(1 - idxNew).isNew()) {
            boolean areNewNodes = false;
            for (Node n2 : selection.get(0).getNodes()) {
                if (!n2.isNew()) continue;
                areNewNodes = true;
            }
            idxNew = areNewNodes ? 0 : 1;
            overrideNewCheck = true;
            for (Node n2 : selection.get(1 - idxNew).getNodes()) {
                if (!n2.isNew()) continue;
                overrideNewCheck = false;
            }
        }
        Way referenceWay = selection.get(idxNew);
        Way subjectWay = selection.get(1 - idxNew);
        if (!(overrideNewCheck || !subjectWay.isNew() && referenceWay.isNew())) {
            throw new ReplaceGeometryException(ExpressionFactory.Functions.tr((String[])new String[]{"Please select one way that exists in the database and one new way with correct geometry."}));
        }
        return ReplaceBuilding.buildReplaceWayCommand(subjectWay, referenceWay);
    }

    public static ReplaceGeometryCommand buildReplaceWayCommand(Way subjectWay, Way referenceWay) {
        Area a = Main.main.getCurrentDataSet().getDataSourceArea();
        if (!ReplaceBuilding.isInArea(subjectWay, a) || !ReplaceBuilding.isInArea(referenceWay, a)) {
            throw new ReplaceGeometryException(ExpressionFactory.Functions.tr((String[])new String[]{"The ways must be entirely within the downloaded area."}));
        }
        if (ReplaceBuilding.hasImportantNode(referenceWay, subjectWay)) {
            throw new ReplaceGeometryException(ExpressionFactory.Functions.tr((String[])new String[]{"The way to be replaced cannot have any nodes with properties or relation memberships unless they belong to both ways."}));
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        try {
            commands.addAll(ReplaceBuilding.getTagConflictResolutionCommands((OsmPrimitive)referenceWay, (OsmPrimitive)subjectWay));
        }
        catch (UserCancelException e) {
            return null;
        }
        List<Node> nodePool = ReplaceBuilding.getUnimportantNodes(subjectWay);
        LinkedList<Node> geometryPool = new LinkedList<Node>();
        for (Node node : referenceWay.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)referenceWay) || subjectWay.containsNode(node) || ReplaceBuilding.hasInterestingKey((OsmPrimitive)node) || geometryPool.contains(node)) continue;
            geometryPool.add(node);
        }
        boolean useRobust = Main.pref.getBoolean("utilsplugin2.replace-geometry.robustAssignment", true);
        HashMap<Object, Node> nodeAssoc = new HashMap<Object, Node>();
        if (geometryPool.size() > 0 && nodePool.size() > 0) {
            if (useRobust) {
                int gLen = geometryPool.size();
                int nLen = nodePool.size();
                int N = Math.max(gLen, nLen);
                double[][] cost = new double[N][N];
                for (int i = 0; i < N; ++i) {
                    for (int j = 0; j < N; ++j) {
                        cost[i][j] = Double.MAX_VALUE;
                    }
                }
                double maxDistance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
                for (int i = 0; i < nLen; ++i) {
                    for (int j = 0; j < gLen; ++j) {
                        double d = nodePool.get(i).getCoor().distance(((Node)geometryPool.get(j)).getCoor());
                        cost[i][j] = d > maxDistance ? Double.MAX_VALUE : d;
                    }
                }
                try {
                    AssignmentProblem assignment = new AssignmentProblem(cost);
                    for (int i = 0; i < N; ++i) {
                        int nIdx = i;
                        int gIdx = assignment.sol(i);
                        if (cost[nIdx][gIdx] == Double.MAX_VALUE) continue;
                        nodeAssoc.put(geometryPool.get(gIdx), nodePool.get(nIdx));
                    }
                    for (Node n : nodeAssoc.values()) {
                        nodePool.remove(n);
                    }
                }
                catch (Exception e) {
                    useRobust = false;
                    new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Exceeded iteration limit for robust method, using simpler method."})).setIcon(2).show();
                    nodeAssoc = new HashMap();
                }
            }
            if (!useRobust) {
                for (Node n : geometryPool) {
                    Node nearest = ReplaceBuilding.findNearestNode(n, nodePool);
                    if (nearest == null) continue;
                    nodeAssoc.put(n, nearest);
                    nodePool.remove(nearest);
                }
            }
        }
        for (Node n : geometryPool) {
            if (!nodeAssoc.containsKey(n)) continue;
            nodePool.add(n);
        }
        List geometryNodes = referenceWay.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, nodeAssoc.get(geometryNodes.get(i)));
        }
        commands.add(new ChangeNodesCommand(subjectWay, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add(new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        Main.main.getCurrentDataSet().clearSelection(new PrimitiveId[]{referenceWay});
        commands.add(new DeleteCommand((OsmPrimitive)referenceWay));
        if (!nodePool.isEmpty()) {
            commands.add(new DeleteCommand(nodePool));
        }
        return new ReplaceGeometryCommand(ExpressionFactory.Functions.tr((String[])new String[]{"Replace geometry for way {0}", subjectWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands);
    }

    protected static Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance(coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }

    protected static boolean hasInterestingKey(OsmPrimitive object) {
        for (String key : object.getKeys().keySet()) {
            if (OsmPrimitive.isUninterestingKey((String)key)) continue;
            return true;
        }
        return false;
    }

    protected static List<Node> getUnimportantNodes(Way way) {
        LinkedList<Node> nodePool = new LinkedList<Node>();
        for (Node n : way.getNodes()) {
            List referrers = n.getReferrers();
            if (n.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || ReplaceBuilding.hasInterestingKey((OsmPrimitive)n) || nodePool.contains(n)) continue;
            nodePool.add(n);
        }
        return nodePool;
    }

    protected static boolean hasImportantNode(Way geometry, Way way) {
        for (Node n : way.getNodes()) {
            if (geometry.containsNode(n)) continue;
            for (OsmPrimitive o : n.getReferrers()) {
                if (!(o instanceof Relation)) continue;
                return true;
            }
            if (!ReplaceBuilding.hasInterestingKey((OsmPrimitive)n)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInArea(Way way, Area area) {
        if (area == null) {
            return true;
        }
        for (Node n : way.getNodes()) {
            if (ReplaceBuilding.isInArea(n, area)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isInArea(Node node, Area area) {
        LatLon ll = node.getCoor();
        return node.isNewOrUndeleted() || area == null || ll == null || area.contains(ll.getX(), ll.getY());
    }

    public static Set<Way> addWaysIntersectingWaysRecursively(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        int c;
        HashSet<Way> foundWays = new HashSet<Way>();
        foundWays.addAll(initWays);
        newWays.addAll(initWays);
        int level = 0;
        do {
            c = 0;
            HashSet<Way> newFoundWays = new HashSet<Way>();
            for (Way w : foundWays) {
                c += ReplaceBuilding.addWaysIntersectingWay(allWays, w, newFoundWays, newWays);
            }
            foundWays = newFoundWays;
            newWays.addAll(newFoundWays);
            ++level;
            if (c <= Main.pref.getInteger("selection.maxfoundways.intersection", 500)) continue;
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Too many ways are added: {0}!" + c})).setIcon(2).show();
        } while (c > 0 && level < Main.pref.getInteger("selection.maxrecursion", 15));
        return newWays;
    }

    static int addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays, Set<Way> excludeWays) {
        List nodePairs = w.getNodePairs(false);
        int count = 0;
        block0: for (Way anyway : ways) {
            if (anyway == w || newWays.contains(anyway) || excludeWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }
}

