/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.tools.Pair;

public class StopToWayAssigner {
    private static HashMap<PTStop, PTWay> stopToWay = new HashMap();
    private List<PTWay> ptways;

    public StopToWayAssigner(List<PTWay> ptways) {
        this.ptways = ptways;
    }

    public PTWay get(PTStop stop) {
        if (stopToWay.containsKey((Object)stop)) {
            return stopToWay.get((Object)stop);
        }
        PTWay ptwayOfStopPosition = this.findPtwayForNode(stop.getStopPosition());
        if (ptwayOfStopPosition != null) {
            stopToWay.put(stop, ptwayOfStopPosition);
            return ptwayOfStopPosition;
        }
        ArrayList<Object> stopElements = new ArrayList<Object>(2);
        if (stop.getStopPosition() != null) {
            stopElements.add(stop.getStopPosition());
        }
        if (stop.getPlatform() != null) {
            stopElements.add(stop.getPlatform());
        }
        Set parents = Node.getParentRelations(stopElements);
        for (Relation parentRelation : parents) {
            if (!parentRelation.hasTag("public_transport", "stop_area")) continue;
            for (RelationMember rm : parentRelation.getMembers()) {
                PTWay rmPtway;
                if (!rm.getMember().hasTag("public_transport", "stop_position") || (rmPtway = this.findPtwayForNode(rm.getNode())) == null) continue;
                stopToWay.put(stop, rmPtway);
                return rmPtway;
            }
        }
        for (double searchRadius = 0.001; searchRadius < 0.005; searchRadius += 0.001) {
            PTWay foundWay = this.findNearestWayInRadius(stop.getPlatform(), searchRadius);
            if (foundWay != null) {
                stopToWay.put(stop, foundWay);
                return foundWay;
            }
            foundWay = this.findNearestWayInRadius((OsmPrimitive)stop.getStopPosition(), searchRadius);
            if (foundWay == null) continue;
            stopToWay.put(stop, foundWay);
            return foundWay;
        }
        return null;
    }

    private PTWay findPtwayForNode(Node stopPosition) {
        if (stopPosition == null) {
            return null;
        }
        List referrers = stopPosition.getReferrers();
        for (OsmPrimitive referredPrimitive : referrers) {
            if (!referredPrimitive.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            Way referredWay = (Way)referredPrimitive;
            for (PTWay ptway : this.ptways) {
                if (!ptway.getWays().contains(referredWay)) continue;
                return ptway;
            }
        }
        return null;
    }

    private PTWay findNearestWayInRadius(OsmPrimitive platform, double searchRadius) {
        if (platform == null) {
            return null;
        }
        LatLon platformCenter = platform.getBBox().getCenter();
        Double ax = platformCenter.getX() - searchRadius;
        Double bx = platformCenter.getX() + searchRadius;
        Double ay = platformCenter.getY() - searchRadius;
        Double by = platformCenter.getY() + searchRadius;
        BBox platformBBox = new BBox(ax.doubleValue(), ay.doubleValue(), bx.doubleValue(), by.doubleValue());
        ArrayList<Way> potentialWays = new ArrayList<Way>();
        Collection allNodes = platform.getDataSet().getNodes();
        for (Node currentNode : allNodes) {
            if (!platformBBox.bounds(currentNode.getBBox())) continue;
            List referrers = currentNode.getReferrers();
            for (OsmPrimitive referrer : referrers) {
                if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                Way referrerWay = (Way)referrer;
                for (PTWay ptway : this.ptways) {
                    if (!ptway.getWays().contains(referrerWay)) continue;
                    potentialWays.add(referrerWay);
                }
            }
        }
        Node platformNode = null;
        platformNode = platform.getType().equals((Object)OsmPrimitiveType.NODE) ? (Node)platform : new Node(platform.getBBox().getCenter());
        Way nearestWay = null;
        Double minDistance = Double.MAX_VALUE;
        for (Way potentialWay : potentialWays) {
            double distance = this.calculateMinDistance(platformNode, potentialWay);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestWay = potentialWay;
        }
        for (PTWay ptway : this.ptways) {
            if (!ptway.getWays().contains(nearestWay)) continue;
            return ptway;
        }
        return null;
    }

    private double calculateMinDistance(Node node, Way way) {
        double minDistance = Double.MAX_VALUE;
        List waySegments = way.getNodePairs(false);
        for (Pair waySegment : waySegments) {
            double distanceToLine;
            if (waySegment.a == node || waySegment.b == node || !((distanceToLine = this.calculateDistance(node, (Pair<Node, Node>)waySegment)) < minDistance)) continue;
            minDistance = distanceToLine;
        }
        return minDistance;
    }

    private double calculateDistance(Node node, Pair<Node, Node> segment) {
        double lengthA = node.getCoor().distance(((Node)segment.a).getCoor());
        double lengthB = node.getCoor().distance(((Node)segment.b).getCoor());
        double lengthC = ((Node)segment.a).getCoor().distance(((Node)segment.b).getCoor());
        double p = (lengthA + lengthB + lengthC) / 2.0;
        double triangleArea = Math.sqrt(p * (p - lengthA) * (p - lengthB) * (p - lengthC));
        return triangleArea * 2.0 / lengthC;
    }

    public static void reinitiate() {
        stopToWay = new HashMap();
    }
}

