/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTRouteDataManager {
    Relation relation;
    private List<PTStop> ptstops = new ArrayList<PTStop>();
    private List<PTWay> ptways = new ArrayList<PTWay>();
    private List<RelationMember> failedMembers = new ArrayList<RelationMember>();

    public PTRouteDataManager(Relation relation) throws IllegalArgumentException {
        this.relation = relation;
        PTStop prev = null;
        for (RelationMember member : this.relation.getMembers()) {
            if (RouteUtils.isPTStop(member)) {
                boolean stopExists = false;
                if (prev != null) {
                    if (prev.getName() == null || prev.getName().equals("") || member.getMember().get("name") == null || member.getMember().get("name").equals("")) {
                        if (this.calculateDistanceSq(member, prev) < 4.0E-6) {
                            stopExists = true;
                        }
                    } else if (prev.getName().equalsIgnoreCase(member.getMember().get("name"))) {
                        stopExists = true;
                    }
                }
                if (stopExists) {
                    prev.addStopElement(member);
                    continue;
                }
                PTStop ptstop = new PTStop(member);
                this.ptstops.add(ptstop);
                prev = ptstop;
                continue;
            }
            if (RouteUtils.isPTWay(member)) {
                PTWay ptway = new PTWay(member);
                this.ptways.add(ptway);
                continue;
            }
            this.failedMembers.add(member);
        }
    }

    private double calculateDistanceSq(RelationMember member1, RelationMember member2) {
        LatLon coord1 = member1.getMember().getBBox().getCenter();
        LatLon coord2 = member2.getMember().getBBox().getCenter();
        return coord1.distanceSq(coord2);
    }

    public PTWay getPTWay(Way inputWay) {
        for (PTWay curr : this.ptways) {
            if (curr.isWay() && curr.getWays().get(0) == inputWay) {
                return curr;
            }
            if (!curr.isRelation()) continue;
            for (RelationMember rm : curr.getRelation().getMembers()) {
                Way wayInNestedRelation = rm.getWay();
                if (wayInNestedRelation != inputWay) continue;
                return curr;
            }
        }
        return null;
    }

    public List<PTStop> getPTStops() {
        return this.ptstops;
    }

    public List<PTWay> getPTWays() {
        return this.ptways;
    }

    public int getPTStopCount() {
        return this.ptstops.size();
    }

    public int getPTWayCount() {
        return this.ptways.size();
    }

    public PTStop getFirstStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(0);
    }

    public PTStop getLastStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(this.ptstops.size() - 1);
    }

    public List<RelationMember> getFailedMembers() {
        return this.failedMembers;
    }

    public PTStop getPTStop(long id) {
        for (PTStop stop : this.ptstops) {
            if (stop.getStopPosition() != null && stop.getStopPosition().getId() == id) {
                return stop;
            }
            if (stop.getPlatform() == null || stop.getPlatform().getId() != id) continue;
            return stop;
        }
        return null;
    }

    public PTWay getPTWay(long id) {
        for (PTWay ptway : this.ptways) {
            for (Way way : ptway.getWays()) {
                if (way.getId() != id) continue;
                return ptway;
            }
        }
        return null;
    }
}

