/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploader;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploaderException;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.tools.I18n;

public class ExecuteActionList
extends MapdustExecuteAction
implements MapdustUpdateObservable {
    private final ArrayList<MapdustUpdateObserver> observers = new ArrayList();

    public ExecuteActionList(MapdustGUI mapdustGUI) {
        this.setMapdustGUI(mapdustGUI);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JToggleButton) {
            try {
                MapdustActionUploader.getInstance().uploadData(this.getMapdustGUI().getMapdustActionList());
            }
            catch (MapdustActionUploaderException e) {
                String errorMessage = "There was an error uploading the ";
                errorMessage = errorMessage + "action list.";
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
            Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
            this.notifyObservers(null, false);
        }
    }

    @Override
    public void addObserver(MapdustUpdateObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustUpdateObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBugFilter filter, boolean first) {
        Iterator<MapdustUpdateObserver> elements = this.observers.iterator();
        while (elements.hasNext()) {
            elements.next().update(filter, false);
        }
    }
}

