/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping.video;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.videomapping.video.Video;
import org.openstreetmap.josm.plugins.videomapping.video.VideoEngine;
import org.openstreetmap.josm.plugins.videomapping.video.VideoObserversEvents;
import org.openstreetmap.josm.plugins.videomapping.video.VideoPlayerObserver;
import org.openstreetmap.josm.plugins.videomapping.video.VideosObserver;
import org.openstreetmap.josm.tools.I18n;
import uk.co.caprica.vlcj.player.DeinterlaceMode;

public class VideoPlayer
extends JFrame
implements WindowListener,
VideosObserver,
VideoPlayerObserver {
    private static final int notificationIntervall = 500;
    protected JPanel screenPanel;
    protected JPanel controlsPanel;
    protected JPanel canvasPanel;
    private JSlider timeline;
    private JButton play;
    private JButton back;
    private JButton forward;
    private JToggleButton loop;
    private JToggleButton mute;
    private JSlider speed;
    private VideoEngine videoengine = new VideoEngine(this);
    private long jumpLength;
    private long loopLength;
    private Timer loopingTimer;
    private boolean isManualJump;
    private Timer notificationTimer;
    private List<VideoPlayerObserver> observers;

    public VideoPlayer(DateFormat videoTimeFormat) throws HeadlessException {
        this.videoengine.addObserver(this);
        this.observers = new LinkedList<VideoPlayerObserver>();
        this.addObserver(this);
        this.setSize(400, 300);
        this.setAlwaysOnTop(true);
        this.createUI();
        this.addUI();
        this.addUIListeners();
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.addWindowListener(this);
    }

    public Video addVideo(File videofile, String id) {
        Video video = new Video(videofile, id, this.videoengine.mediaPlayerFactory);
        this.canvasPanel.add(video.panel);
        video.canvas.setSize(new Dimension(300, 300));
        this.videoengine.add(video);
        this.pack();
        this.startNotificationTimer();
        return video;
    }

    public List<Video> getVideos() {
        return this.videoengine.getVideos();
    }

    public void pause() {
        this.videoengine.pause();
        if (this.videoengine.isNoVideoPlaying()) {
            this.stopNotificationTimer();
        } else {
            this.startNotificationTimer();
        }
    }

    public void pauseAll() {
        this.stopNotificationTimer();
        this.videoengine.pauseAll();
    }

    public void backward() {
        this.videoengine.jumpFor(-this.jumpLength);
    }

    public void forward() {
        this.videoengine.jumpFor(this.jumpLength);
    }

    public void setSpeed(Integer percent) {
        this.speed.setValue(percent);
    }

    public Integer getSpeed() {
        return this.speed.getValue();
    }

    public void setDeinterlacer(DeinterlaceMode deinterlacer) {
        this.videoengine.setDeinterlacer(deinterlacer);
    }

    public void setSubtitles(boolean enabled) {
        this.videoengine.setSubtitles(enabled);
    }

    public void mute() {
        this.videoengine.mute();
    }

    public void toggleLooping() {
        if (this.loopingTimer == null) {
            final long videoResetTime = this.videoengine.getVideoTime() - this.loopLength / 2L;
            TimerTask reset = new TimerTask(){

                @Override
                public void run() {
                    VideoPlayer.this.videoengine.jumpTo(videoResetTime);
                }
            };
            this.loopingTimer = new Timer();
            this.loopingTimer.schedule(reset, this.loopLength / 2L, this.loopLength);
        } else {
            this.loopingTimer.cancel();
            this.loopingTimer = null;
        }
    }

    private void createUI() {
        this.timeline = new JSlider(0, 100, 0);
        this.timeline.setMajorTickSpacing(5);
        this.timeline.setMinorTickSpacing(1);
        this.timeline.setPaintTicks(true);
        this.play = new JButton(I18n.tr((String)"play", (Object[])new Object[0]));
        this.back = new JButton("<");
        this.forward = new JButton(">");
        this.loop = new JToggleButton(I18n.tr((String)"loop", (Object[])new Object[0]));
        this.mute = new JToggleButton(I18n.tr((String)"mute", (Object[])new Object[0]));
        this.speed = new JSlider(0, 200, 100);
        this.speed.setMajorTickSpacing(50);
        this.speed.setPaintTicks(true);
        this.speed.setOrientation(1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(100), new JLabel("1x"));
        labelTable.put(new Integer(50), new JLabel("-2x"));
        labelTable.put(new Integer(200), new JLabel("2x"));
        this.speed.setLabelTable(labelTable);
        this.speed.setPaintLabels(true);
    }

    private void addUI() {
        this.setLayout(new BorderLayout());
        this.screenPanel = new JPanel();
        this.screenPanel.setLayout(new BorderLayout());
        this.controlsPanel = new JPanel();
        this.controlsPanel.setLayout(new FlowLayout());
        this.canvasPanel = new JPanel();
        this.canvasPanel.setLayout(new FlowLayout());
        this.add((Component)this.screenPanel, "Center");
        this.add((Component)this.controlsPanel, "South");
        this.screenPanel.add((Component)this.canvasPanel, "Center");
        this.screenPanel.add((Component)this.timeline, "South");
        this.screenPanel.add((Component)this.speed, "East");
        this.controlsPanel.add(this.play);
        this.controlsPanel.add(this.back);
        this.controlsPanel.add(this.forward);
        this.controlsPanel.add(this.loop);
        this.controlsPanel.add(this.mute);
        this.loop.setSelected(false);
        this.mute.setSelected(false);
    }

    private void addUIListeners() {
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.this.pause();
            }
        });
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.this.backward();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.this.forward();
            }
        });
        this.loop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.this.toggleLooping();
            }
        });
        this.mute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.this.mute();
            }
        });
        this.timeline.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!VideoPlayer.this.isManualJump) {
                    VideoPlayer.this.isManualJump = true;
                    VideoPlayer.this.videoengine.jumpToPosition(VideoPlayer.this.timeline.getValue());
                }
            }
        });
        this.speed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (!VideoPlayer.this.speed.getValueIsAdjusting()) {
                    VideoPlayer.this.videoengine.setSpeed(VideoPlayer.this.speed.getValue());
                }
            }
        });
    }

    public void setJumpLength(long ms) {
        this.jumpLength = ms;
    }

    public void setLoopLength(long ms) {
        this.loopLength = ms;
    }

    public void enableSingleVideoMode(boolean enabled) {
        this.pauseAll();
        this.videoengine.enableSingleVideoMode(enabled);
    }

    public void addObserver(VideoPlayerObserver observer) {
        this.observers.add(observer);
    }

    private void stopNotificationTimer() {
    }

    private void startNotificationTimer() {
        this.notificationTimer = new Timer();
        this.notificationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                VideoPlayer.this.notifyObservers();
            }
        }, 500L, 500L);
    }

    private void notifyObservers() {
        for (VideoPlayerObserver observer : this.observers) {
            observer.update_plays();
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.videoengine.unload();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void update(VideoObserversEvents event) {
        switch (event) {
            case resizing: {
                this.pack();
                break;
            }
            case speeding: {
                this.speed.setValue(this.videoengine.getSpeed());
                break;
            }
        }
    }

    @Override
    public void update_plays() {
        GuiHelper.runInEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                VideoPlayer.this.timeline.setValue(VideoPlayer.this.videoengine.getPosition());
                VideoPlayer.this.setTitle(Long.toString(VideoPlayer.this.videoengine.getVideoTime()));
            }
        });
        this.isManualJump = false;
    }

    public boolean isCorrectlyInitiliazed() {
        return this.videoengine != null && this.videoengine.mediaPlayerFactory != null;
    }
}

