/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Date;
import java.util.logging.Logger;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;

public abstract class CompareFilterImpl
extends BinaryComparisonAbstract {
    static final Logger LOGGER = Logging.getLogger("org.geotools.core");

    protected CompareFilterImpl() throws IllegalFilterException {
    }

    protected CompareFilterImpl(Expression e1, Expression e2) {
        this(e1, e2, true);
    }

    protected CompareFilterImpl(Expression e1, Expression e2, boolean matchCase) {
        super(e1, e2, matchCase);
    }

    @Override
    public void setExpression1(Expression leftValue) {
        this.expression1 = leftValue;
    }

    @Override
    public void setExpression2(Expression rightValue) {
        this.expression2 = rightValue;
    }

    protected int compare(Comparable leftObj, Comparable rightObj) {
        double right;
        if (!(leftObj instanceof Number) || !(rightObj instanceof Number)) {
            if (leftObj.getClass() != rightObj.getClass()) {
                if (leftObj instanceof Date || rightObj instanceof Date) {
                    if (!(leftObj instanceof Date)) {
                        leftObj = Converters.convert(leftObj, Date.class);
                    }
                    if (!(rightObj instanceof Date)) {
                        rightObj = Converters.convert(rightObj, Date.class);
                    }
                    if (leftObj == null || rightObj == null) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else if (leftObj instanceof Number && rightObj.getClass() == String.class) {
                    try {
                        rightObj = new Double(Double.parseDouble((String)rightObj));
                        leftObj = new Double(((Number)leftObj).doubleValue());
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else if (leftObj.getClass() == String.class && rightObj instanceof Number) {
                    try {
                        leftObj = new Double(Double.parseDouble((String)leftObj));
                        rightObj = new Double(((Number)rightObj).doubleValue());
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            } else if (leftObj instanceof String && rightObj instanceof String) {
                try {
                    leftObj = new Double(Double.parseDouble((String)leftObj));
                    rightObj = new Double(Double.parseDouble((String)rightObj));
                }
                catch (Exception e) {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            }
            return leftObj.compareTo(rightObj);
        }
        double left = ((Number)leftObj).doubleValue();
        return left > (right = ((Number)rightObj).doubleValue()) ? 1 : (left == right ? 0 : -1);
    }

    public String toString() {
        short filterType = Filters.getFilterType(this);
        if (filterType == 21) {
            return "[ " + this.expression1 + " IS NULL ]";
        }
        String operator = null;
        if (filterType == 14) {
            operator = " = ";
        }
        if (filterType == 15) {
            operator = " < ";
        }
        if (filterType == 16) {
            operator = " > ";
        }
        if (filterType == 17) {
            operator = " <= ";
        }
        if (filterType == 18) {
            operator = " >= ";
        }
        if (filterType == 23) {
            operator = " != ";
        }
        return "[ " + this.expression1 + operator + this.expression2 + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompareFilterImpl) {
            CompareFilterImpl cFilter = (CompareFilterImpl)obj;
            short filterType = Filters.getFilterType(this);
            return filterType == Filters.getFilterType(cFilter) && (this.expression1 == cFilter.getExpression1() || this.expression1 != null && this.expression1.equals(cFilter.getExpression1())) && (this.expression2 == cFilter.getExpression2() || this.expression2 != null && this.expression2.equals(cFilter.getExpression2()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        short filterType = Filters.getFilterType(this);
        result = 37 * result + filterType;
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

