/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;

public class FilteringSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    Filter filter;

    public FilteringSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, Filter filter) {
        this(DataUtilities.simple(delegate), filter);
    }

    public FilteringSimpleFeatureCollection(SimpleFeatureCollection delegate, Filter filter) {
        super(delegate);
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new FilteringSimpleFeatureIterator(this.delegate.features(), this.filter);
    }

    public void close(SimpleFeatureIterator close) {
        close.close();
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        And subFilter = ff.and(this.filter, filter);
        return new FilteringSimpleFeatureCollection(this.delegate, (Filter)subFilter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int count = 0;
        try (SimpleFeatureIterator i = this.features();){
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            int n = count;
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList list = new ArrayList();
        try (SimpleFeatureIterator i = this.features();){
            while (i.hasNext()) {
                list.add(i.next());
            }
            T[] TArray = list.toArray(a);
            return TArray;
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o) && this.filter.evaluate(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds(this);
    }
}

