/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.files;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.util.logging.Logging;

class ShpFilesLocker {
    static final Logger LOGGER = Logging.getLogger("org.geotools.data.shapefile");
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.shapefile.trace"));
    final URI uri;
    final URL url;
    final FileReader reader;
    final FileWriter writer;
    boolean upgraded;
    private Trace trace;

    public ShpFilesLocker(URL url, FileReader reader) {
        this.url = url;
        this.reader = reader;
        this.writer = null;
        LOGGER.fine("Read lock: " + url + " by " + reader.id());
        this.setTraceException();
        this.uri = this.getURI(url);
    }

    URI getURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public ShpFilesLocker(URL url, FileWriter writer) {
        this.url = url;
        this.reader = null;
        this.writer = writer;
        LOGGER.fine("Write lock: " + url + " by " + writer.id());
        this.setTraceException();
        this.uri = this.getURI(url);
    }

    private void setTraceException() {
        String id;
        String type;
        String name = Thread.currentThread().getName();
        if (this.reader != null) {
            type = "read";
            id = this.reader.id();
        } else {
            type = "write";
            id = this.writer.id();
        }
        if (TRACE_ENABLED.booleanValue()) {
            this.trace = new Trace("Locking " + this.url + " for " + type + " by " + id + " in thread " + name);
        }
    }

    public Exception getTrace() {
        return this.trace;
    }

    public void compare(URL url2, Object requestor) {
        URL url = this.url;
        assert (url2 == url) : "Expected: " + url + " but got: " + url2;
        assert (this.reader == null || requestor == this.reader) : "Expected the requestor and the reader to be the same object: " + this.reader.id();
        assert (this.writer == null || requestor == this.writer) : "Expected the requestor and the writer to be the same object: " + this.writer.id();
    }

    public String toString() {
        if (this.reader != null) {
            return "read on " + this.url + " by " + this.reader.id();
        }
        return "write on " + this.url + " by " + this.writer.id();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.writer == null ? 0 : this.writer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShpFilesLocker other = (ShpFilesLocker)obj;
        if (this.reader == null ? other.reader != null : !this.reader.equals(other.reader)) {
            return false;
        }
        if (this.url == null ? other.url != null : (this.uri != null ? !this.uri.equals(other.uri) : !this.url.equals(other.url))) {
            return false;
        }
        return !(this.writer == null ? other.writer != null : !this.writer.equals(other.writer));
    }

    private static class Trace
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Trace(String message) {
            super(message);
        }
    }
}

