/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.image.BufferedImage;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import org.geotools.image.io.BaseGridCoverageProgressAdapter;
import org.opengis.util.ProgressListener;

public class GridCoverageReaderProgressAdapter
extends BaseGridCoverageProgressAdapter
implements IIOReadProgressListener,
IIOReadUpdateListener,
IIOReadWarningListener {
    public GridCoverageReaderProgressAdapter(ProgressListener monitor, int numImages) {
        super(monitor, numImages);
    }

    public GridCoverageReaderProgressAdapter(ProgressListener monitor) {
        this(monitor, 1);
    }

    @Override
    public void warningOccurred(ImageReader source, String warning) {
        this.monitor.warningOccurred(source.getInput().toString(), "Warning writing image:" + this.lastImageIndex, warning);
    }

    @Override
    public void passStarted(ImageReader source, BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
    }

    @Override
    public void imageUpdate(ImageReader source, BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
    }

    @Override
    public void passComplete(ImageReader source, BufferedImage theImage) {
    }

    @Override
    public void thumbnailPassStarted(ImageReader source, BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
    }

    @Override
    public void thumbnailUpdate(ImageReader source, BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
    }

    @Override
    public void thumbnailPassComplete(ImageReader source, BufferedImage theThumbnail) {
    }

    @Override
    public void sequenceStarted(ImageReader source, int minIndex) {
    }

    @Override
    public void sequenceComplete(ImageReader source) {
    }

    @Override
    public void imageStarted(ImageReader source, int imageIndex) {
        if (imageIndex == 0) {
            this.monitor.started();
        }
        this.lastImageIndex = imageIndex;
        float progress = (float)this.lastImageIndex * this.progressStep * 100.0f;
        this.reportProgress(progress, source);
    }

    @Override
    public void imageProgress(ImageReader source, float percentageDone) {
        float tempProgress = (float)this.lastImageIndex * this.progressStep * 100.0f + percentageDone * this.progressStep;
        if ((double)(tempProgress - this.progress) > 5.0) {
            this.reportProgress(tempProgress, source);
            this.progress = tempProgress;
        }
    }

    @Override
    public void imageComplete(ImageReader source) {
        float progress = (float)(this.lastImageIndex + 1) * this.progressStep * 100.0f;
        this.reportProgress(progress, source);
        if (this.lastImageIndex == this.numImages - 1) {
            this.monitor.complete();
        }
    }

    @Override
    public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
    }

    @Override
    public void thumbnailProgress(ImageReader source, float percentageDone) {
    }

    @Override
    public void thumbnailComplete(ImageReader source) {
    }

    @Override
    public void readAborted(ImageReader source) {
    }

    private void reportProgress(float progress, ImageReader reader) {
        this.monitor.progress(progress);
        if (this.monitor.isCanceled()) {
            reader.abort();
        }
    }
}

