/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.WMSLayer;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class CadastreSessionImporter
implements SessionLayerImporter {
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr((String)"Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", (Object[])new Object[]{version}));
        }
        try {
            String ext;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression fileExp = xpath.compile("file/text()");
            String fileStr = (String)fileExp.evaluate(elem, XPathConstants.STRING);
            if (fileStr == null || fileStr.isEmpty()) {
                throw new IllegalDataException(I18n.tr((String)"File name expected for layer no. {0}", (Object[])new Object[]{support.getLayerIndex()}));
            }
            fileStr = URLDecoder.decode(fileStr, "UTF-8");
            String filename = (fileStr = fileStr.substring(fileStr.indexOf(":/") + 2)).substring(fileStr.lastIndexOf(47) + 1, fileStr.length());
            String string = ext = filename.lastIndexOf(46) == -1 ? "" : filename.substring(filename.lastIndexOf(46) + 1, filename.length());
            if (ext.length() == 3 && ext.substring(0, "CC".length()).equals("CC")) {
                ext = ext.substring(2);
            } else if (ext.length() == 4 && ext.substring(0, "UTM".length()).equals("UTM")) {
                ext = ext.substring(3);
            } else if (ext.length() == 2 || ext.length() > 4) {
                throw new IllegalDataException(I18n.tr((String)"Unexpected file extension. {0}", (Object[])new Object[]{ext}));
            }
            int layoutZone = Integer.parseInt(ext) - 1;
            WMSLayer wmsLayer = new WMSLayer("", "", layoutZone);
            File file = new File(fileStr);
            wmsLayer.grabThread.getCacheControl().loadCache(file, layoutZone);
            return wmsLayer;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }
}

