/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link;

import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkRuleChecker;
import org.openstreetmap.josm.plugins.tag2link.listeners.MembershipPopupListener;
import org.openstreetmap.josm.plugins.tag2link.listeners.PropertyPopupListener;
import org.openstreetmap.josm.plugins.tag2link.listeners.RelationPopupListener;
import org.openstreetmap.josm.plugins.tag2link.listeners.SelectionPopupListener;

public class Tag2LinkPlugin
extends Plugin {
    private SelectionPopupListener selectionPopupListener;
    private MembershipPopupListener membershipPopupListener;
    private PropertyPopupListener propertyPopupListener;
    private RelationPopupListener relationPopupListener;

    public Tag2LinkPlugin(PluginInformation info) {
        super(info);
        Tag2LinkRuleChecker.init();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.selectionPopupListener = new SelectionPopupListener(newFrame);
            newFrame.selectionListDialog.getPopupMenuHandler().addListener((PopupMenuListener)this.selectionPopupListener);
            this.membershipPopupListener = new MembershipPopupListener(newFrame);
            newFrame.propertiesDialog.getMembershipPopupMenuHandler().addListener((PopupMenuListener)this.membershipPopupListener);
            this.propertyPopupListener = new PropertyPopupListener(newFrame);
            newFrame.propertiesDialog.getPropertyPopupMenuHandler().addListener((PopupMenuListener)this.propertyPopupListener);
            this.relationPopupListener = new RelationPopupListener(newFrame);
            newFrame.relationListDialog.getPopupMenuHandler().addListener((PopupMenuListener)this.relationPopupListener);
        } else if (oldFrame != null) {
            if (oldFrame.selectionListDialog != null) {
                oldFrame.selectionListDialog.getPopupMenuHandler().removeListener((PopupMenuListener)this.selectionPopupListener);
            }
            if (oldFrame.propertiesDialog != null) {
                oldFrame.propertiesDialog.getMembershipPopupMenuHandler().removeListener((PopupMenuListener)this.membershipPopupListener);
                oldFrame.propertiesDialog.getPropertyPopupMenuHandler().removeListener((PopupMenuListener)this.propertyPopupListener);
            }
            if (oldFrame.relationListDialog != null) {
                oldFrame.relationListDialog.getPopupMenuHandler().removeListener((PopupMenuListener)this.relationPopupListener);
            }
            this.selectionPopupListener = null;
            this.membershipPopupListener = null;
            this.propertyPopupListener = null;
            this.relationPopupListener = null;
        }
    }
}

