/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import wmsturbochallenge.GameWindow;

public class WMSRacer
extends Plugin
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    protected DriveAction driveAction = new DriveAction();

    public WMSRacer(PluginInformation info) {
        super(info);
        this.driveAction.updateEnabledState();
        JMenu toolsMenu = Main.main.menu.toolsMenu;
        toolsMenu.addSeparator();
        toolsMenu.add(new JMenuItem((Action)((Object)this.driveAction)));
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null) {
            Main.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
            Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        }
        this.driveAction.frame = newFrame;
        this.driveAction.updateEnabledState();
        if (newFrame != null) {
            Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
            Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.driveAction.currentLayer = Main.getLayerManager().getActiveLayer();
        this.driveAction.updateEnabledState();
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.driveAction.updateEnabledState();
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.driveAction.updateEnabledState();
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    protected class DriveAction
    extends JosmAction {
        public MapFrame frame;
        public Layer currentLayer;
        protected Layer groundLayer;

        public DriveAction() {
            super(I18n.tr((String)"Go driving", (Object[])new Object[0]), "wmsracer", I18n.tr((String)"Drive a race car on this layer", (Object[])new Object[0]), null, true);
            this.frame = null;
            this.currentLayer = null;
            this.groundLayer = null;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.groundLayer == null || !this.groundLayer.isBackgroundLayer()) {
                return;
            }
            new GameWindow(this.groundLayer);
        }

        public void updateEnabledState() {
            if (this.frame == null) {
                this.groundLayer = null;
                this.setEnabled(false);
                return;
            }
            if (this.currentLayer != null && this.currentLayer.isBackgroundLayer()) {
                this.groundLayer = this.currentLayer;
                this.setEnabled(true);
                return;
            }
            for (Layer l : this.frame.mapView.getLayerManager().getLayers()) {
                if (!l.isBackgroundLayer()) continue;
                this.groundLayer = l;
                this.setEnabled(true);
                return;
            }
            this.groundLayer = null;
            this.setEnabled(false);
        }
    }
}

