/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.EditorFactory;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.UniversalListRenderer;
import org.openstreetmap.josm.tools.ImageProvider;

public class SuburbEditor
extends ExtendedDialog {
    private Suburb suburb = null;
    private AddressElement parent = null;
    private House selectedHouse = null;
    private Street selectedStreet = null;
    private JButton houseEditButton;
    private JList<House> houseList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField1;
    private JPanel mainPanel;
    private JTextField nameField;
    private JButton parentEditButton;
    private JTextField parentField;
    private JButton streetEditButton;
    private JList<Street> streetList;

    public SuburbEditor(Suburb suburb) {
        super(Main.parent, "Upravit m\u011bstskou \u010dtvr\u0165", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.suburb = suburb;
        this.parent = suburb.getParent();
        this.nameField.setText(suburb.getName());
        if (this.parent != null) {
            this.parentField.setText(this.parent.getName());
        } else {
            this.parentField.setEnabled(false);
        }
        this.parentEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        this.parentEditButton.setText("");
        this.parentEditButton.setEnabled(EditorFactory.isEditable(this.parent));
        this.houseList.setModel(new DefaultComboBoxModel<House>(suburb.getHouses().toArray(new House[0])));
        this.houseList.setCellRenderer(new UniversalListRenderer());
        this.houseEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        this.houseEditButton.setText("");
        this.houseListChanged(null);
        this.streetList.setModel(new DefaultComboBoxModel<Street>(suburb.getStreets().toArray(new Street[0])));
        this.streetList.setCellRenderer(new UniversalListRenderer());
        this.streetEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        this.streetEditButton.setText("");
        this.streetListChanged(null);
        this.setContent(this.mainPanel);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setDefaultButton(1);
        this.setCancelButton(new Integer[]{2});
        this.setupDialog();
    }

    public String getSuburbName() {
        return this.nameField.getText();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.parentField = new JTextField();
        this.jLabel2 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.houseList = new JList();
        this.parentEditButton = new JButton();
        this.houseEditButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.streetList = new JList();
        this.streetEditButton = new JButton();
        this.jLabel4 = new JLabel();
        this.setLayout(new GridLayout());
        this.jLabel1.setText("Rodi\u010d:");
        this.jTextField1.setText("jTextField1");
        this.parentField.setEditable(false);
        this.jLabel2.setText("Jm\u00e9no:");
        this.jLabel3.setText("Domy:");
        this.houseList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SuburbEditor.this.houseListChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.houseList);
        this.parentEditButton.setText("    ");
        this.parentEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuburbEditor.this.parentEditButtonActionPerformed(evt);
            }
        });
        this.houseEditButton.setText("    ");
        this.houseEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuburbEditor.this.houseEditButtonActionPerformed(evt);
            }
        });
        this.streetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SuburbEditor.this.streetListChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.streetList);
        this.streetEditButton.setText("    ");
        this.streetEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuburbEditor.this.streetEditButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Ulice:");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 330, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.streetEditButton)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.parentField, -1, 330, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parentEditButton)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 330, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.houseEditButton)).addComponent(this.nameField, GroupLayout.Alignment.TRAILING, -1, 364, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parentField, -2, -1, -2).addComponent(this.parentEditButton).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.houseEditButton).addComponent(this.jScrollPane1, -2, 77, -2))).addGroup(mainPanelLayout.createSequentialGroup().addGap(66, 66, 66).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.streetEditButton).addComponent(this.jScrollPane2, -2, 77, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.mainPanel);
    }

    private void houseListChanged(ListSelectionEvent evt) {
        this.selectedHouse = this.houseList.getSelectedValue();
        this.houseEditButton.setEnabled(EditorFactory.isEditable(this.selectedHouse));
    }

    private void parentEditButtonActionPerformed(ActionEvent evt) {
        assert (this.parent != null);
        if (EditorFactory.edit(this.parent)) {
            this.parentField.setText(this.parent.getName());
        }
    }

    private void houseEditButtonActionPerformed(ActionEvent evt) {
        assert (this.selectedHouse != null);
        if (EditorFactory.editHouse(this.selectedHouse)) {
            this.houseList.setModel(new DefaultComboBoxModel<House>(this.suburb.getHouses().toArray(new House[0])));
        }
    }

    private void streetListChanged(ListSelectionEvent evt) {
        this.selectedStreet = this.streetList.getSelectedValue();
        this.streetEditButton.setEnabled(EditorFactory.isEditable(this.selectedStreet));
    }

    private void streetEditButtonActionPerformed(ActionEvent evt) {
        assert (this.selectedStreet != null);
        if (EditorFactory.editStreet(this.selectedStreet)) {
            this.streetList.setModel(new DefaultComboBoxModel<Street>(this.suburb.getStreets().toArray(new Street[0])));
        }
    }
}

