/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetStrokingDeviceN;
import org.apache.pdfbox.util.operator.SetStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetStrokingIndexed;
import org.apache.pdfbox.util.operator.SetStrokingLabColor;
import org.apache.pdfbox.util.operator.SetStrokingPattern;
import org.apache.pdfbox.util.operator.SetStrokingRGBColor;
import org.apache.pdfbox.util.operator.SetStrokingSeparation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStrokingColor
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(SetStrokingColor.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PDColorSpace colorSpace = this.context.getGraphicsState().getStrokingColor().getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetStrokingCalRGBColor();
            } else if (colorSpace instanceof PDSeparation) {
                newOperator = new SetStrokingSeparation();
            } else if (colorSpace instanceof PDDeviceN) {
                newOperator = new SetStrokingDeviceN();
            } else if (colorSpace instanceof PDPattern) {
                newOperator = new SetStrokingPattern();
            } else if (colorSpace instanceof PDIndexed) {
                newOperator = new SetStrokingIndexed();
            } else if (colorSpace instanceof PDLab) {
                newOperator = new SetStrokingLabColor();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, arguments);
            } else {
                LOG.info((Object)("Not supported colorspace " + colorSpace.getName() + " within operator " + operator.getOperation()));
            }
        } else {
            LOG.warn((Object)("Colorspace not found in " + this.getClass().getName() + ".process!!"));
        }
    }
}

