/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.tracer2.StraightLine;
import org.openstreetmap.josm.plugins.tracer2.TracerDebug;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class ConnectWays {
    static double s_dMinDistance = 6.0E-6;
    static double s_dMinDistanceN2N = 5.0E-7;
    static double s_dMinDistanceN2oW = 1.0E-6;
    static double s_dMinDistanceN2tW = 1.0E-6;
    static final double MAX_ANGLE = 30.0;
    static Way s_oWay;
    static Way s_oWayOld;
    static List<Way> s_oWays;
    static List<Node> s_oNodes;
    static ServerParam s_oParam;
    static boolean s_bCtrl;
    static boolean s_bAlt;
    static boolean s_bAddNewWay;

    private static void calcDistance() {
        double dTileSize = Double.parseDouble(s_oParam.getTileSize());
        double dResolution = Double.parseDouble(s_oParam.getResolution());
        double dMin = dTileSize / dResolution;
        s_dMinDistance = dMin * 30.0;
        s_dMinDistanceN2N = dMin * 2.5;
        s_dMinDistanceN2oW = dMin * 5.0;
        s_dMinDistanceN2tW = dMin * 5.0;
    }

    private static void getWays(Way way) {
        BBox bbox = new BBox(way);
        bbox.addPrimitive((OsmPrimitive)way, s_dMinDistance);
        s_oWays = Main.getLayerManager().getEditDataSet().searchWays(bbox);
    }

    private static List<Way> getWaysOfNode(Node node) {
        List ways = OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class);
        return ways;
    }

    private static void getNodes(Way way) {
        BBox bbox = new BBox(way);
        bbox.addPrimitive((OsmPrimitive)way, s_dMinDistance);
        s_oNodes = Main.getLayerManager().getEditDataSet().searchNodes(bbox);
    }

    private static double calcAlpha(LatLon oP1, Node n) {
        LatLon oP2 = n.getCoor();
        double dAlpha = Math.atan((oP2.getY() - oP1.getY()) / (oP2.getX() - oP1.getX())) * 180.0 / Math.PI + (double)(oP1.getX() > oP2.getX() ? 180 : 0);
        return ConnectWays.checkAlpha(dAlpha);
    }

    private static Double checkAlpha(Double dAlpha) {
        if (dAlpha > 180.0) {
            return dAlpha - 360.0;
        }
        if (dAlpha <= -180.0) {
            return dAlpha + 360.0;
        }
        return dAlpha;
    }

    private static boolean isNodeInsideWay(LatLon pos, Way way) {
        List listNode = way.getNodes();
        double dAlphaOld = ConnectWays.calcAlpha(pos, (Node)listNode.get(listNode.size() - 1));
        double dSumAlpha = 0.0;
        for (Node n : listNode) {
            double dAlpha = ConnectWays.calcAlpha(pos, n);
            dSumAlpha += ConnectWays.checkAlpha(dAlpha - dAlphaOld).doubleValue();
            dAlphaOld = dAlpha;
        }
        return (dSumAlpha = Math.abs(dSumAlpha)) > 359.0 && dSumAlpha < 361.0;
    }

    private static Way getOldWay(LatLon pos) {
        for (int i = 0; i < s_oWays.size(); ++i) {
            Way way = s_oWays.get(i);
            if (!ConnectWays.isSameTag((OsmPrimitive)way) || !ConnectWays.isNodeInsideWay(pos, way)) continue;
            s_oWays.remove(way);
            return way;
        }
        return null;
    }

    public static Command connect(Way newWay, LatLon pos, ServerParam param, boolean ctrl, boolean alt) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Object> cmds2 = new LinkedList<Object>();
        s_oParam = param;
        s_bCtrl = ctrl;
        s_bAlt = alt;
        boolean bAddWay = false;
        ConnectWays.calcDistance();
        ConnectWays.getNodes(newWay);
        ConnectWays.getWays(newWay);
        s_oWayOld = ConnectWays.getOldWay(pos);
        if (s_oWayOld == null) {
            s_bAddNewWay = true;
            bAddWay = true;
            s_oWayOld = newWay;
            s_oWay = new Way(newWay);
        } else {
            int i;
            s_bAddNewWay = false;
            Way tempWay = new Way(s_oWayOld);
            for (i = 0; i < newWay.getNodesCount(); ++i) {
                tempWay.addNode(tempWay.getNodesCount(), newWay.getNode(i));
            }
            ++i;
            for (i = 0; i < s_oWayOld.getNodesCount() - 1; ++i) {
                tempWay.removeNode(s_oWayOld.getNode(i));
            }
            for (i = 0; i < s_oWayOld.getNodesCount() - 1; ++i) {
                Node n = s_oWayOld.getNode(i);
                List<Way> ways = ConnectWays.getWaysOfNode(n);
                if (ways.size() <= 1) {
                    cmds2.add(new DeleteCommand((OsmPrimitive)s_oWayOld.getNode(i)));
                }
                s_oNodes.remove(s_oWayOld.getNode(i));
            }
            s_oWay = tempWay;
        }
        cmds2.addAll(ConnectWays.connectTo());
        Node firstNode = null;
        Way way = new Way(s_oWay);
        for (Node node : s_oWay.getNodes()) {
            if (node.getDataSet() == null) continue;
            way.removeNode(node);
        }
        if (way.getNodes().size() > 0) {
            if (way.firstNode() != way.lastNode()) {
                way.addNode(way.firstNode());
            }
            for (Node node : way.getNodes()) {
                if (firstNode == null || firstNode != node) {
                    cmds.add((Command)new AddCommand((OsmPrimitive)node));
                }
                if (firstNode != null) continue;
                firstNode = node;
            }
        }
        if (bAddWay) {
            cmds.add((Command)new AddCommand((OsmPrimitive)s_oWay));
        }
        cmds.add((Command)new ChangeCommand((OsmPrimitive)s_oWayOld, (OsmPrimitive)ConnectWays.trySplitWayByAnyNodes(s_oWay)));
        cmds.addAll(cmds2);
        TracerDebug oTracerDebug = new TracerDebug();
        oTracerDebug.OutputCommands(cmds);
        SequenceCommand cmd = new SequenceCommand(I18n.tr((String)"Merge objects nodes", (Object[])new Object[0]), cmds);
        return cmd;
    }

    public static List<Command> connectTo() {
        HashMap<Way, Way> modifiedWays = new HashMap<Way, Way>();
        LinkedList<Command> cmds = new LinkedList<Command>();
        Way way = new Way(s_oWay);
        for (int i = 0; i < way.getNodesCount() - 1; ++i) {
            Node n = way.getNode(i);
            System.out.println("-------");
            System.out.println("Node: " + n);
            LatLon ll = n.getCoor();
            double minDistanceSq = s_dMinDistanceN2N;
            Node nearestNode = null;
            for (Node nn : s_oNodes) {
                double dist;
                System.out.println("Node: " + nn);
                if (!nn.isUsable() || way.containsNode(nn) || s_oWay.containsNode(nn) || !ConnectWays.isInSameTag(nn) || !((dist = nn.getCoor().distance(ll)) < minDistanceSq)) continue;
                minDistanceSq = dist;
                nearestNode = nn;
            }
            System.out.println("Nearest: " + nearestNode + " distance: " + minDistanceSq);
            if (nearestNode == null) {
                ConnectWays.tryConnectNodeToAnyWay(n, modifiedWays);
                continue;
            }
            System.out.println("+add Node distance: " + minDistanceSq);
            cmds.addAll(ConnectWays.mergeNodes(n, nearestNode));
        }
        for (Map.Entry e : modifiedWays.entrySet()) {
            cmds.add((Command)new ChangeCommand((OsmPrimitive)e.getKey(), (OsmPrimitive)e.getValue()));
        }
        LinkedList<Command> cmd = cmds;
        return cmd;
    }

    private static List<Command> mergeNodes(Node n1, Node n2) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        cmds.add((Command)new MoveCommand((OsmPrimitive)n2, (n1.getEastNorth().getX() - n2.getEastNorth().getX()) / 2.0, (n1.getEastNorth().getY() - n2.getEastNorth().getY()) / 2.0));
        Way newWay = new Way(s_oWay);
        int j = s_oWay.getNodes().indexOf(n1);
        newWay.addNode(j, n2);
        if (j == 0) {
            newWay.addNode(newWay.getNodesCount(), n2);
        }
        newWay.removeNode(n1);
        if (newWay.firstNode() != newWay.lastNode()) {
            newWay.addNode(newWay.firstNode());
        }
        s_oWay = new Way(newWay);
        return cmds;
    }

    private static void tryConnectNodeToAnyWay(Node node, Map<Way, Way> m) throws IllegalStateException, IndexOutOfBoundsException {
        LatLon ll = node.getCoor();
        double minDist = Double.MAX_VALUE;
        Way nearestWay = null;
        int nearestNodeIndex = 0;
        for (Way ww : s_oWays) {
            System.out.println("Way: " + ww);
            if (!ww.isUsable() || ww.containsNode(node) || !ConnectWays.isSameTag((OsmPrimitive)ww)) continue;
            if (m.get(ww) != null) {
                ww = m.get(ww);
            }
            for (Pair np : ww.getNodePairs(false)) {
                double dist = ConnectWays.distanceFromSegment2(ll, ((Node)np.a).getCoor(), ((Node)np.b).getCoor());
                if (!(dist < minDist)) continue;
                minDist = dist;
                nearestWay = ww;
                nearestNodeIndex = ww.getNodes().indexOf(np.a);
            }
        }
        System.out.println("Nearest way: " + nearestWay + " distance: " + minDist);
        if (minDist < s_dMinDistanceN2oW) {
            Way newNWay = new Way(nearestWay);
            newNWay.addNode(nearestNodeIndex + 1, node);
            System.out.println("New way:" + newNWay);
            System.out.println("+add WayOld.Node distance: " + minDist);
            m.put(nearestWay, newNWay);
            s_oWays.remove(newNWay);
            s_oWays.add(nearestWay);
        }
    }

    private static double distanceFromSegment2(LatLon c, LatLon a, LatLon b) {
        StraightLine oStraightLine1 = new StraightLine(new Point2D.Double(a.getX(), a.getY()), new Point2D.Double(b.getX(), b.getY()));
        StraightLine oStraightLine2 = new StraightLine(new Point2D.Double(c.getX(), c.getY()), new Point2D.Double(c.getX() + (a.getY() - b.getY()), c.getY() - (a.getX() - b.getX())));
        Point2D.Double oPoint = oStraightLine1.GetIntersectionPoint(oStraightLine2);
        if (oPoint.x > a.getX() && oPoint.x > b.getX() || oPoint.x < a.getX() && oPoint.x < b.getX() || oPoint.y > a.getY() && oPoint.y > b.getY() || oPoint.y < a.getY() && oPoint.y < b.getY()) {
            return 100000.0;
        }
        double x = c.getX() - oPoint.getX();
        double y = c.getY() - oPoint.getY();
        return Math.sqrt(x * x + y * y);
    }

    private static Way trySplitWayByAnyNodes(Way way) throws IndexOutOfBoundsException, IllegalStateException {
        int i = 0;
        while (i < way.getNodesCount()) {
            LatLon n1 = ((Node)way.getNodes().get(i)).getCoor();
            LatLon n2 = ((Node)way.getNodes().get((i + 1) % way.getNodesCount())).getCoor();
            System.out.println(way.getNodes().get(i) + "-----" + way.getNodes().get((i + 1) % way.getNodesCount()));
            double minDistanceSq = Double.MAX_VALUE;
            Node nearestNode = null;
            for (Node nod : s_oNodes) {
                if (!nod.isUsable() || way.containsNode(nod) || !ConnectWays.isInSameTag(nod)) continue;
                LatLon nn = nod.getCoor();
                double dist = ConnectWays.distanceFromSegment2(nn, n1, n2);
                if (n1.equalsEpsilon(nn) || n2.equalsEpsilon(nn) || !(dist < minDistanceSq)) continue;
                minDistanceSq = dist;
                nearestNode = nod;
            }
            System.out.println("Nearest_: " + nearestNode + " distance: " + minDistanceSq);
            if (nearestNode == null || minDistanceSq >= s_dMinDistanceN2tW) {
                ++i;
                System.out.println("");
                continue;
            }
            way.addNode(i + 1, nearestNode);
            ++i;
            System.out.println("+add Way.Node distance: " + minDistanceSq);
            System.out.println("");
        }
        return way;
    }

    private static boolean isInSameTag(Node n) {
        for (OsmPrimitive op : n.getReferrers()) {
            if (!(op instanceof Way) || !ConnectWays.isSameTag((OsmPrimitive)((Way)op))) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isSameTag(OsmPrimitive p) {
        String v = p.get(s_oParam.getTag());
        if (s_bCtrl || s_oParam.getTag().equals("")) {
            return v == null || v.equals("no");
        }
        if (s_oParam.getTag().equals("building")) {
            return v != null && !v.equals("no") && !v.equals("entrance");
        }
        return v != null && !v.equals("no");
    }
}

