/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.tracer.TracerGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class ConnectWays {
    static final double MIN_DISTANCE = 5.0E-6;
    static final double MIN_DISTANCE_TW = 5.0E-6;
    static final double MIN_DISTANCE_SQ = 5.0E-6;
    static final double MAX_ANGLE = 30.0;

    public static Command connect(Way way) {
        HashMap<Way, Way> modifiedWays = new HashMap<Way, Way>();
        LinkedList<Object> cmds = new LinkedList<Object>();
        Way newWay = new Way(way);
        for (int i = 0; i < way.getNodesCount() - 1; ++i) {
            Node n = way.getNode(i);
            System.out.println("-------");
            System.out.println("Node: " + n);
            LatLon ll = n.getCoor();
            BBox bbox = new BBox(ll.getX() - 5.0E-6, ll.getY() - 5.0E-6, ll.getX() + 5.0E-6, ll.getY() + 5.0E-6);
            double minDistanceSq = 5.0E-6;
            List nodes = Main.getLayerManager().getEditDataSet().searchNodes(bbox);
            Node nearestNode = null;
            for (Node nn : nodes) {
                double dist;
                if (!nn.isUsable() || way.containsNode(nn) || newWay.containsNode(nn) || !ConnectWays.isInBuilding(nn) || !((dist = nn.getCoor().distance(ll)) < minDistanceSq)) continue;
                minDistanceSq = dist;
                nearestNode = nn;
            }
            System.out.println("Nearest: " + nearestNode);
            if (nearestNode == null) {
                ConnectWays.tryConnectNodeToAnyWay(n, modifiedWays);
                continue;
            }
            cmds.addAll(ConnectWays.mergeNodes(n, nearestNode, newWay));
        }
        for (Map.Entry e : modifiedWays.entrySet()) {
            cmds.add(new ChangeCommand((OsmPrimitive)e.getKey(), (OsmPrimitive)e.getValue()));
        }
        cmds.addFirst(new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)ConnectWays.trySplitWayByAnyNodes(newWay)));
        SequenceCommand cmd = new SequenceCommand(I18n.tr((String)"Merge objects nodes", (Object[])new Object[0]), cmds);
        return cmd;
    }

    private static List<Command> mergeNodes(Node n1, Node n2, Way way) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        cmds.add((Command)new MoveCommand((OsmPrimitive)n2, (n1.getEastNorth().getX() - n2.getEastNorth().getX()) / 2.0, (n1.getEastNorth().getY() - n2.getEastNorth().getY()) / 2.0));
        int j = way.getNodes().indexOf(n1);
        way.addNode(j, n2);
        if (j == 0) {
            way.addNode(way.getNodesCount(), n2);
        }
        way.removeNode(n1);
        cmds.add((Command)new DeleteCommand((OsmPrimitive)n1));
        return cmds;
    }

    private static void tryConnectNodeToAnyWay(Node node, Map<Way, Way> m) throws IllegalStateException, IndexOutOfBoundsException {
        LatLon ll = node.getCoor();
        BBox bbox = new BBox(ll.getX() - 5.0E-6, ll.getY() - 5.0E-6, ll.getX() + 5.0E-6, ll.getY() + 5.0E-6);
        List ways = Main.getLayerManager().getEditDataSet().searchWays(bbox);
        double minDist = Double.MAX_VALUE;
        Way nearestWay = null;
        int nearestNodeIndex = 0;
        for (Way ww : ways) {
            if (!ww.isUsable() || ww.containsNode(node) || !ConnectWays.isBuilding(ww)) continue;
            if (m.get(ww) != null) {
                ww = m.get(ww);
            }
            for (Pair np : ww.getNodePairs(false)) {
                double dist = TracerGeometry.distanceFromSegment(ll, ((Node)np.a).getCoor(), ((Node)np.b).getCoor());
                if (!(dist < minDist)) continue;
                minDist = dist;
                nearestWay = ww;
                nearestNodeIndex = ww.getNodes().indexOf(np.a);
            }
        }
        System.out.println("Nearest way: " + nearestWay + " distance: " + minDist);
        if (minDist < 5.0E-6) {
            Way newNWay = new Way(nearestWay);
            newNWay.addNode(nearestNodeIndex + 1, node);
            System.out.println("New way:" + newNWay);
            m.put(nearestWay, newNWay);
        }
    }

    private static Way trySplitWayByAnyNodes(Way way) throws IndexOutOfBoundsException, IllegalStateException {
        int i = 0;
        while (i < way.getNodesCount()) {
            LatLon n1 = ((Node)way.getNodes().get(i)).getCoor();
            LatLon n2 = ((Node)way.getNodes().get((i + 1) % way.getNodesCount())).getCoor();
            System.out.println(way.getNodes().get(i) + "-----" + way.getNodes().get((i + 1) % way.getNodesCount()));
            double minDistanceSq = 5.0E-6;
            List nodes = Main.getLayerManager().getEditDataSet().searchNodes(new BBox(Math.min(n1.getX(), n2.getX()) - minDistanceSq, Math.min(n1.getY(), n2.getY()) - minDistanceSq, Math.max(n1.getX(), n2.getX()) + minDistanceSq, Math.max(n1.getY(), n2.getY()) + minDistanceSq));
            Node nearestNode = null;
            for (Node nod : nodes) {
                if (!nod.isUsable() || way.containsNode(nod) || !ConnectWays.isInBuilding(nod)) continue;
                LatLon nn = nod.getCoor();
                double dist = TracerGeometry.distanceFromSegment(nn, n1, n2);
                double angle = TracerGeometry.angleOfLines(n1, nn, nn, n2);
                System.out.println("Angle: " + angle + " distance: " + dist + " Node: " + nod);
                if (n1.equalsEpsilon(nn) || n2.equalsEpsilon(nn) || !(dist < minDistanceSq)) continue;
                nearestNode = nod;
            }
            System.out.println("Nearest_: " + nearestNode);
            System.out.println("");
            if (nearestNode == null) {
                ++i;
                continue;
            }
            way.addNode(i + 1, nearestNode);
        }
        return way;
    }

    private static boolean isInBuilding(Node n) {
        for (OsmPrimitive op : n.getReferrers()) {
            if (!(op instanceof Way) || !ConnectWays.isBuilding((Way)op)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBuilding(Way w) {
        return w.getKeys().get((Object)"building") == null ? false : w.getKeys().get((Object)"building").equals("yes");
    }
}

