/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.tools.I18n;
import relcontext.actions.PublicTransportHelper;
import relcontext.relationfix.RelationFixer;

public class PublicTransportFixer
extends RelationFixer {
    public PublicTransportFixer() {
        super("route", "public_transport");
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType().equals((Object)OsmPrimitiveType.NODE) && !m.getRole().startsWith("stop") && !m.getRole().startsWith("platform")) {
                this.setWarningMessage(I18n.tr((String)"Node without ''stop'' or ''platform'' role found", (Object[])new Object[0]));
                return false;
            }
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || !PublicTransportHelper.isWayPlatform(m) || m.getRole().startsWith("platform")) continue;
            this.setWarningMessage(I18n.tr((String)"Way platform without ''platform'' role found", (Object[])new Object[0]) + " r" + m.getUniqueId());
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        Relation r = rel;
        Relation rr = this.fixStopPlatformRole(r);
        boolean fixed = false;
        if (rr != null) {
            fixed = true;
            r = rr;
        }
        return fixed ? new ChangeCommand((OsmPrimitive)rel, (OsmPrimitive)r) : null;
    }

    private Relation fixStopPlatformRole(Relation source) {
        Relation r = new Relation(source);
        boolean fixed = false;
        for (int i = 0; i < r.getMembersCount(); ++i) {
            RelationMember m = r.getMember(i);
            String role = PublicTransportHelper.getRoleByMember(m);
            if (role == null || m.getRole().startsWith(role)) continue;
            r.setMember(i, new RelationMember(role, m.getMember()));
            fixed = true;
        }
        return fixed ? r : null;
    }
}

