/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BLane;

public class BLanes
implements Serializable {
    String type;
    List<BLane> lanes = new ArrayList<BLane>();

    public BLanes() {
    }

    public BLanes(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.changeDirectionLanes(type);
    }

    public List<BLane> getLanes() {
        return this.lanes;
    }

    public void setLanes(List<BLane> newLanes) {
        TreeMap<Integer, BLane> map = new TreeMap<Integer, BLane>();
        for (int i = 0; i < newLanes.size(); ++i) {
            map.put(newLanes.get(i).getPosition(), newLanes.get(i));
        }
        ArrayList listLs = new ArrayList(map.values());
        this.lanes = listLs;
    }

    public String getTagturns() {
        String tagturns = "";
        for (int i = 0; i < this.lanes.size(); ++i) {
            tagturns = i == 0 ? this.lanes.get(i).getTurn() : tagturns + "|" + this.lanes.get(i).getTurn();
        }
        return tagturns;
    }

    public void setStringLanes(String type, String turnLanes) {
        String[] turns = turnLanes.split("\\|", -1);
        ArrayList<BLane> lst = new ArrayList<BLane>();
        for (int i = 0; i < turns.length; ++i) {
            if (turns[i].equals("none")) {
                turns[i] = "";
            } else if (turns[i].indexOf(";") > 0) {
                turns[i] = this.sortTurns(turns[i]);
            }
            BLane bLine = new BLane(type, i + 1, turns[i]);
            lst.add(bLine);
        }
        this.lanes = lst;
    }

    private String sortTurns(String roadTurns) {
        List<String> turnsList = Arrays.asList("reverse", "sharp_left", "left", "slight_left", "merge_to_right", "through", "reversible", "merge_to_left", "slight_right", "right", "sharp_right");
        List<String> roadTurnsList = Arrays.asList(roadTurns.split(";"));
        ArrayList<String> newRoadTurns = new ArrayList<String>();
        for (String e : turnsList) {
            if (roadTurnsList.indexOf(e) <= -1) continue;
            newRoadTurns.add(e);
        }
        return ((Object)newRoadTurns).toString().replaceAll("\\[|\\]", "").replaceAll(", ", ";");
    }

    public void changeDirectionLanes(String Type2) {
        for (int k = 0; k < this.lanes.size(); ++k) {
            this.lanes.get(k).setType(this.type);
        }
    }
}

