/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import model.IndoorHelperModel;
import model.TagCatalog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import views.FittingView;
import views.LevelSelectorView;
import views.ToolBoxView;

public class IndoorHelperController {
    private IndoorHelperModel model;
    private ToolBoxView toolboxView;
    private FittingView fittingView;
    private LevelSelectorView selectorView;
    private String sep = System.getProperty("file.separator");
    private int lastLevelIndex = 0;

    public IndoorHelperController() {
        this.model = new IndoorHelperModel();
        this.toolboxView = new ToolBoxView();
        this.addToolboxListeners();
        Main.map.addToggleDialog((ToggleDialog)this.toolboxView);
    }

    private void addToolboxListeners() {
        if (this.toolboxView != null) {
            this.toolboxView.setPowerButtonListener(new ToolPowerButtonListener());
            this.toolboxView.setApplyButtonListener(new ToolApplyButtonListener());
            this.toolboxView.setLevelItemListener(new ToolLevelItemListener());
            this.toolboxView.setObjectItemListener(new ToolObjectItemListener());
            this.toolboxView.setPreset1Listener(new Preset1Listener());
            this.toolboxView.setPreset2Listener(new Preset2Listener());
            this.toolboxView.setPreset3Listener(new Preset3Listener());
            this.toolboxView.setPreset4Listener(new Preset4Listener());
        }
    }

    private void addLevelSelectorListeners() {
        if (this.selectorView != null) {
            this.selectorView.setOkButtonListener(new LevelOkButtonListener());
            this.selectorView.setCancelButtonListener(new LevelCancelButtonListener());
        }
    }

    private void addFittingListeners() {
        if (this.fittingView != null) {
            this.fittingView.setOkButtonListener(new FittingOkButtonListener());
        }
    }

    private void refreshPresets() {
        this.toolboxView.setPresetButtons(this.model.getPresetRanking());
    }

    private void setPluginPreferences(boolean enabled) {
        Map settings = Main.pref.getAllSettings();
        MapListSetting validatorMapListSetting = (MapListSetting)settings.get("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries");
        List validatorMaps = new ArrayList();
        if (validatorMapListSetting != null) {
            validatorMaps = (List)validatorMapListSetting.getValue();
        }
        MapListSetting styleMapListSetting = (MapListSetting)settings.get("mappaint.style.entries");
        List styleMaps = new ArrayList();
        if (styleMapListSetting != null) {
            styleMaps = (List)styleMapListSetting.getValue();
        }
        if (enabled) {
            ArrayList validatorMapsNew = new ArrayList();
            if (!validatorMaps.isEmpty()) {
                validatorMapsNew.addAll(validatorMaps);
            }
            for (Map map : validatorMapsNew) {
                if (!map.containsValue("Indoor")) continue;
                validatorMapsNew.remove(map);
                break;
            }
            HashMap<String, String> indoorValidator = new HashMap<String, String>();
            indoorValidator.put("title", "Indoor");
            indoorValidator.put("active", "true");
            indoorValidator.put("url", Main.pref.getUserDataDirectory() + this.sep + "validator" + this.sep + "indoorhelper.validator.mapcss");
            validatorMapsNew.add(indoorValidator);
            Main.pref.putListOfStructs("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", validatorMapsNew);
            ArrayList styleMapsNew = new ArrayList();
            if (!styleMaps.isEmpty()) {
                styleMapsNew.addAll(styleMaps);
            }
            for (Map map : styleMapsNew) {
                if (!map.containsValue("Indoor")) continue;
                styleMapsNew.remove(map);
                break;
            }
            HashMap<String, String> indoorMapPaint = new HashMap<String, String>();
            indoorMapPaint.put("title", "Indoor");
            indoorMapPaint.put("active", "true");
            indoorMapPaint.put("url", Main.pref.getUserDataDirectory() + this.sep + "styles" + this.sep + "indoor.mapcss");
            styleMapsNew.add(indoorMapPaint);
            Main.pref.putListOfStructs("mappaint.style.entries", styleMapsNew);
            this.updateSettings();
        } else {
            ArrayList validatorMapsNew = new ArrayList();
            if (!validatorMaps.isEmpty()) {
                validatorMapsNew.addAll(validatorMaps);
            }
            for (Map map : validatorMapsNew) {
                if (!map.containsValue("Indoor")) continue;
                validatorMapsNew.remove(map);
                break;
            }
            HashMap<String, String> indoorValidator = new HashMap<String, String>();
            indoorValidator.put("title", "Indoor");
            indoorValidator.put("active", "false");
            indoorValidator.put("url", Main.pref.getUserDataDirectory() + this.sep + "validator" + this.sep + "indoorhelper.validator.mapcss");
            validatorMapsNew.add(indoorValidator);
            Main.pref.putListOfStructs("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", validatorMapsNew);
            ArrayList styleMapsNew = new ArrayList();
            if (!styleMaps.isEmpty()) {
                styleMapsNew.addAll(styleMaps);
            }
            for (Map map : styleMapsNew) {
                if (!map.containsValue("Indoor")) continue;
                styleMapsNew.remove(map);
                break;
            }
            HashMap<String, String> indoorMapPaint = new HashMap<String, String>();
            indoorMapPaint.put("title", "Indoor");
            indoorMapPaint.put("active", "false");
            indoorMapPaint.put("url", Main.pref.getUserDataDirectory() + this.sep + "styles" + this.sep + "indoor.mapcss");
            styleMapsNew.add(indoorMapPaint);
            Main.pref.putListOfStructs("mappaint.style.entries", styleMapsNew);
            this.updateSettings();
        }
    }

    private void updateSettings() {
        Main.pref.init(false);
        MapCSSTagChecker tagChecker = (MapCSSTagChecker)OsmValidator.getTest(MapCSSTagChecker.class);
        if (tagChecker != null) {
            OsmValidator.initializeTests(Collections.singleton(tagChecker));
        }
        MapPaintStyles.readFromPreferences();
    }

    class FittingOkButtonListener
    implements ActionListener {
        FittingOkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.fittingView.dispose();
            IndoorHelperController.this.toolboxView.setAllUiElementsEnabled(true);
            IndoorHelperController.this.toolboxView.setTagUiElementsEnabled(false);
        }
    }

    class LevelCancelButtonListener
    implements ActionListener {
        LevelCancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.selectorView.dispose();
            IndoorHelperController.this.toolboxView.setPowerButtonDisabled();
            IndoorHelperController.this.setPluginPreferences(false);
        }
    }

    class LevelOkButtonListener
    implements ActionListener {
        LevelOkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean levelSuccess = IndoorHelperController.this.model.setBuildingLevels(IndoorHelperController.this.selectorView.getMin(), IndoorHelperController.this.selectorView.getMax());
            if (levelSuccess) {
                IndoorHelperController.this.toolboxView.setLevelList(IndoorHelperController.this.model.getLevelList());
                IndoorHelperController.this.model.setWorkingLevel(IndoorHelperController.this.toolboxView.getSelectedLevelIndex());
                IndoorHelperController.this.selectorView.dispose();
                IndoorHelperController.this.fittingView = new FittingView();
                IndoorHelperController.this.addFittingListeners();
                IndoorHelperController.this.fittingView.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, "Lowest Level has to be lower than the highest level", "Error", 0);
            }
        }
    }

    class Preset4Listener
    implements ActionListener {
        Preset4Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset4());
        }
    }

    class Preset3Listener
    implements ActionListener {
        Preset3Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset3());
        }
    }

    class Preset2Listener
    implements ActionListener {
        Preset2Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset2());
        }
    }

    class Preset1Listener
    implements ActionListener {
        Preset1Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset1());
        }
    }

    class ToolObjectItemListener
    implements ItemListener {
        ToolObjectItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (IndoorHelperController.this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.ROOM)) {
                IndoorHelperController.this.toolboxView.setTagUiElementsEnabled(true);
            } else {
                IndoorHelperController.this.toolboxView.setTagUiElementsEnabled(false);
            }
        }
    }

    class ToolLevelItemListener
    implements ItemListener {
        ToolLevelItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!IndoorHelperController.this.toolboxView.levelListIsEmpty()) {
                if (!IndoorHelperController.this.toolboxView.getLevelName().isEmpty()) {
                    IndoorHelperController.this.model.getLevelList().get(IndoorHelperController.this.lastLevelIndex).setNameTag(IndoorHelperController.this.toolboxView.getLevelName());
                }
                if (!IndoorHelperController.this.model.getLevelList().get(IndoorHelperController.this.toolboxView.getSelectedLevelIndex()).hasEmptyName()) {
                    IndoorHelperController.this.toolboxView.setLevelName(IndoorHelperController.this.model.getLevelList().get(IndoorHelperController.this.toolboxView.getSelectedLevelIndex()).getName());
                } else {
                    IndoorHelperController.this.toolboxView.setLevelName("");
                }
                IndoorHelperController.this.model.setWorkingLevel(IndoorHelperController.this.toolboxView.getSelectedLevelIndex());
                IndoorHelperController.this.lastLevelIndex = IndoorHelperController.this.toolboxView.getSelectedLevelIndex();
            }
        }
    }

    class ToolApplyButtonListener
    implements ActionListener {
        ToolApplyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagCatalog.IndoorObject indoorObject = IndoorHelperController.this.toolboxView.getSelectedObject();
            if (IndoorHelperController.this.toolboxView.getNameText().isEmpty() && IndoorHelperController.this.toolboxView.getRefText().isEmpty() && IndoorHelperController.this.toolboxView.getLevelName().isEmpty()) {
                IndoorHelperController.this.model.addTagsToOSM(indoorObject);
            } else {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                if (!IndoorHelperController.this.toolboxView.getLevelName().isEmpty()) {
                    IndoorHelperController.this.model.getLevelList().get(IndoorHelperController.this.toolboxView.getSelectedLevelIndex()).setNameTag(IndoorHelperController.this.toolboxView.getLevelName());
                }
                if (!IndoorHelperController.this.toolboxView.getNameText().isEmpty()) {
                    tags.add(new Tag("name", IndoorHelperController.this.toolboxView.getNameText()));
                }
                if (!IndoorHelperController.this.toolboxView.getRefText().isEmpty()) {
                    tags.add(new Tag("ref", IndoorHelperController.this.toolboxView.getRefText()));
                }
                IndoorHelperController.this.model.addTagsToOSM(indoorObject, tags);
            }
            ValidateAction validateAction = new ValidateAction();
            validateAction.doValidate(true);
            IndoorHelperController.this.refreshPresets();
        }
    }

    class ToolPowerButtonListener
    implements ActionListener {
        ToolPowerButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.toolboxView.getPowerButtonState()) {
                IndoorHelperController.this.selectorView = new LevelSelectorView();
                IndoorHelperController.this.addLevelSelectorListeners();
                IndoorHelperController.this.selectorView.setVisible(true);
                IndoorHelperController.this.setPluginPreferences(true);
            } else if (!IndoorHelperController.this.toolboxView.getPowerButtonState()) {
                IndoorHelperController.this.model = new IndoorHelperModel();
                IndoorHelperController.this.selectorView.dispose();
                IndoorHelperController.this.toolboxView.reset();
                IndoorHelperController.this.setPluginPreferences(false);
                FilterDialog filterDialog = (FilterDialog)Main.map.getToggleDialog(FilterDialog.class);
                if (filterDialog != null) {
                    FilterTableModel filterTableModel = filterDialog.getFilterModel();
                    for (int i = filterTableModel.getRowCount() - 1; i > -1; --i) {
                        if (!filterTableModel.getFilter((int)i).text.startsWith("\"indoor:level\"=\"")) continue;
                        filterTableModel.removeFilter(i);
                    }
                }
            }
        }
    }
}

