/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsDialog
extends ToggleDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 6183400754671501117L;
    private JLabel statusLabel;
    private JLabel wayLabel;
    private JLabel latLabel;
    private JLabel longLabel;
    private JLabel courseLabel;
    private JLabel speedLabel;
    private JPanel panel = new JPanel();
    private LiveGpsStatus status;
    private LiveGpsData data;

    public LiveGpsDialog(MapFrame mapFrame) {
        super(I18n.tr((String)"Live GPS", (Object[])new Object[0]), "livegps", I18n.tr((String)"Show GPS data.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:livegps", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Live GPS", (Object[])new Object[0])}), (int)71, (int)5010), 100);
        this.panel.setLayout(new GridLayout(6, 2));
        this.panel.add(new JLabel(I18n.tr((String)"Status", (Object[])new Object[0])));
        this.statusLabel = new JLabel();
        this.panel.add(this.statusLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Way Info", (Object[])new Object[0])));
        this.wayLabel = new JLabel();
        this.panel.add(this.wayLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Latitude", (Object[])new Object[0])));
        this.latLabel = new JLabel();
        this.panel.add(this.latLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Longitude", (Object[])new Object[0])));
        this.longLabel = new JLabel();
        this.panel.add(this.longLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Speed", (Object[])new Object[0])));
        this.speedLabel = new JLabel();
        this.panel.add(this.speedLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Course", (Object[])new Object[0])));
        this.courseLabel = new JLabel();
        this.panel.add(this.courseLabel);
        this.createLayout(this.panel, true, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.data = (LiveGpsData)evt.getNewValue();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LiveGpsDialog.this.data.isFix()) {
                        LiveGpsDialog.this.panel.setBackground(Color.WHITE);
                        LiveGpsDialog.this.latLabel.setText(LiveGpsDialog.this.data.getLatitude() + "deg");
                        LiveGpsDialog.this.longLabel.setText(LiveGpsDialog.this.data.getLongitude() + "deg");
                        double mySpeed = LiveGpsDialog.this.data.getSpeed() * 3.6f;
                        LiveGpsDialog.this.speedLabel.setText(Math.round(mySpeed * 100.0) / 100L + "km/h");
                        LiveGpsDialog.this.courseLabel.setText(LiveGpsDialog.this.data.getCourse() + "deg");
                        String wayString = LiveGpsDialog.this.data.getWayInfo();
                        if (wayString.length() > 0) {
                            LiveGpsDialog.this.wayLabel.setText(wayString);
                        } else {
                            LiveGpsDialog.this.wayLabel.setText(I18n.tr((String)"unknown", (Object[])new Object[0]));
                        }
                    } else {
                        LiveGpsDialog.this.latLabel.setText("");
                        LiveGpsDialog.this.longLabel.setText("");
                        LiveGpsDialog.this.speedLabel.setText("");
                        LiveGpsDialog.this.courseLabel.setText("");
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    }
                }
            });
        } else if ("gpsstatus".equals(evt.getPropertyName())) {
            this.status = (LiveGpsStatus)evt.getNewValue();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveGpsDialog.this.statusLabel.setText(LiveGpsDialog.this.status.getStatusMessage());
                    if (LiveGpsDialog.this.status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    } else {
                        LiveGpsDialog.this.panel.setBackground(Color.WHITE);
                    }
                }
            });
        }
    }
}

