/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.actions.WalkListener;
import org.openstreetmap.josm.plugins.mapillary.actions.WalkThread;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryImageDisplay;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryPreferenceSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryMainDialog
extends ToggleDialog
implements ICachedLoaderListener,
MapillaryDataListener {
    private static final long serialVersionUID = 6856496736429480600L;
    private static final String BASE_TITLE = I18n.marktr((String)"Mapillary picture");
    private static MapillaryMainDialog instance;
    private volatile MapillaryAbstractImage image;
    private final SideButton nextButton = new SideButton((Action)new NextPictureAction());
    private final SideButton previousButton = new SideButton((Action)new PreviousPictureAction());
    public final SideButton redButton = new SideButton((Action)new RedAction());
    public final SideButton blueButton = new SideButton((Action)new BlueAction());
    private final SideButton playButton = new SideButton((Action)new PlayAction());
    private final SideButton pauseButton = new SideButton((Action)new PauseAction());
    private final SideButton stopButton = new SideButton((Action)new StopAction());
    public MapillaryImageDisplay mapillaryImageDisplay;
    private MapillaryCache imageCache;
    private MapillaryCache thumbnailCache;

    private MapillaryMainDialog() {
        super(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]), "mapillary-main.svg", I18n.tr((String)"Open Mapillary window", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Mapillary dialog", (Object[])new Object[0]), (String)I18n.tr((String)"Open Mapillary main dialog", (Object[])new Object[0]), (int)77, (int)5000), 200, false, MapillaryPreferenceSetting.class);
        this.addShortcuts();
        this.mapillaryImageDisplay = new MapillaryImageDisplay();
        this.blueButton.setForeground(Color.BLUE);
        this.redButton.setForeground(Color.RED);
        this.setMode(MODE.NORMAL);
    }

    private void addShortcuts() {
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_DOWN"), "next");
        this.nextButton.getActionMap().put("next", new NextPictureAction());
        this.previousButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_UP"), "previous");
        this.previousButton.getActionMap().put("previous", new PreviousPictureAction());
        this.blueButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_UP"), "blue");
        this.blueButton.getActionMap().put("blue", new BlueAction());
        this.redButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "red");
        this.redButton.getActionMap().put("red", new RedAction());
    }

    public static synchronized MapillaryMainDialog getInstance() {
        if (instance == null) {
            instance = new MapillaryMainDialog();
        }
        return instance;
    }

    public void setMode(MODE mode) {
        switch (mode) {
            case WALK: {
                this.createLayout(this.mapillaryImageDisplay, Arrays.asList(this.playButton, this.pauseButton, this.stopButton));
                break;
            }
            default: {
                this.createLayout(this.mapillaryImageDisplay, Arrays.asList(this.blueButton, this.previousButton, this.nextButton, this.redButton));
            }
        }
        this.disableAllButtons();
        if (MODE.NORMAL.equals((Object)mode)) {
            this.updateImage();
        }
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    public synchronized void updateImage() {
        this.updateImage(true);
    }

    public synchronized void updateImage(boolean fullQuality) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryMainDialog.this.updateImage();
                }
            });
        } else {
            MapillaryAbstractImage mapillaryImage;
            MapillaryAbstractImage tempImage;
            if (!MapillaryLayer.hasInstance()) {
                return;
            }
            if (this.image == null) {
                this.mapillaryImageDisplay.setImage(null);
                this.setTitle(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
                this.disableAllButtons();
                return;
            }
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            if (this.image.getSequence() != null) {
                tempImage = this.image;
                while (tempImage.next() != null) {
                    if (!(tempImage = tempImage.next()).isVisible()) continue;
                    this.nextButton.setEnabled(true);
                    break;
                }
            }
            if (this.image.getSequence() != null) {
                tempImage = this.image;
                while (tempImage.previous() != null) {
                    if (!(tempImage = tempImage.previous()).isVisible()) continue;
                    this.previousButton.setEnabled(true);
                    break;
                }
            }
            if (this.image instanceof MapillaryImage) {
                this.mapillaryImageDisplay.hyperlink.setVisible(true);
                mapillaryImage = (MapillaryImage)this.image;
                this.mapillaryImageDisplay.hyperlink.setURL(((MapillaryImage)mapillaryImage).getKey());
                this.mapillaryImageDisplay.setImage(null);
                if (this.thumbnailCache != null) {
                    this.thumbnailCache.cancelOutstandingTasks();
                }
                this.thumbnailCache = new MapillaryCache(((MapillaryImage)mapillaryImage).getKey(), MapillaryCache.Type.THUMBNAIL);
                try {
                    this.thumbnailCache.submit(this, false);
                }
                catch (IOException e) {
                    Main.error((Throwable)e);
                }
                if (fullQuality || new MapillaryCache(((MapillaryImage)mapillaryImage).getKey(), MapillaryCache.Type.FULL_IMAGE).get() != null) {
                    if (this.imageCache != null) {
                        this.imageCache.cancelOutstandingTasks();
                    }
                    this.imageCache = new MapillaryCache(((MapillaryImage)mapillaryImage).getKey(), MapillaryCache.Type.FULL_IMAGE);
                    try {
                        this.imageCache.submit(this, false);
                    }
                    catch (IOException e) {
                        Main.error((Throwable)e);
                    }
                }
            } else if (this.image instanceof MapillaryImportedImage) {
                this.mapillaryImageDisplay.hyperlink.setVisible(false);
                this.mapillaryImageDisplay.hyperlink.setURL(null);
                mapillaryImage = (MapillaryImportedImage)this.image;
                try {
                    this.mapillaryImageDisplay.setImage(((MapillaryImportedImage)mapillaryImage).getImage());
                }
                catch (IOException e) {
                    Main.error((Throwable)e);
                }
            }
            this.updateTitle();
        }
    }

    private void disableAllButtons() {
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.blueButton.setEnabled(false);
        this.redButton.setEnabled(false);
        this.mapillaryImageDisplay.hyperlink.setVisible(false);
    }

    public synchronized void setImage(MapillaryAbstractImage image) {
        this.image = image;
    }

    public synchronized void updateTitle() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryMainDialog.this.updateTitle();
                }
            });
        } else if (this.image != null) {
            StringBuilder title = new StringBuilder(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
            if (this.image instanceof MapillaryImage) {
                MapillaryImage mapillaryImage = (MapillaryImage)this.image;
                if (mapillaryImage.getUser() != null) {
                    title.append(" \u2014 ").append(mapillaryImage.getUser());
                }
                if (mapillaryImage.getCapturedAt() != 0L) {
                    title.append(" \u2014 ").append(mapillaryImage.getDate());
                }
                this.setTitle(title.toString());
            } else if (this.image instanceof MapillaryImportedImage) {
                MapillaryImportedImage mapillaryImportedImage = (MapillaryImportedImage)this.image;
                title.append(" \u2014 ").append(mapillaryImportedImage.getFile().getName());
                title.append(" \u2014 ").append(mapillaryImportedImage.getDate());
                this.setTitle(title.toString());
            }
        }
    }

    public synchronized MapillaryAbstractImage getImage() {
        return this.image;
    }

    public void loadingFinished(final CacheEntry data, final CacheEntryAttributes attributes, final ICachedLoaderListener.LoadResult result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryMainDialog.this.loadingFinished(data, attributes, result);
                }
            });
        } else if (data != null && result == ICachedLoaderListener.LoadResult.SUCCESS) {
            try {
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(data.getContent()));
                if (img == null) {
                    return;
                }
                if (this.mapillaryImageDisplay.getImage() == null || img.getHeight() > this.mapillaryImageDisplay.getImage().getHeight()) {
                    this.mapillaryImageDisplay.setImage(img);
                }
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }

    public void createLayout(Component data, List<SideButton> buttons) {
        this.removeAll();
        this.createLayout(data, true, buttons);
        this.add((Component)this.titleBar, "North");
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        this.setImage(newImage);
        this.updateImage();
    }

    @Override
    public void imagesAdded() {
    }

    private class PauseAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = 4400240686337741192L;
        private WalkThread thread;

        public PauseAction() {
            this.putValue("Name", I18n.tr((String)"Pause", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Pauses the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/mapillaryPause.png").getResource().attachImageIcon((AbstractAction)this, true);
            MapillaryPlugin.getWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.thread.pause();
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    private class PlayAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -17943404752082788L;
        private transient WalkThread thread;

        public PlayAction() {
            this.putValue("Name", I18n.tr((String)"Play", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Continues with the paused walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/mapillaryPlay.png").getResource().attachImageIcon((AbstractAction)this, true);
            MapillaryPlugin.getWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.play();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            if (thread != null) {
                this.thread = thread;
            }
        }
    }

    private class StopAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -6561451575815789198L;
        private WalkThread thread;

        public StopAction() {
            this.putValue("Name", I18n.tr((String)"Stop", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Stops the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/mapillaryStop.png").getResource().attachImageIcon((AbstractAction)this, true);
            MapillaryPlugin.getWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.stopWalk();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    private class BlueAction
    extends AbstractAction {
        private static final long serialVersionUID = 6250690644594703314L;

        public BlueAction() {
            this.putValue("Name", I18n.tr((String)"Jump to blue", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the blue line", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryMainDialog.getInstance().getImage() != null) {
                MapillaryLayer.getInstance().getData().setSelectedImage(MapillaryLayer.getInstance().getBlue(), true);
            }
        }
    }

    private class RedAction
    extends AbstractAction {
        private static final long serialVersionUID = -6480229431481386376L;

        public RedAction() {
            this.putValue("Name", I18n.tr((String)"Jump to red", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the red line", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryMainDialog.getInstance().getImage() != null) {
                MapillaryLayer.getInstance().getData().setSelectedImage(MapillaryLayer.getInstance().getRed(), true);
            }
        }
    }

    private class PreviousPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = -6420511632957956012L;

        public PreviousPictureAction() {
            this.putValue("Name", I18n.tr((String)"Previous picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapillaryLayer.getInstance().getData().selectPrevious();
        }
    }

    private static class NextPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = 3023827221453154340L;

        public NextPictureAction() {
            this.putValue("Name", I18n.tr((String)"Next picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the next picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapillaryLayer.getInstance().getData().selectNext();
        }
    }

    public static enum MODE {
        NORMAL,
        WALK;

    }
}

