/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.renderer;

import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.ImageProvider;

public class BugListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -5888587819204364046L;

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean hasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
        if (value instanceof MapdustBug) {
            String addressStr;
            MapdustBug mapdustBug = (MapdustBug)value;
            String iconPath = "bugs/normal/";
            iconPath = iconPath + mapdustBug.getStatus().getValue().toLowerCase();
            iconPath = iconPath + "_";
            iconPath = iconPath + mapdustBug.getType().getKey() + ".png";
            ImageIcon icon = ImageProvider.get((String)iconPath);
            icon.setDescription(mapdustBug.getType().getValue());
            label.setIcon(ImageProvider.get((String)iconPath));
            String text = "" + mapdustBug.getId() + ": ";
            text = text + mapdustBug.getType().getValue();
            if (mapdustBug.getAddress() != null && !(addressStr = mapdustBug.getAddress().toString()).trim().isEmpty()) {
                text = text + " (" + mapdustBug.getAddress().toString() + " )";
            }
            DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
            text = text + " last modified on ";
            text = text + df.format(mapdustBug.getDateUpdated());
            label.setText(text);
            label.setFont(new Font("Times New Roman", 1, 12));
            label.setSize(200, 20);
        }
        if (value instanceof String) {
            String text = (String)value;
            label.setText(text);
            label.setFont(new Font("Times New Roman", 1, 12));
        }
        return label;
    }
}

